/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DummyExp;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.Scope;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AllMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelMembersCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SetCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;

public class HierarchyMembersCalc
extends AbstractMemberListCalc {
    HierarchyCalc hierarchyCalc;
    Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;
    boolean needNonEmpty = false;

    public HierarchyMembersCalc(Exp exp, HierarchyCalc hierarchyCalc) {
        super(exp, new Calc[]{hierarchyCalc});
        this.hierarchyCalc = hierarchyCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        this.needHierarchize = scope.getNeedHierarchize();
        this.needNonEmpty = scope.isNeedNonEmpty();
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(null);
        Level[] levels = hierarchy.getLevels();
        if (hierarchy.getDimension().isMeasureDimension() || hierarchy.getDimension().isParentChildrenDimension() || hierarchy.getDimension().isTimeDimension()) {
            return super.optimize(scope, evaluator);
        }
        if (levels.length == 1) {
            LevelCalc levelCalc = ConstantCalc.constantLevel(levels[0]);
            return new LevelMembersCalc((Exp)new DummyExp(this.type), levelCalc).optimize(scope, evaluator);
        }
        if (levels.length == 2 && hierarchy.hasAll()) {
            AllMemberCalc allMemberCalc = new AllMemberCalc(null, this.hierarchyCalc);
            LevelCalc levelCalc = ConstantCalc.constantLevel(levels[1]);
            LevelMembersCalc levelMembersCalc = new LevelMembersCalc(null, levelCalc);
            return new SetCalc(new DummyExp(this.type), new Calc[]{allMemberCalc, levelMembersCalc}).optimize(scope, evaluator);
        }
        return super.optimize(scope, evaluator);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        IMemberList members = evaluator.getSchemaReader().getHierarchyMembers(hierarchy, this.needHierarchize != Scope.NeedHierarchize.No);
        if (this.needNonEmpty) {
            members = FuncUtil2.nonFactEmptyMembers(evaluator, members);
        }
        return members;
    }
}

