/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;

public class ParallelPeriodCalc
extends AbstractMemberCalc {
    MemberCalc memberCalc;
    IntegerCalc lagValueCalc;
    LevelCalc ancestorLevelCalc;

    public ParallelPeriodCalc(Exp call, MemberCalc memberCalc, IntegerCalc lagValueCalc, LevelCalc ancestorLevelCalc) {
        super(call, new Calc[]{memberCalc, lagValueCalc, ancestorLevelCalc});
        this.memberCalc = memberCalc;
        this.lagValueCalc = lagValueCalc;
        this.ancestorLevelCalc = ancestorLevelCalc;
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        Level ancestorLevel;
        Member member = this.memberCalc.evaluateMember(evaluator);
        int lagValue = this.lagValueCalc.evaluateInteger(evaluator);
        if (this.ancestorLevelCalc != null) {
            ancestorLevel = this.ancestorLevelCalc.evaluateLevel(evaluator);
        } else {
            Member parent = member.getParentMember();
            if (parent == null) {
                return member.getHierarchy().getNullMember();
            }
            ancestorLevel = parent.getLevel();
        }
        return this.parallelPeriod(member, ancestorLevel, evaluator, lagValue);
    }

    private Member parallelPeriod(Member member, Level ancestorLevel, Evaluator evaluator, int lagValue) throws OlapException {
        int distance = member.getLevel().getDepth() - ancestorLevel.getDepth();
        Member ancestor = FuncUtil2.ancestor(evaluator, member, distance, ancestorLevel);
        Member inLaw = evaluator.getSchemaReader().getLeadMember(ancestor, -lagValue);
        return FuncUtil2.cousin(evaluator.getSchemaReader(), member, inLaw);
    }
}

