/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.collection.ListFactoryFactory;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.BooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberListCalc;

public class SimpleDescendantsCalc
extends AbstractMemberListCalc {
    private MemberCalc memberCalc;
    private BooleanCalc booleanCalc;
    private boolean self = false;

    public SimpleDescendantsCalc(Exp exp, MemberCalc memberCalc, BooleanCalc booleanCalc) {
        super(exp, new Calc[]{memberCalc});
        this.memberCalc = memberCalc;
        this.booleanCalc = booleanCalc;
    }

    public SimpleDescendantsCalc(Exp exp, MemberCalc memberCalc, boolean self) {
        super(exp, new Calc[]{memberCalc});
        this.memberCalc = memberCalc;
        this.self = self;
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        Member member = this.memberCalc.evaluateMember(evaluator);
        if (member.isNull() || member.isLeaf()) {
            return IMemberList.EMPTY;
        }
        if (this.booleanCalc != null) {
            this.self = this.booleanCalc.evaluateBoolean(evaluator);
        }
        IMemberList result = ListFactoryFactory.getListFactory().createMemberList();
        if (this.self) {
            result.add(member);
        }
        evaluator.getSchemaReader().getDescendants(member, result);
        return result;
    }
}

