/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.LinkedList;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Formatter;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpBase;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.FunFactory;
import kd.epm.eb.algo.olap.mdx.FunTable;
import kd.epm.eb.algo.olap.mdx.FuncResolverBase;
import kd.epm.eb.algo.olap.mdx.Literal;
import kd.epm.eb.algo.olap.mdx.MultiFuncResolver;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.TypeConvertUtil;
import kd.epm.eb.algo.olap.mdx.calc.BigDecimalCalc;
import kd.epm.eb.algo.olap.mdx.calc.BooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DimensionCalc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.StringCalc;
import kd.epm.eb.algo.olap.mdx.calc.TupleCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractBigDecimalCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractBooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractDimensionCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractNumberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractStringCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.DimensionCurrentMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.GenericCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.ValueCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AggregateCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AllLeafDescendantsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AncestorLevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AncestorNCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AscendantsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AvgCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.ChidrenCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.CountCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.DimensionFirstMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.DimensionLeafMembersCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.DimensionMembersCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.DistinctCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.ExceptCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.FirstChildCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.FirstSiblingCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.GenerateCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.GenerateStringCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.HeadCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.HierarchizeCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.HierarchyMembersAboveLevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.HierarchyMembersCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.IIfNumberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.IIfStringCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.IfCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LastChildCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LastSiblingCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LeafDescendantsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelFirstMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelLastMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelMembersCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelOrdinalCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LinkValueCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.MaxCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.MemberRangeCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.MinCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.NonEmpty2Calc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.NonEmptyCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.NotLeafDescendantsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.OpeningClosingCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.ParallelPeriodCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.PeriodsToDateCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SiblingsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SimpleDescendantsCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SubsetCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SumCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.TailCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.UnionCalc;
import kd.epm.eb.algo.olap.mdx.elementexp.MemberExpr;
import kd.epm.eb.algo.olap.mdx.func.CoalesceEmptyFunDef;
import kd.epm.eb.algo.olap.mdx.func.CrossJoinFunDef;
import kd.epm.eb.algo.olap.mdx.func.DescendantsFunDef;
import kd.epm.eb.algo.olap.mdx.func.DimensionCurrentMemberFunDef;
import kd.epm.eb.algo.olap.mdx.func.FilterFunDef;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;
import kd.epm.eb.algo.olap.mdx.func.HierarchyCurrentMemberFunDef;
import kd.epm.eb.algo.olap.mdx.func.HierarchyDimensionFunDef;
import kd.epm.eb.algo.olap.mdx.func.IntersectFunDef;
import kd.epm.eb.algo.olap.mdx.func.IrrCalc;
import kd.epm.eb.algo.olap.mdx.func.LevelHierarchyFunDef;
import kd.epm.eb.algo.olap.mdx.func.MemberHierarchyFunDef;
import kd.epm.eb.algo.olap.mdx.func.MemberLevelFunDef;
import kd.epm.eb.algo.olap.mdx.func.NpvCalc;
import kd.epm.eb.algo.olap.mdx.func.OrderFunDef;
import kd.epm.eb.algo.olap.mdx.func.ParenthesesFunDef;
import kd.epm.eb.algo.olap.mdx.func.PropertiesFunDef;
import kd.epm.eb.algo.olap.mdx.func.SetFunDef;
import kd.epm.eb.algo.olap.mdx.func.SetItemFunDef;
import kd.epm.eb.algo.olap.mdx.func.TopBottomCountFunDef;
import kd.epm.eb.algo.olap.mdx.func.TopBottomPercentSumFunDef;
import kd.epm.eb.algo.olap.mdx.func.TupleFunDef;
import kd.epm.eb.algo.olap.mdx.func.TupleItemFunDef;
import kd.epm.eb.algo.olap.mdx.func.ValueFunDef;
import kd.epm.eb.algo.olap.mdx.func.XtdFunDef;
import kd.epm.eb.algo.olap.mdx.type.DimensionType;
import kd.epm.eb.algo.olap.mdx.type.LevelType;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.NumericType;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import kd.epm.eb.algo.olap.util.IntHolder;
import kd.epm.eb.algo.olap.util.UniqueNameUtil;
import kd.epm.eb.algo.olap.util.Util;
import kd.epm.eb.algo.olap.util.ValueNotReady;

public class BaseFunFactory
extends FunFactory {
    public BaseFunFactory(FunTable funTable) {
        super(funTable);
    }

    @Override
    public void defineFunctions() {
        this.define(HierarchyDimensionFunDef.instance);
        this.define(new FunDefBase("Dimension", "<Dimension>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) {
                Dimension dimension = ((Dimension)((Object)call.getArg(0))).getDimension();
                return new ConstantCalc(DimensionType.forDimension(dimension), dimension);
            }
        });
        this.define(new FunDefBase("Dimension", "<Level>.Dimension", "Returns the dimension that contains a specified level.", "pdl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public Dimension evaluateDimension(Evaluator evaluator) throws OlapException {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getDimension();
                    }
                };
            }
        });
        this.define(new FunDefBase("Dimension", "<Member>.Dimension", "Returns the dimension that contains a specified member.", "pdm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Dimension evaluateDimension(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getDimension();
                    }
                };
            }
        });
        this.define(LevelHierarchyFunDef.instance);
        this.define(MemberHierarchyFunDef.instance);
        this.define(MemberLevelFunDef.instance);
        this.define(new FunDefBase("Levels", "<Hierarchy>.Levels(<Numeric Expression>)", "Returns the level whose position in a hierarchy is specified by a numeric expression.", "mlhn"){

            @Override
            public Type getResultType(ExpResolver resolver, Exp[] args) {
                Type argType = args[0].getType();
                return new LevelType(argType.getHierarchy(), argType.getLevel());
            }

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                IntegerCalc ordinalCalc = compiler.compileInteger(call.getArg(1));
                return new LevelsCalc(call, hierarchyCalc, ordinalCalc);
            }
        });
        this.define(new MultiFuncResolver("IsEmpty", "IsEmpty(<Value Expression>)", "Determines if an expression evaluates to the empty cell value.", new String[]{"fbS", "fbn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final Calc calc = compiler.compileScalar(call.getArg(0), true);
                        return new AbstractBooleanCalc(call, new Calc[]{calc}){

                            @Override
                            public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                                Object o = calc.evaluate(evaluator);
                                return o == null || o == Util.nullValue;
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("IS NULL", "<Member> IS NULL", "Returns whether a member is null.", "pbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null) {
                            return true;
                        }
                        return member.isNull();
                    }
                };
            }
        });
        this.define(new FunDefBase("IsNull", "IsNull(<Member>)", "Determines if a member is null.", "fbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null) {
                            return true;
                        }
                        return member.isNull();
                    }
                };
            }
        });
        this.define(new FunDefBase("IsLeaf", "IsLeaf(<Member>)", "Determines if a member is leaf.", "fbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.isLeaf();
                    }
                };
            }
        });
        this.define(new FunDefBase("IsAncestor", "IsAncestor(<Member>, <Member>)", "Determines if left member is ancestor of right member.", "fbmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc0 = compiler.compileMember(call.getArg(0));
                final MemberCalc memberCalc1 = compiler.compileMember(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc0, memberCalc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        Member member0 = memberCalc0.evaluateMember(evaluator);
                        Member member1 = memberCalc1.evaluateMember(evaluator);
                        for (Member parent = member1.getParentMember(); parent != null; parent = parent.getParentMember()) {
                            if (!member0.equals(parent)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        });
        this.define(DimensionCurrentMemberFunDef.instance);
        this.define(HierarchyCurrentMemberFunDef.instance);
        this.define(new FunDefBase("DefaultMember", "<Dimension>.DefaultMember", "Returns the default member of a dimension.", "pmd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{dimensionCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return evaluator.getSchemaReader().getHierarchyDefaultMember(dimension.getDefaultHierarchy());
                    }
                };
            }
        });
        this.define(new FunDefBase("FirstMember", "<Dimension>.FirstMember", "Returns the first member of a dimension.", "pmd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionFirstMemberCalc((Exp)call, dimensionCalc);
            }
        });
        this.define(new FunDefBase("FirstChild", "<Member>.FirstChild", "Returns the first child of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new FirstChildCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("FirstSibling", "<Member>.FirstSibling", "Returns the first child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new FirstSiblingCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("LastChild", "<Member>.LastChild", "Returns the last child of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LastChildCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("LastSibling", "<Member>.LastSibling", "Returns the last child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LastSiblingCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("Lead", "<Member>.Lead(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", "mmmn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, integerCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        int n = integerCalc.evaluateInteger(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, n);
                    }
                };
            }
        });
        this.define(new FunDefBase("Lag", "<Member>.Lag(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", "mmmn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, integerCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        int n = integerCalc.evaluateInteger(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -n);
                    }
                };
            }
        });
        this.define(new FunDefBase("NextMember", "<Member>.NextMember", "Returns the next member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, 1);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("OpeningPeriod", "OpeningPeriod([<Level>[, <Member>]])", "Returns the first descendant of a member at a level.", new String[]{"fm", "fml", "fmlm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getSchemaReader().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new OlapException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                            }
                            Hierarchy hierarchy = timeDimension.getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        Dimension levelDimension;
                        Dimension memberDimension;
                        LevelCalc levelCalc;
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        Dimension defaultTimeDimension = null;
                        switch (args.length) {
                            case 0: {
                                defaultTimeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new OlapException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                levelCalc = null;
                                break;
                            }
                            case 1: {
                                defaultTimeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new OlapException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                break;
                            }
                            default: {
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = compiler.compileMember(call.getArg(1));
                            }
                        }
                        if (levelCalc != null && !(memberDimension = memberCalc.getType().getHierarchy().getDimension()).equals(levelDimension = levelCalc.getType().getHierarchy().getDimension())) {
                            throw new OlapException("OpeningPeriod level and member must in same dimension.");
                        }
                        return new OpeningClosingCalc(call, levelCalc, memberCalc, true);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("ClosingPeriod", "ClosingPeriod([<Level>[, <Member>]])", "Returns the last descendant of a member at a level.", new String[]{"fm", "fml", "fmlm", "fmm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getSchemaReader().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new OlapException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                            }
                            Hierarchy hierarchy = resolver.getSchemaReader().getCube().getTimeDimension().getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        Dimension levelDimension;
                        Dimension memberDimension;
                        LevelCalc levelCalc;
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        Dimension defaultTimeDimension = null;
                        switch (args.length) {
                            case 0: {
                                defaultTimeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new OlapException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                levelCalc = null;
                                break;
                            }
                            case 1: {
                                defaultTimeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new OlapException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                break;
                            }
                            default: {
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = compiler.compileMember(call.getArg(1));
                            }
                        }
                        if (levelCalc != null && !(memberDimension = memberCalc.getType().getHierarchy().getDimension()).equals(levelDimension = levelCalc.getType().getHierarchy().getDimension())) {
                            throw new OlapException("ClosingPeriod level and member must in same dimension.");
                        }
                        return new OpeningClosingCalc(call, levelCalc, memberCalc, false);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("ParallelPeriod", "ParallelPeriod([<Level>[, <Numeric Expression>[, <Member>]]])", "Returns a member from a prior period in the same relative position as a specified member.", new String[]{"fm", "fml", "fmln", "fmlnm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
                        if (args.length == 0) {
                            Hierarchy hierarchy = resolver.getSchemaReader().getCube().getTimeDimension().getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        switch (args.length) {
                            case 3: {
                                memberCalc = compiler.compileMember(args[2]);
                                break;
                            }
                            case 1: {
                                Dimension dimension = args[0].getType().getHierarchy().getDimension();
                                memberCalc = new DimensionCurrentMemberCalc(dimension);
                                break;
                            }
                            default: {
                                Dimension timeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                                memberCalc = new DimensionCurrentMemberCalc(timeDimension);
                            }
                        }
                        IntegerCalc lagValueCalc = args.length >= 2 ? compiler.compileInteger(args[1]) : ConstantCalc.constantInteger(1);
                        LevelCalc ancestorLevelCalc = args.length >= 1 ? compiler.compileLevel(args[0]) : null;
                        return new ParallelPeriodCalc(call, memberCalc, lagValueCalc, ancestorLevelCalc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Year", "Year(<Numeric Expression>)", "", "fnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc bigDecimalCalc = compiler.compileBigDecimal(call.getArg(0));
                return new AbstractBigDecimalCalc(call, new Calc[]{bigDecimalCalc}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal bigDecimal = bigDecimalCalc.evaluateBigDecimal(evaluator);
                        if (bigDecimal == null) {
                            return null;
                        }
                        long timestamp = bigDecimal.longValue();
                        Instant instant = Instant.ofEpochMilli(timestamp);
                        LocalDate date = instant.atZone(ZoneId.systemDefault()).toLocalDate();
                        YearMonth yearMonth = YearMonth.from(date);
                        return BigDecimal.valueOf(yearMonth.getYear());
                    }
                };
            }
        });
        this.define(new FunDefBase("Month", "Month(<Numeric Expression>)", "", "fnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc bigDecimalCalc = compiler.compileBigDecimal(call.getArg(0));
                return new AbstractBigDecimalCalc(call, new Calc[]{bigDecimalCalc}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal bigDecimal = bigDecimalCalc.evaluateBigDecimal(evaluator);
                        if (bigDecimal == null) {
                            return null;
                        }
                        long timestamp = bigDecimal.longValue();
                        Instant instant = Instant.ofEpochMilli(timestamp);
                        LocalDate date = instant.atZone(ZoneId.systemDefault()).toLocalDate();
                        YearMonth yearMonth = YearMonth.from(date);
                        int formattedMonth = yearMonth.getYear() * 100 + yearMonth.getMonthValue();
                        return BigDecimal.valueOf(formattedMonth);
                    }
                };
            }
        });
        this.define(new FunDefBase("Date", "Date(Member)", "", "fnm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBigDecimalCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null || member.getProperty("date") == null) {
                            return null;
                        }
                        return BigDecimal.valueOf((Long)member.getProperty("date"));
                    }
                };
            }
        });
        this.define(new FunDefBase("Date", "Date(<Numeric Expression>)", "", "fnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                return compiler.compileBigDecimal(call.getArg(0));
            }
        });
        this.define(new FunDefBase("DateDif", "DateDif(Date,Date,type(String))", "", "fnnnS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc dateCalc1 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc dateCalc2 = compiler.compileBigDecimal(call.getArg(1));
                final StringCalc typeCalc = compiler.compileString(call.getArg(2));
                return new AbstractBigDecimalCalc(call, new Calc[]{dateCalc1, dateCalc2, typeCalc}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal date1 = dateCalc1.evaluateBigDecimal(evaluator);
                        BigDecimal date2 = dateCalc2.evaluateBigDecimal(evaluator);
                        String type = typeCalc.evaluateString(evaluator);
                        if (date1 == null || date2 == null) {
                            return null;
                        }
                        long timestamp1 = date1.longValue();
                        long timestamp2 = date2.longValue();
                        Instant instant1 = Instant.ofEpochMilli(timestamp1);
                        Instant instant2 = Instant.ofEpochMilli(timestamp2);
                        LocalDate localDate1 = instant1.atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate localDate2 = instant2.atZone(ZoneId.systemDefault()).toLocalDate();
                        if ("D".equalsIgnoreCase(type)) {
                            return BigDecimal.valueOf(Duration.between(localDate1.atStartOfDay(), localDate2.atStartOfDay()).toDays());
                        }
                        if ("M".equalsIgnoreCase(type)) {
                            return BigDecimal.valueOf(Period.between(localDate1.withDayOfMonth(1), localDate2.withDayOfMonth(1)).toTotalMonths());
                        }
                        if ("Y".equalsIgnoreCase(type)) {
                            return BigDecimal.valueOf(localDate1.until(localDate2).getYears());
                        }
                        return null;
                    }
                };
            }
        });
        this.define(new FunDefBase("Parent", "<Member>.Parent", "Returns the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member parent = evaluator.getSchemaReader().getMemberParent(member);
                        if (parent == null) {
                            parent = member.getHierarchy().getNullMember();
                        }
                        return parent;
                    }
                };
            }
        });
        this.define(new FunDefBase("PrevMember", "<Member>.PrevMember", "Returns the previous member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -1);
                    }
                };
            }
        });
        this.define(new FunDefBase("StrToMember", "StrToMember(<String Expression>)", "Returns a member from a unique name String in MDX format.", "fmS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc memberNameCalc = compiler.compileString(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberNameCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws OlapException {
                        String mname = memberNameCalc.evaluateString(evaluator);
                        Cube cube = evaluator.getCube();
                        SchemaReader schemaReader = evaluator.getSchemaReader();
                        String[] uniqueNameParts = UniqueNameUtil.explode(mname);
                        Member member = (Member)schemaReader.lookupCompound(cube, uniqueNameParts, 6);
                        return member;
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new AggregateCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Avg", "Avg(<Set>[, <Numeric Expression>])", "Returns the average value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new AvgCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Avg", "Avg(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the average value of a numeric expression evaluated over a set.", new String[]{"fnxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValueObject().equals("INCLUDEEMPTY");
                        ValueCalc valueCalc = new ValueCalc(call);
                        return new AvgCalc(call, listCalc, valueCalc, includeEmpty);
                    }
                };
            }
        });
        final String[] resWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
        this.define(new MultiFuncResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc memberListCalc = compiler.compileList(call.getArg(0));
                        boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValueObject().equals("INCLUDEEMPTY");
                        return new CountCalc(call, memberListCalc, includeEmpty);
                    }
                };
            }

            @Override
            public String[] getReservedWords() {
                return resWords;
            }
        });
        this.define(new FunDefBase("Count", "<Set>.Count", "Returns the number of tuples in a set including empty cells.", "pnx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                ListCalc memberListCalc = compiler.compileList(call.getArg(0));
                return new CountCalc(call, memberListCalc, true);
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <String Expression1>, <String Expression2>)", "Returns one of two string values determined by a logical test.", "fSbSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
                StringCalc calc1 = compiler.compileString(call.getArg(1));
                StringCalc calc2 = compiler.compileString(call.getArg(2));
                return new IIfStringCalc(call, booleanCalc, calc1, calc2);
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <Numeric Expression1>, <Numeric Expression2>)", "Returns one of two numeric values determined by a logical test.", "fnbnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
                Calc calc1 = compiler.compileScalar(call.getArg(1), true);
                Calc calc2 = compiler.compileScalar(call.getArg(2), true);
                return new IIfNumberCalc(call, booleanCalc, calc1, calc2);
            }
        });
        this.define(new MultiFuncResolver("Max", "Max(<Set>[, <Numeric Expression>])", "Returns the maximum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new MaxCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Min", "Min(<Set>[, <Numeric Expression>])", "Returns the minimum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new MinCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Max", "Max(<Numeric Expression>,<Numeric Expression>)", "Returns the maximum value of two numeric expression.", new String[]{"fnnn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                        final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                        return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                            @Override
                            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                                BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                                BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                                if (o0 == null && o1 == null) {
                                    return null;
                                }
                                if (o0 == null) {
                                    return o1;
                                }
                                if (o1 == null) {
                                    return o0;
                                }
                                if (o0.compareTo(o1) > 0) {
                                    return o0;
                                }
                                return o1;
                            }
                        };
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Min", "Min(<Numeric Expression>,<Numeric Expression>)", "Returns the minimum value of two numeric expression.", new String[]{"fnnn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                        final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                        return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                            @Override
                            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                                BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                                BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                                if (o0 == null && o1 == null) {
                                    return null;
                                }
                                if (o0 == null) {
                                    return o1;
                                }
                                if (o1 == null) {
                                    return o0;
                                }
                                if (o0.compareTo(o1) > 0) {
                                    return o1;
                                }
                                return o0;
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("Ordinal", "<Level>.Ordinal", "Returns the zero-based ordinal value associated with a level.", "pnl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new LevelOrdinalCalc((Exp)call, levelCalc);
            }
        });
        this.define(new MultiFuncResolver("Sum", "Sum(<Set>[, <Numeric Expression>])", "Returns the sum of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new SumCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("IRR", "IRR(<Set>, <Numeric Expression>)", "Returns the IRR of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        BigDecimalCalc guessValue = compiler.compileBigDecimal(call.getArg(1));
                        return new IrrCalc(call, listCalc, guessValue);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("NPV", "NPV(<Set>, <Numeric Expression>)", "Returns the NPV of a numeric expression evaluated over a set.", new String[]{"fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        BigDecimalCalc rateCalc = compiler.compileBigDecimal(call.getArg(1));
                        return new NpvCalc(call, listCalc, rateCalc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Value", "<Measure>.Value", "Returns the value of a measure.", "pnm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                Calc[] calcs = new Calc[]{memberCalc};
                return new AbstractNumberCalc(call, calcs){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws OlapException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member old = evaluator.setContext(member);
                        Object value = evaluator.evaluateCurrent();
                        evaluator.setContext(old);
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return (Number)value;
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{memberCalc};
                    }
                };
            }
        });
        this.define(new FunDefBase("_Value", "_Value(<Tuple>)", "Returns the value of the current measure within the context of a tuple.", "fnt"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
                return new AbstractCalc(call){

                    @Override
                    public Object evaluate(Evaluator evaluator) throws OlapException {
                        Member[] tuple;
                        for (Member _tuple : tuple = tupleCalc.evaluateTuple(evaluator)) {
                            if (!_tuple.isNull()) continue;
                            return null;
                        }
                        Evaluator evaluator2 = evaluator.push(tuple);
                        Object value = evaluator2.evaluateCurrent();
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return value;
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{tupleCalc};
                    }
                };
            }
        });
        this.define(new FunDefBase("Value", "Value(<Tuple>)", "Returns the value of the current measure within the context of a tuple.", "fnt"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
                return new AbstractNumberCalc(call, new Calc[]{tupleCalc}){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws OlapException {
                        Member[] tuple = tupleCalc.evaluateTuple(evaluator);
                        Evaluator evaluator2 = evaluator.push(tuple);
                        Object value = evaluator2.evaluateCurrent();
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return (Number)value;
                    }
                };
            }
        });
        this.define(new FuncResolverBase("Value", null, null, Syntax.Function){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length == 1 && args[0].getCategory() == 10) {
                    return null;
                }
                return new ValueFunDef(ExpBase.getCategorys(args));
            }
        });
        this.define(new FunDefBase("LinkValue", "LinkValue(<String>, <String Expressions>)", "Returns the link value of the link name within the context of a tuple by uniqueNames.", "fnSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                StringCalc linkNameCalc = compiler.compileString(call.getArg(0));
                StringCalc membersStringCalc = compiler.compileString(call.getArg(1));
                return new LinkValueCalc(call, new Calc[]{linkNameCalc, membersStringCalc});
            }
        });
        this.define(new FunDefBase("IF", "IF(<Boolean>, <Numeric Expression>, <Numeric Expression>)", "Return true or false result based on <Boolean>.", "fnbnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                BooleanCalc c0 = compiler.compileBoolean(call.getArg(0));
                BigDecimalCalc c1 = compiler.compileBigDecimal(call.getArg(1));
                BigDecimalCalc c2 = compiler.compileBigDecimal(call.getArg(2));
                return new IfCalc(call, new Calc[]{c0, c1, c2}, false);
            }
        });
        this.define(new FunDefBase("IF", "IF(<Boolean>, <String Expression>, <String Expression>)", "Return true or false result based on <Boolean>.", "fSbSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                BooleanCalc c0 = compiler.compileBoolean(call.getArg(0));
                StringCalc c1 = compiler.compileString(call.getArg(1));
                StringCalc c2 = compiler.compileString(call.getArg(2));
                return new IfCalc(call, new Calc[]{c0, c1, c2}, true);
            }
        });
        this.define(new FunDefBase("_Value", "_Value()", "Returns the value of the current measure.", "fn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                return new AbstractNumberCalc(call, new Calc[0]){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws OlapException {
                        return (Number)evaluator.evaluateCurrent();
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Ancestor", "Ancestor(<Member>, {<Level>|<Numeric Expression>})", "Returns the ancestor of a member at a specified level.", new String[]{"fmml", "fmmn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                        Type type1 = call.getArg(1).getType();
                        if (type1 instanceof LevelType) {
                            LevelCalc levelCalc = compiler.compileLevel(call.getArg(1));
                            return new AncestorLevelCalc(call, memberCalc, levelCalc);
                        }
                        IntegerCalc distanceCalc = compiler.compileInteger(call.getArg(1));
                        return new AncestorNCalc(call, memberCalc, distanceCalc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Ascendants", "Ascendants(<Member>)", "Returns the set of the ascendants of a specified member include self.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AscendantsCalc((Exp)call, memberCalc, true);
            }
        });
        this.define(new FunDefBase("Ascendants", "Ascendants(<Member>, <Boolean of include or exclude self>)", "Returns the set of the ascendants of a specified member include or exclude self.", "fxmb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(1));
                return new AscendantsCalc((Exp)call, memberCalc, booleanCalc);
            }
        });
        this.define(new FunDefBase("AscendantsExcludeSelf", "AscendantsExcludeSelf(<Member>)", "Returns the set of the ascendants of a specified member exclude self.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AscendantsCalc((Exp)call, memberCalc, false);
            }
        });
        this.define(new FunDefBase("DescendantsExcludeSelf", "DescendantsExcludeSelf(<Member>)", "Returns the set of the descendants of a member exclude self.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new SimpleDescendantsCalc((Exp)call, memberCalc, false);
            }
        });
        this.define(new FunDefBase("LeafDescendants", "LeafDescendants(<Member>)", "Returns the set of the leaf descendants of a member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LeafDescendantsCalc(call, memberCalc, false);
            }
        });
        this.define(new FunDefBase("LeafDescendantsOrSelf", "LeafDescendantsOrSelf(<Member>)", "Returns the set of the leaf descendants of a member,if member is leaf return member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LeafDescendantsCalc(call, memberCalc, true);
            }
        });
        this.define(new FunDefBase("LeafDescendantsOrSelf", "LeafDescendantsOrSelf(<Set>)", "Returns the set of the leaf descendants of a set,if member is leaf ,include member.", "fxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new AllLeafDescendantsCalc((Exp)call, listCalc);
            }
        });
        this.define(new FunDefBase("NotLeafDescendants", "NotLeafDescendants(<Member>)", "Returns the set of the not leaf descendants of a member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new NotLeafDescendantsCalc((Exp)call, memberCalc);
            }
        });
        this.define(TopBottomCountFunDef.TopCountResolver);
        this.define(TopBottomCountFunDef.BottomCountResolver);
        this.define(TopBottomPercentSumFunDef.BottomPercentResolver);
        this.define(TopBottomPercentSumFunDef.BottomSumResolver);
        this.define(TopBottomPercentSumFunDef.TopPercentResolver);
        this.define(TopBottomPercentSumFunDef.TopSumResolver);
        this.define(new FunDefBase("Children", "<Member>.Children", "Returns the children of a member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new ChidrenCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("Descendants", "<Member>.Descendants", "Returns the set of the descendants of a member include self.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new SimpleDescendantsCalc((Exp)call, memberCalc, true);
            }
        });
        this.define(new FunDefBase("DescendantsExcludeSelf", "<Member>.DescendantsExcludeSelf", "Returns the set of the descendants of a member exclude self.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new SimpleDescendantsCalc((Exp)call, memberCalc, false);
            }
        });
        this.define(new FunDefBase("NotLeafDescendants", "<Member>.NotLeafDescendants", "Returns the set of the not leaf descendants of a specified member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new NotLeafDescendantsCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("LeafDescendants", "<Member>.LeafDescendants", "Returns the set of the leaf descendants of a specified member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LeafDescendantsCalc(call, memberCalc, false);
            }
        });
        this.define(new MultiFuncResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new CrossJoinFunDef(this, returnType, parameterTypes);
            }
        });
        this.define(new MultiFuncResolver("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                Dimension[] dims = new Dimension[2];
                for (int i = 0; i < 2; ++i) {
                    if (args[i] instanceof MemberExpr) {
                        dims[i] = ((MemberExpr)args[i]).getMember().getDimension();
                        continue;
                    }
                    if (args[i] instanceof FunCall) {
                        FunCall call = (FunCall)args[i];
                        if (!(call.getType() instanceof MemberType)) continue;
                        dims[i] = ((MemberType)call.getType()).getHierarchy().getDimension();
                        continue;
                    }
                    dims[i] = null;
                }
                if (dims[0] == dims[1] && dims[0] != null) {
                    return null;
                }
                return new CrossJoinFunDef(this, returnType, parameterTypes);
            }
        });
        this.define(new DescendantsFunDef.Resolver());
        this.define(new FunDefBase("Distinct", "Distinct(<Set>)", "Eliminates duplicate tuples from a set.", "fxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new DistinctCalc((Exp)call, listCalc);
            }
        });
        this.define(new FunDefBase("NonEmpty", "NonEmpty(<Set>)", "Eliminates empty tuples from a set.", "fxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new NonEmptyCalc((Exp)call, listCalc);
            }
        });
        this.define(new FunDefBase("NonEmpty", "NonEmpty(<Set1>,<Set2>)", "Returns the set of tuples that are not empty from a specified set, based on the cross product of the specified set with a second set.", "fxxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                ListCalc listCalc2 = compiler.compileList(call.getArg(1));
                return new NonEmpty2Calc(call, listCalc1, listCalc2);
            }
        });
        this.define(new MultiFuncResolver("Except", "Except(<Set1>, <Set2>)", "Finds the difference between two sets, optionally retaining duplicates.", new String[]{"fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new ExceptCalc(call, listCalc0, listCalc1);
                    }
                };
            }
        });
        this.define(FilterFunDef.instance);
        this.define(new MultiFuncResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc2 = compiler.compileList(call.getArg(1));
                        String literalArg = FuncUtil2.getLiteralArg(call.getArgs(), 2, "", new String[]{"ALL"});
                        boolean all = literalArg.equalsIgnoreCase("ALL");
                        return new GenerateCalc(call, listCalc1, listCalc2, all);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Generate", "Generate(<Set>, <String Expression>[, <Delimiter>])", "Applies a string expression to each member of set and joins each result as string,with delimiter if assigned.", new String[]{"fSxS", "fSxSS"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                        StringCalc stringCalc2 = compiler.compileString(call.getArg(1));
                        StringCalc delCalc = compiler.compileString(call.getArg(2));
                        return new GenerateStringCalc(call, listCalc1, stringCalc2, delCalc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Head", "Head(<Set>[, < Numeric Expression >])", "Returns the first specified number of elements in a set.", new String[]{"fxx", "fxxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc intCalc = call.getArgCount() > 0 ? compiler.compileInteger(call.getArg(1)) : null;
                        return new HeadCalc(call, listCalc, intCalc);
                    }
                };
            }
        });
        final String[] prePost = new String[]{"PRE", "POST"};
        this.define(new MultiFuncResolver("Hierarchize", "Hierarchize(<Set>[, POST])", "Orders the members of a set in a hierarchy.", new String[]{"fxx", "fxxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
                String order = FuncUtil2.getLiteralArg(args, 1, "PRE", prePost);
                final boolean post = order.equals("POST");
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        return new HierarchizeCalc(call, listCalc, post);
                    }
                };
            }

            @Override
            public String[] getReservedWords() {
                return prePost;
            }
        });
        this.define(new MultiFuncResolver("Intersect", "Intersect(<Set1>, <Set2>[, ALL])", "Returns the intersection of two input sets, optionally retaining duplicates.", new String[]{"fxxxy", "fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
                boolean all = FuncUtil2.getLiteralArg(args, 2, "", new String[]{"ALL"}).equalsIgnoreCase("ALL");
                return new IntersectFunDef(this, returnType, parameterTypes, all);
            }
        });
        this.define(new FunDefBase("Members", "<Dimension>.Members", "Returns the set of all members in a dimension.", "pxd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionMembersCalc((Exp)call, dimensionCalc);
            }
        });
        this.define(new FunDefBase("LeafMembers", "<Dimension>.LeafMembers", "Returns the set of all members in a dimension.", "pxd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionLeafMembersCalc(call, dimensionCalc, true);
            }
        });
        this.define(new FunDefBase("NoLeafMembers", "<Dimension>.NoLeafMembers", "Returns the set of all members in a dimension.", "pxd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionLeafMembersCalc(call, dimensionCalc, false);
            }
        });
        this.define(new FunDefBase("Members", "<Level>.Members", "Returns the set of all members in a level.", "pxl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelMembersCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("Members", "<Hierarchy>.Members", "Returns the set of all members in a hierarchy.", "pxh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new HierarchyMembersCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("MembersAboveLevel", "<Hierarchy>.MembersAboveLevel(<Numeric Expression>)", "Returns the set of all members above level based on level ordinal in a hierarchy.", "mxhn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                IntegerCalc calc2 = compiler.compileInteger(call.getArg(1));
                return new HierarchyMembersAboveLevelCalc(call, calc, calc2);
            }
        });
        this.define(new FunDefBase("FirstMember", "<Level>.FirstMember", "Returns the first member in a level.", "pml"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelFirstMemberCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("LastMember", "<Level>.LastMember", "Returns the last member in a level.", "pml"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelLastMemberCalc((Exp)call, calc);
            }
        });
        this.define(new OrderFunDef.OrderFuncResolver());
        this.define(new XtdFunDef.Resolver("Mtd", "Mtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Month.", new String[]{"fx", "fxm"}, 4));
        this.define(new XtdFunDef.Resolver("Qtd", "Qtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Quarter.", new String[]{"fx", "fxm"}, 3));
        this.define(new XtdFunDef.Resolver("Wtd", "Wtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Week.", new String[]{"fx", "fxm"}, 5));
        this.define(new XtdFunDef.Resolver("Ytd", "Ytd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Year.", new String[]{"fx", "fxm"}, 2));
        this.define(new MultiFuncResolver("PeriodsToDate", "PeriodsToDate([<Level>[, <Member>]])", "Returns a set of periods (members) from a specified level starting with the first period and ending with a specified member.", new String[]{"fx", "fxl", "fxlm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getSchemaReader().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new OlapException("PeriodsToDate with no arguments must apply to Time Dimension,but the cube has no Time Dimension.");
                            }
                            Hierarchy hierarchy = timeDimension.getHierarchy();
                            return new SetType(new MemberType(hierarchy, null, null));
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        LevelCalc levelCalc = call.getArgCount() > 0 ? compiler.compileLevel(call.getArg(0)) : null;
                        MemberCalc memberCalc = call.getArgCount() > 1 ? compiler.compileMember(call.getArg(1)) : null;
                        Dimension timeDimension = compiler.getResolver().getSchemaReader().getCube().getTimeDimension();
                        return new PeriodsToDateCalc(call, levelCalc, memberCalc, timeDimension);
                    }
                };
            }
        });
        this.define(new FunDefBase("Siblings", "<Member>.Siblings", "Returns the set of siblings of the specified member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new SiblingsCalc(call, calc, true);
            }
        });
        this.define(new FunDefBase("Siblings", "Siblings(<Member>)", "Returns the set of siblings of the specified member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new SiblingsCalc(call, calc, true);
            }
        });
        this.define(new FunDefBase("SiblingsExcludeSelf", "<Member>.SiblingsExcludeSelf", "Returns the set of siblings of the specified member exclude self.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new SiblingsCalc(call, calc, false);
            }
        });
        this.define(new FunDefBase("SiblingsExcludeSelf", "SiblingsExcludeSelf(<Member>)", "Returns the set of siblings of the specified member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new SiblingsCalc(call, calc, false);
            }
        });
        this.define(new MultiFuncResolver("Subset", "Subset(<Set>, <Start>[, <Count>])", "Returns a subset of elements from a set.", new String[]{"fxxn", "fxxnn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc startCalc = compiler.compileInteger(call.getArg(1));
                        IntegerCalc countCalc = call.getArgCount() > 2 ? compiler.compileInteger(call.getArg(2)) : null;
                        return new SubsetCalc(call, listCalc, startCalc, countCalc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("-", "<Set1> - <Set2>", "Subtracts two set.", new String[]{"ixxx", "ixxm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
                return new FunDefBase(this, returnCategory, argCategorys){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new ExceptCalc(call, listCalc0, listCalc1);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Tail", "Tail(<Set>[, <Count>])", "Returns a subset from the end of a set.", new String[]{"fxx", "fxxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc intCalc = call.getArgCount() > 0 ? compiler.compileInteger(call.getArg(1)) : null;
                        return new TailCalc(call, listCalc, intCalc);
                    }
                };
            }
        });
        final String[] allDistinct = new String[]{"ALL", "DISTINCT"};
        this.define(new MultiFuncResolver("Union", "Union(<Set1>, <Set2>[, ALL])", "Returns the union of two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}){

            @Override
            public String[] getReservedWords() {
                return allDistinct;
            }

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
                String allString = FuncUtil2.getLiteralArg(args, 2, "DISTINCT", allDistinct);
                final boolean all = allString.equalsIgnoreCase("ALL");
                FuncUtil2.checkCompatible(args[0], args[1], this.getName());
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new UnionCalc(call, listCalc0, listCalc1, all);
                    }
                };
            }
        });
        this.define(new FunDefBase(":", "<Member>:<Member>", "Infix colon operator returns the set of members between a given pair of members.", "ixmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                MemberCalc memberCalc0 = compiler.compileMember(call.getArg(0));
                MemberCalc memberCalc1 = compiler.compileMember(call.getArg(1));
                return new MemberRangeCalc(call, memberCalc0, memberCalc1);
            }
        });
        this.define(new FuncResolverBase("{}", "{<Member> [, <Member>]...}", "Brace operator constructs a set.", Syntax.Braces){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                int[] parameterTypes = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (TypeConvertUtil.canConvert(args[i], 6, conversionCount)) {
                        parameterTypes[i] = 6;
                        continue;
                    }
                    if (TypeConvertUtil.canConvert(args[i], 8, conversionCount)) {
                        parameterTypes[i] = 8;
                        continue;
                    }
                    if (TypeConvertUtil.canConvert(args[i], 10, conversionCount)) {
                        parameterTypes[i] = 10;
                        continue;
                    }
                    return null;
                }
                return new SetFunDef(this, parameterTypes);
            }
        });
        this.define(new MultiFuncResolver("Format", "Format(<Numeric Expression>, <String Expression>)", "Formats a number to string.", new String[]{"fSmS", "fSnS"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                if (args[1] instanceof Literal) {
                    return new FunDefBase(this, returnType, parameterTypes){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                            Exp[] args = call.getArgs();
                            final Calc calc = compiler.compileScalar(call.getArg(0), true);
                            String formatString = ((Literal)args[1]).stringValue();
                            final Formatter format = new Formatter(formatString);
                            return new AbstractStringCalc(call, new Calc[]{calc}){

                                @Override
                                public String evaluateString(Evaluator evaluator) throws OlapException {
                                    Object o = calc.evaluate(evaluator);
                                    return format.format(o);
                                }
                            };
                        }
                    };
                }
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final Calc calc = compiler.compileScalar(call.getArg(0), true);
                        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
                        return new AbstractStringCalc(call, new Calc[]{calc, stringCalc}){

                            @Override
                            public String evaluateString(Evaluator evaluator) throws OlapException {
                                Object o = calc.evaluate(evaluator);
                                String formatString = stringCalc.evaluateString(evaluator);
                                Formatter format = new Formatter(formatString);
                                return format.format(o);
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Dimension>.Caption", "Returns the caption of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Hierarchy>.Caption", "Returns the caption of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Level>.Caption", "Returns the caption of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Member>.Caption", "Returns the caption of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Dimension>.Name", "Returns the name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Hierarchy>.Name", "Returns the name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Level>.Name", "Returns the name of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Member>.Name", "Returns the name of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Key", "<Member>.Key", "Returns the key of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new GenericCalc(call){

                    @Override
                    public Object evaluate(Evaluator evaluator) throws OlapException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getKey();
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{calc};
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Dimension>.UniqueName", "Returns the unique name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Hierarchy>.UniqueName", "Returns the unique name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Level>.UniqueName", "Returns the unique name of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Member>.UniqueName", "Returns the unique name of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getUniqueName();
                    }
                };
            }
        });
        this.define(SetItemFunDef.instance);
        this.define(TupleItemFunDef.instance);
        this.define(new FuncResolverBase("()", null, null, Syntax.Parentheses){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length == 1) {
                    return new ParenthesesFunDef(args[0].getCategory());
                }
                return new TupleFunDef(ExpBase.getCategorys(args));
            }
        });
        this.define(new FuncResolverBase("CoalesceEmpty", "CoalesceEmpty(<Value Expression>[, <Value Expression>]...)", "Coalesces an empty cell value to a different value. All of the expressions must be of the same type (number or string).", Syntax.Function){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int[] types = new int[]{7, 9};
                for (int j = 0; j < types.length; ++j) {
                    int type = types[j];
                    int matchingArgs = 0;
                    conversionCount.value = 0;
                    for (int i = 0; i < args.length; ++i) {
                        if (!TypeConvertUtil.canConvert(args[i], type, conversionCount)) continue;
                        ++matchingArgs;
                    }
                    if (matchingArgs != args.length) continue;
                    return new CoalesceEmptyFunDef(this, type, ExpBase.getCategorys(args));
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new FuncResolverBase("_CaseTest", "Case When <Logical Expression> Then <Expression> [Else <Expression>] End", "Evaluates various conditions, and returns the corresponding expression for the first which evaluates to true.", Syntax.Case){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int j = 0;
                int clauseCount = args.length / 2;
                int mismatchingArgs = 0;
                int returnType = args[1].getCategory();
                for (int i = 0; i < clauseCount; ++i) {
                    if (!TypeConvertUtil.canConvert(args[j++], 5, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                Util.assertTrue(j == args.length);
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, returnType, ExpBase.getCategorys(args)){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                            Exp[] args = call.getArgs();
                            final BooleanCalc[] conditionCalcs = new BooleanCalc[args.length / 2];
                            final Calc[] exprCalcs = new Calc[args.length / 2];
                            LinkedList<Calc> calcList = new LinkedList<Calc>();
                            int j = 0;
                            for (int i = 0; i < exprCalcs.length; ++i) {
                                conditionCalcs[i] = compiler.compileBoolean(args[j++]);
                                calcList.add(conditionCalcs[i]);
                                exprCalcs[i] = compiler.compile(args[j++]);
                                calcList.add(exprCalcs[i]);
                            }
                            final ConstantCalc defaultCalc = args.length % 2 == 1 ? compiler.compile(args[args.length - 1]) : ConstantCalc.constantNull(call.getType());
                            calcList.add(defaultCalc);
                            final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
                            return new AbstractCalc(call){

                                @Override
                                public Object evaluate(Evaluator evaluator) throws OlapException {
                                    for (int i = 0; i < conditionCalcs.length; ++i) {
                                        if (!conditionCalcs[i].evaluateBoolean(evaluator)) continue;
                                        return exprCalcs[i].evaluate(evaluator);
                                    }
                                    return defaultCalc.evaluate(evaluator);
                                }

                                @Override
                                public Calc[] getCalcs() {
                                    return calcs;
                                }
                            };
                        }
                    };
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new FuncResolverBase("_CaseMatch", "Case <Expression> When <Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various expressions, and returns the corresponding expression for the first which matches a particular value.", Syntax.Case){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 3) {
                    return null;
                }
                int valueType = args[0].getCategory();
                int returnType = args[2].getCategory();
                int j = 0;
                int clauseCount = (args.length - 1) / 2;
                int mismatchingArgs = 0;
                if (!TypeConvertUtil.canConvert(args[j++], valueType, conversionCount)) {
                    ++mismatchingArgs;
                }
                for (int i = 0; i < clauseCount; ++i) {
                    if (!TypeConvertUtil.canConvert(args[j++], valueType, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, returnType, ExpBase.getCategorys(args)){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                            Exp[] args = call.getArgs();
                            LinkedList<Calc> calcList = new LinkedList<Calc>();
                            final Calc valueCalc = compiler.compile(args[0]);
                            calcList.add(valueCalc);
                            int matchCount = (args.length - 1) / 2;
                            final Calc[] matchCalcs = new Calc[matchCount];
                            final Calc[] exprCalcs = new Calc[matchCount];
                            int j = 1;
                            for (int i = 0; i < exprCalcs.length; ++i) {
                                matchCalcs[i] = compiler.compile(args[j++]);
                                calcList.add(matchCalcs[i]);
                                exprCalcs[i] = call.getType() instanceof NumericType ? compiler.compileBigDecimal(args[j++]) : compiler.compile(args[j++]);
                                calcList.add(exprCalcs[i]);
                            }
                            Calc lastCalc = null;
                            lastCalc = args.length % 2 == 0 ? (call.getType() instanceof NumericType ? compiler.compileBigDecimal(args[args.length - 1]) : compiler.compile(args[args.length - 1])) : ConstantCalc.constantNull(call.getType());
                            final ConstantCalc defaultCalc = lastCalc;
                            calcList.add(defaultCalc);
                            final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
                            return new AbstractCalc(call){

                                @Override
                                public Object evaluate(Evaluator evaluator) throws OlapException {
                                    Object value = valueCalc.evaluate(evaluator);
                                    for (int i = 0; i < matchCalcs.length; ++i) {
                                        Object match = matchCalcs[i].evaluate(evaluator);
                                        if (!Util.equals(match, value)) continue;
                                        return exprCalcs[i].evaluate(evaluator);
                                    }
                                    return defaultCalc.evaluate(evaluator);
                                }

                                @Override
                                public Calc[] getCalcs() {
                                    return calcs;
                                }
                            };
                        }
                    };
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new PropertiesFunDef.Resolver());
        this.define(new FunDefBase("+", "<Numeric Expression> + <Numeric Expression>", "Adds two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        if (o0 == null) {
                            return o1;
                        }
                        if (o1 == null) {
                            return o0;
                        }
                        return o0.add(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "<Numeric Expression> - <Numeric Expression>", "Subtracts two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        if (o0 == null) {
                            return o1.multiply(Util.negOneDecimal);
                        }
                        if (o1 == null) {
                            return o0;
                        }
                        return o0.subtract(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("*", "<Numeric Expression> * <Numeric Expression>", "Multiplies two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null || o1 == null) {
                            return null;
                        }
                        return o0.multiply(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("/", "<Numeric Expression> / <Numeric Expression>", "Divides two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == (BigDecimal)ValueNotReady.instance || o1 == (BigDecimal)ValueNotReady.instance) {
                            return (BigDecimal)ValueNotReady.instance;
                        }
                        if (o0 == null || o1 == null || Util.zeroDecimal.compareTo(o1) == 0) {
                            return null;
                        }
                        return o0.divide(o1, 15, 4);
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "- <Numeric Expression>", "Returns the negative of a number.", "Pnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        if (o0 == null) {
                            return null;
                        }
                        return o0.multiply(Util.negOneDecimal);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Abs", "Abs(<Numeric Expression>)", "Returns the absolute (positive) value of a numeric expression.", new String[]{"fnn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                        return new AbstractBigDecimalCalc(call, new Calc[]{calc0}){

                            @Override
                            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                                BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                                if (o0 == null) {
                                    return null;
                                }
                                return o0.abs();
                            }
                        };
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Round", "Round(<Numeric Expression>, <Integer Expression> [,RoundingMode] )", "Returns the round up value with scale of a number.", new String[]{"fnnn", "fnnny"}){
            private String[] keys;
            {
                this.keys = new String[]{RoundingMode.CEILING.toString(), RoundingMode.DOWN.toString(), RoundingMode.FLOOR.toString(), RoundingMode.HALF_DOWN.toString(), RoundingMode.HALF_EVEN.toString(), RoundingMode.HALF_UP.toString(), RoundingMode.UP.toString()};
            }

            @Override
            public String[] getReservedWords() {
                return this.keys;
            }

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                        final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                        final IntegerCalc calc1 = compiler.compileInteger(call.getArg(1));
                        RoundingMode m = RoundingMode.HALF_UP;
                        if (call.getArgCount() > 2) {
                            m = RoundingMode.valueOf(((Literal)call.getArg(2)).stringValue().toUpperCase());
                        }
                        final RoundingMode mode = m;
                        return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                            @Override
                            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                                BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                                if (o0 == null) {
                                    return null;
                                }
                                int o1 = calc1.evaluateInteger(evaluator);
                                return o0.setScale(o1, mode);
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("||", "<String Expression> || <String Expression>", "Concatenates two strings.", "iSSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        return (o0 == null ? "" : o0) + (o1 == null ? "" : o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("+", "<String Expression> + <String Expression>", "Concatenates two strings.", "iSSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        return (o0 == null ? "" : o0) + (o1 == null ? "" : o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("AND", "<Logical Expression> AND <Logical Expression>", "Returns the conjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        boolean o1 = calc1.evaluateBoolean(evaluator);
                        return o0 && o1;
                    }
                };
            }
        });
        this.define(new FunDefBase("OR", "<Logical Expression> OR <Logical Expression>", "Returns the disjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        boolean o1 = calc1.evaluateBoolean(evaluator);
                        return o0 || o1;
                    }
                };
            }
        });
        this.define(new FunDefBase("XOR", "<Logical Expression> XOR <Logical Expression>", "Returns whether two conditions are mutually exclusive.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean o1;
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        return o0 != (o1 = calc1.evaluateBoolean(evaluator));
                    }
                };
            }
        });
        this.define(new FunDefBase("NOT", "NOT <Logical Expression>", "Returns the negation of a condition.", "Pbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{calc0}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        return !o0;
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<String Expression> = <String Expression>", "Returns whether two expressions are equal.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<Numeric Expression> = <Numeric Expression>", "Returns whether two expressions are equal.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null || o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) == 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<Member> = <Member>", "Returns whether two members are equal.", "ibmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc0 = compiler.compileMember(call.getArg(0));
                final MemberCalc calc1 = compiler.compileMember(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean null1;
                        Member o0 = calc0.evaluateMember(evaluator);
                        Member o1 = calc1.evaluateMember(evaluator);
                        boolean null0 = o0 == null || o0.isNull();
                        boolean bl = null1 = o1 == null || o1.isNull();
                        if (null0 && null1) {
                            return true;
                        }
                        return !null0 && !null1 && o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<String Expression> <> <String Expression>", "Returns whether two expressions are not equal.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return !o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<Numeric Expression> <> <Numeric Expression>", "Returns whether two expressions are not equal.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null || o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) != 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<Member> <> <Member>", "Returns whether two members are not equal.", "ibmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final MemberCalc calc0 = compiler.compileMember(call.getArg(0));
                final MemberCalc calc1 = compiler.compileMember(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        boolean null1;
                        Member o0 = calc0.evaluateMember(evaluator);
                        Member o1 = calc1.evaluateMember(evaluator);
                        boolean null0 = o0 == null || o0.isNull();
                        boolean bl = null1 = o1 == null || o1.isNull();
                        if (null0 && null1) {
                            return false;
                        }
                        if (!null0 && !null1) {
                            return !o0.equals(o1);
                        }
                        return true;
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "<Numeric Expression> < <Numeric Expression>", "Returns whether an expression is less than another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            o0 = BigDecimal.ZERO;
                        } else if (o1 == null) {
                            o1 = BigDecimal.ZERO;
                        }
                        return o0.compareTo(o1) < 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "<String Expression> < <String Expression>", "Returns whether an expression is less than another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) < 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "<Numeric Expression> <= <Numeric Expression>", "Returns whether an expression is less than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            o0 = BigDecimal.ZERO;
                        } else if (o1 == null) {
                            o1 = BigDecimal.ZERO;
                        }
                        return o0.compareTo(o1) <= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "<String Expression> <= <String Expression>", "Returns whether an expression is less than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) <= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "<Numeric Expression> > <Numeric Expression>", "Returns whether an expression is greater than another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            o0 = BigDecimal.ZERO;
                        } else if (o1 == null) {
                            o1 = BigDecimal.ZERO;
                        }
                        return o0.compareTo(o1) > 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "<String Expression> > <String Expression>", "Returns whether an expression is greater than another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) > 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "<Numeric Expression> >= <Numeric Expression>", "Returns whether an expression is greater than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            o0 = BigDecimal.ZERO;
                        } else if (o1 == null) {
                            o1 = BigDecimal.ZERO;
                        }
                        return o0.compareTo(o1) >= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "<String Expression> >= <String Expression>", "Returns whether an expression is greater than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws OlapException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) >= 0;
                    }
                };
            }
        });
    }
}

