/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import java.util.ArrayList;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DummyExp;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.CrossjoinCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.SetCalc;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.mdx.type.TupleType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import org.apache.log4j.Logger;

public class CrossJoinFunDef
extends FunDefBase {
    private static Logger logger = Logger.getLogger(CrossJoinFunDef.class);

    public CrossJoinFunDef(FuncResolver resolver, int returnType, int[] parameterTypes) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
        ArrayList list = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getType();
            if (type instanceof SetType) {
                SetType setType = (SetType)type;
                CrossJoinFunDef.addTypes(setType.getElementType(), list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw new OlapException("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new Type[list.size()]);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, ArrayList list) {
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (int i = 0; i < tupleType.elementTypes.length; ++i) {
                CrossJoinFunDef.addTypes(tupleType.elementTypes[i], list);
            }
        } else {
            list.add(type);
        }
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        ListCalc listCalc1 = this.toListCalc(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toListCalc(compiler, call.getArg(1));
        return new CrossjoinCalc((Exp)call, listCalc1, listCalc2);
    }

    private ListCalc toListCalc(ExpCompiler compiler, Exp exp) throws OlapException {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compileList(exp);
        }
        return new SetCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler);
    }
}

