/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DimensionCalc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberCalc;

public class DimensionCurrentMemberFunDef
extends FunDefBase {
    static final DimensionCurrentMemberFunDef instance = new DimensionCurrentMemberFunDef();

    private DimensionCurrentMemberFunDef() {
        super("CurrentMember", "<Dimension>.CurrentMember", "Returns the current member along a dimension during an iteration.", "pmd");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
        return new CalcImpl((Exp)call, dimensionCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final DimensionCalc dimensionCalc;

        public CalcImpl(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) throws OlapException {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            if (evaluator == null) {
                return dimension.getDefaultHierarchy().getDefaultMember();
            }
            return evaluator.getContext(dimension);
        }

        public boolean dependsOn(Dimension dimension) {
            return this.dimensionCalc.getType().usesDimension(dimension);
        }
    }
}

