/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberCalc;

public class HierarchyCurrentMemberFunDef
extends FunDefBase {
    static final HierarchyCurrentMemberFunDef instance = new HierarchyCurrentMemberFunDef();

    private HierarchyCurrentMemberFunDef() {
        super("CurrentMember", "<Hierarchy>.CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) throws OlapException {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            Member member = evaluator.getContext(hierarchy.getDimension());
            return member;
        }

        public boolean dependsOn(Dimension dimension) {
            return this.hierarchyCalc.getType().usesDimension(dimension);
        }
    }
}

