/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractDimensionCalc;

public class HierarchyDimensionFunDef
extends FunDefBase {
    static final HierarchyDimensionFunDef instance = new HierarchyDimensionFunDef();

    private HierarchyDimensionFunDef() {
        super("Dimension", "<Hierarchy>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdh");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class CalcImpl
    extends AbstractDimensionCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        public Dimension evaluateDimension(Evaluator evaluator) throws OlapException {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            return hierarchy.getDimension();
        }
    }
}

