/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractHierarchyCalc;

public class LevelHierarchyFunDef
extends FunDefBase {
    static final LevelHierarchyFunDef instance = new LevelHierarchyFunDef();

    private LevelHierarchyFunDef() {
        super("Hierarchy", "<Level>.Hierarchy", "Returns a level's hierarchy.", "phl");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
        return new CalcImpl((Exp)call, levelCalc);
    }

    public static class CalcImpl
    extends AbstractHierarchyCalc {
        private final LevelCalc levelCalc;

        public CalcImpl(Exp exp, LevelCalc levelCalc) {
            super(exp, new Calc[]{levelCalc});
            this.levelCalc = levelCalc;
        }

        @Override
        public Hierarchy evaluateHierarchy(Evaluator evaluator) throws OlapException {
            Level level = this.levelCalc.evaluateLevel(evaluator);
            return level.getHierarchy();
        }
    }
}

