/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.MultiFuncResolver;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.TopBottomCountCalc;

class TopBottomCountFunDef
extends FunDefBase {
    boolean top;
    static final MultiFuncResolver TopCountResolver = new MultiFuncResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        @Override
        protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
            return new TopBottomCountFunDef(this, returnCategory, argCategorys, true);
        }
    };
    static final MultiFuncResolver BottomCountResolver = new MultiFuncResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        @Override
        protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
            return new TopBottomCountFunDef(this, returnCategory, argCategorys, false);
        }
    };

    public TopBottomCountFunDef(FuncResolver funcResolver, int returnCategory, int[] argCategorys, boolean top) {
        super(funcResolver, returnCategory, argCategorys);
        this.top = top;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        Calc orderCalc = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : null;
        return new TopBottomCountCalc(call, listCalc, integerCalc, orderCalc, this.top);
    }
}

