/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpBase;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractTupleCalc;
import kd.epm.eb.algo.olap.mdx.type.TupleType;
import kd.epm.eb.algo.olap.mdx.type.Type;

class TupleFunDef
extends FunDefBase {
    private final int[] argCategorys;

    TupleFunDef(int[] argCategorys) {
        super("()", "Parenthesis operator constructs a tuple.  If there is only one member, the expression is equivalent to the member expression.", Syntax.Parentheses, 10, argCategorys);
        this.argCategorys = argCategorys;
    }

    @Override
    public int getReturnCategory() {
        return 10;
    }

    @Override
    public int[] getArgCategorys() {
        return this.argCategorys;
    }

    @Override
    public void unparse(Exp[] args, StringBuilder sb) {
        ExpBase.unparseList(sb, args, "(", ", ", ")");
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) {
        if (args.length == 1) {
            return args[0].getType();
        }
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            types[i] = arg.getType();
        }
        return new TupleType(types);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        final int count = call.getArgCount();
        Exp[] args = call.getArgs();
        Calc[] calcs = new MemberCalc[count];
        for (int i = 0; i < count; ++i) {
            calcs[i] = compiler.compileMember(args[i]);
        }
        return new AbstractTupleCalc(call, calcs, (MemberCalc[])calcs){
            final /* synthetic */ MemberCalc[] val$calcs;
            {
                this.val$calcs = memberCalcArray;
                super(exp, calcs);
            }

            @Override
            public Member[] evaluateTuple(Evaluator evaluator) throws OlapException {
                Member[] members = new Member[count];
                for (int i = 0; i < count; ++i) {
                    members[i] = this.val$calcs[i].evaluateMember(evaluator);
                }
                return members;
            }
        };
    }
}

