/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.func;

import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.FunctionException;
import kd.epm.eb.algo.olap.mdx.MultiFuncResolver;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.XtdCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.mdx.type.Type;

class XtdFunDef
extends FunDefBase {
    private final byte levelType;

    public XtdFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, byte levelType) {
        super(resolver, returnType, parameterTypes);
        this.levelType = levelType;
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
        if (args.length == 0) {
            Hierarchy hierarchy = resolver.getSchemaReader().getCube().getTimeDimension().getHierarchy();
            return new SetType(new MemberType(hierarchy, null, null));
        }
        Type type = args[0].getType();
        if (!type.getHierarchy().getDimension().isTimeDimension()) {
            throw new FunctionException("Funciton '" + this.getName() + "' need Time Dimension.");
        }
        return super.getResultType(resolver, args);
    }

    private Level getLevel(Cube cube) {
        switch (this.levelType) {
            case 2: {
                return FuncUtil2.getTimeLevel(cube, (byte)2);
            }
            case 3: {
                return FuncUtil2.getTimeLevel(cube, (byte)3);
            }
            case 4: {
                return FuncUtil2.getTimeLevel(cube, (byte)4);
            }
            case 5: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
            case 6: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
        }
        return null;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        Level level = this.getLevel(compiler.getResolver().getSchemaReader().getCube());
        MemberCalc memberCalc = null;
        if (call.getArgCount() > 0) {
            memberCalc = compiler.compileMember(call.getArg(0));
        }
        return new XtdCalc(call, level, memberCalc);
    }

    public static class Resolver
    extends MultiFuncResolver {
        private final byte levelType;

        public Resolver(String name, String signature, String description, String[] signatures, byte levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
            return new XtdFunDef(this, returnType, parameterTypes, this.levelType);
        }
    }
}

