/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.util;

import kd.epm.eb.algo.olap.util.BitSetFactory;
import kd.epm.eb.algo.olap.util.LongBitSet;

public class BBFilter {
    private int[] cards;
    LongBitSet bitSet;

    public BBFilter(int[] cards) {
        this.cards = cards;
        this.bitSet = BitSetFactory.createLongBitSet();
    }

    private long getOffset(int[] coords) {
        long l = coords[0];
        for (int i = 1; i < coords.length; ++i) {
            l = l * (long)this.cards[i] + (long)coords[i];
        }
        return l;
    }

    public void set(long index) {
        this.bitSet.set(index);
    }

    public boolean get(long index) {
        return this.bitSet.get(index);
    }

    public void set(int[] coords) {
        long offset = this.getOffset(coords);
        this.bitSet.set(offset);
    }

    public boolean get(int[] coords) {
        long offset = this.getOffset(coords);
        return this.bitSet.get(offset);
    }

    public long size() {
        return this.bitSet.cardinate();
    }
}

