/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import kd.epm.eb.algo.olap.AvgValue;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.config.Config;
import kd.epm.eb.algo.olap.def.LevelDef;

public class Util {
    public static final BigDecimal oneDecimal = BigDecimal.valueOf(1.0);
    public static final BigDecimal negOneDecimal = BigDecimal.valueOf(-1.0);
    public static final BigDecimal zeroDecimal = BigDecimal.valueOf(0.0);
    public static final String[] emptyStringArray = new String[0];
    public static Collator collator = Collator.getInstance(Locale.CHINA);
    public static final Object nullValue = new BigDecimal("0.0");
    public static final Object sqlNullValue = new Object(){

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "null";
        }
    };

    public static String toString(Member[] objects) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < objects.length; ++i) {
            sb.append("[").append(objects[i].getUniqueName()).append("],");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public static String toString(Object[] objects) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < objects.length; ++i) {
            sb.append("[").append(objects[i].toString()).append("],");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public static int getArity(Object o) {
        if (o instanceof Member) {
            return 1;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length;
        }
        return 1;
    }

    public static Member[] makeTuple(Member left, Member right) {
        return new Member[]{left, right};
    }

    public static Member[] makeTuple(Member[] left, Member right) {
        Member[] ms = new Member[left.length + 1];
        ms[left.length] = right;
        System.arraycopy(left, 0, ms, 0, left.length);
        return ms;
    }

    public static Member[] makeTuple(Member left, Member[] right) {
        Member[] ms = new Member[right.length + 1];
        ms[0] = left;
        System.arraycopy(right, 0, ms, 1, right.length);
        return ms;
    }

    public static Member[] toMemberArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Member[]) {
            return (Member[])o;
        }
        if (o instanceof Member) {
            return new Member[]{(Member)o};
        }
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            Member[] ms = new Member[os.length];
            System.arraycopy(os, 0, ms, 0, os.length);
            return ms;
        }
        throw new ClassCastException();
    }

    public static boolean isDescendentOrEqualTo(Member m1, Member m2) {
        if (m2 == null) {
            return false;
        }
        return Util.isDescendentOrEqualTo(m1, m2.getUniqueName());
    }

    public static boolean isDescendentOrEqualTo(Member m1, String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        String thisUniqueName = m1.getUniqueName();
        if (thisUniqueName.equals(uniqueName)) {
            return true;
        }
        Member parent = m1.getParentMember();
        if (parent == null) {
            return false;
        }
        return Util.isDescendentOrEqualTo(parent, uniqueName);
    }

    public static boolean isVisible(Member[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i].isVisible()) continue;
            return false;
        }
        return true;
    }

    static int compareValues(double d1, double d2) {
        return d1 == d2 ? 0 : (d1 < d2 ? -1 : 1);
    }

    public static int compareValues(String value0, Number value1) {
        try {
            Double d = new Double(value0);
            return Util.compareValues(d, value1.doubleValue());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 instanceof RuntimeException || value1 instanceof RuntimeException) {
            return 0;
        }
        if (value0 == nullValue) {
            return -1;
        }
        if (value1 == nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            if (value1 instanceof Number) {
                return Util.compareValues((String)value0, (Number)value1);
            }
            return ((String)value0).compareTo((String)value1);
        }
        if (value0 instanceof Number) {
            if (value1 instanceof String) {
                return 0 - Util.compareValues((String)value1, (Number)value0);
            }
            return Util.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    public static String[] seperateNames(String names, int sepChar) {
        int i;
        ArrayList<String> v = new ArrayList<String>();
        names = names.trim();
        while ((i = names.indexOf(sepChar)) >= 0) {
            v.add(names.substring(0, i).trim());
            names = names.substring(i + 1).trim();
        }
        v.add(names);
        String[] ns = v.toArray(new String[v.size()]);
        return ns;
    }

    public static String[] seperateNames(String names) {
        return Util.seperateNames(names, 44);
    }

    public static String singleQuoteForSql(String val) {
        StringBuilder buf = new StringBuilder(64);
        Util.singleQuoteForSql(val, buf);
        return buf.toString();
    }

    public static void singleQuoteForSql(String val, StringBuilder buf) {
        if (val == null) {
            buf.append("NULL");
        } else {
            buf.append('\'');
            String s0 = Util.replace(val, "'", "''");
            buf.append(s0);
            buf.append('\'');
        }
    }

    public static int objectHashCode(Object x) {
        if (x == null) {
            return 0;
        }
        return x.hashCode();
    }

    public static boolean objectEquals(Object x1, Object x2) {
        if (x1 == null) {
            return x2 == null;
        }
        if (x2 == null) {
            return false;
        }
        return x1.equals(x2);
    }

    public static boolean equals(Object s, Object t) {
        return s == null ? t == null : s.equals(t);
    }

    public static int compare(Object v1, Object v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        if (v1 instanceof java.util.Date) {
            return ((java.util.Date)v1).compareTo((java.util.Date)v2);
        }
        if (v1 instanceof Long) {
            return ((Long)v1).compareTo((Long)v2);
        }
        if (v1 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2);
        }
        if (v1 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2);
        }
        if (v1 instanceof BigInteger) {
            return ((BigInteger)v1).compareTo((BigInteger)v2);
        }
        if (v1 instanceof Number) {
            int i2;
            int i1 = ((Number)v1).intValue();
            if (i1 > (i2 = ((Number)v2).intValue())) {
                return 1;
            }
            if (i1 < i2) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public static BigDecimal toBigDecimal(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return new BigDecimal(v.toString());
    }

    public static double toDouble(Object value) {
        if (value instanceof AvgValue) {
            value = ((AvgValue)value).getAvgValue();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new OlapException("Can't parse " + value.toString() + " to double.");
    }

    public static Object add(Object sum, Object value) throws OlapException {
        if (sum instanceof AvgValue) {
            sum = ((AvgValue)sum).getAvgValue();
        }
        if (value instanceof AvgValue) {
            value = ((AvgValue)value).getAvgValue();
        }
        if (value == null) {
            return sum;
        }
        if (sum == null) {
            return value;
        }
        if (sum instanceof Number && value instanceof Number) {
            if (sum instanceof BigDecimal || value instanceof BigDecimal) {
                return Util.toBigDecimal(sum).add(Util.toBigDecimal(value));
            }
            if (sum instanceof Long || value instanceof Long) {
                return ((Number)sum).longValue() + ((Number)value).longValue();
            }
            if (sum instanceof Integer || value instanceof Integer) {
                return ((Number)sum).intValue() + ((Number)value).intValue();
            }
            if (sum instanceof Double || value instanceof Double || sum instanceof Float || value instanceof Float) {
                return ((Number)sum).doubleValue() + ((Number)value).doubleValue();
            }
        }
        throw new OlapException("Can't add " + sum.toString() + " + " + value.toString());
    }

    public static final void addAll(List v, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            v.add(array[i]);
        }
    }

    public static byte getLevelType(String typeName) throws OlapException {
        if (typeName.equals("Standard")) {
            return 0;
        }
        if (typeName.equals("Years")) {
            return 2;
        }
        if (typeName.equals("Quarters")) {
            return 3;
        }
        if (typeName.equals("Months")) {
            return 4;
        }
        if (typeName.equals("Weeks")) {
            return 5;
        }
        if (typeName.equals("WeekDays")) {
            return 6;
        }
        if (typeName.equals("Days")) {
            return 7;
        }
        if (typeName.equals("Hours")) {
            return 8;
        }
        if (typeName.equals("Minutes")) {
            return 9;
        }
        if (typeName.equals("Sconds")) {
            return 10;
        }
        throw new OlapException("Unknown level type '" + typeName + "'");
    }

    public static boolean isTimeLevel(String typeName) throws OlapException {
        if (typeName.equals("Standard")) {
            return false;
        }
        if (typeName.equals("Years")) {
            return true;
        }
        if (typeName.equals("Quarters")) {
            return true;
        }
        if (typeName.equals("Months")) {
            return true;
        }
        if (typeName.equals("Weeks")) {
            return true;
        }
        if (typeName.equals("WeekDays")) {
            return true;
        }
        if (typeName.equals("Days")) {
            return true;
        }
        if (typeName.equals("Hours")) {
            return true;
        }
        if (typeName.equals("Minutes")) {
            return true;
        }
        if (typeName.equals("Sconds")) {
            return true;
        }
        throw new OlapException("Unknown level type '" + typeName + "'");
    }

    public static Locale findLocale(String name) {
        Locale[] ls = Locale.getAvailableLocales();
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].toString().equalsIgnoreCase(name)) continue;
            return ls[i];
        }
        return null;
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException("assert failed");
        }
    }

    public static void assertTrue(boolean b, String message) {
        if (!b) {
            throw new RuntimeException("assert failed: " + message);
        }
    }

    public static void assertPrecondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPrecondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static void assertPostcondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPostcondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static RuntimeException newInternal(String message) {
        return new RuntimeException(message);
    }

    public static RuntimeException newInternal(Throwable e, String message) {
        return new RuntimeException(message, e);
    }

    public static String quoteForMdx(String val) {
        StringBuilder buf = new StringBuilder(val.length() + 20);
        buf.append("\"");
        String s0 = Util.replace(val, "\"", "\"\"");
        buf.append(s0);
        buf.append("\"");
        return buf.toString();
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Util.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static List makeMutable(List list) {
        return list instanceof ArrayList ? list : new ArrayList(list);
    }

    public static String[] explode(Member parent, String name) {
        int depth = parent.getDepth();
        String[] ret = new String[depth + 2];
        ret[ret.length - 1] = name;
        while (parent != null) {
            ret[parent.getDepth()] = parent.getName();
            parent = parent.getParentMember();
        }
        return ret;
    }

    public static String[] explode(String s) throws OlapException {
        if ((s = s.trim()).indexOf(96) < 0 && s.indexOf(".") < 0) {
            return new String[]{s};
        }
        ArrayList<String> list = new ArrayList<String>(16);
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '`') {
                throw new OlapException("Invalid member:" + s);
            }
            int j = s.indexOf("`.", i);
            if (j == -1) {
                j = s.lastIndexOf(96);
            }
            if (j <= i) {
                throw new OlapException("Invalid member:" + s);
            }
            String sub = s.substring(i + 1, j);
            list.add(sub);
            if (j + 1 < s.length() && s.charAt(j + 1) != '.') {
                throw new OlapException("Invalid member:+s");
            }
            i = j + 2;
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    public static String implode(String[] names) {
        if (names.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append('`');
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append("`.`");
            }
            sb.append(names[i]);
        }
        sb.append('`');
        return sb.toString();
    }

    public static String bracketsAround(String orig) {
        if (orig.startsWith("`") && orig.endsWith("`")) {
            return orig;
        }
        return "`" + orig + "`";
    }

    public static String trimBracketsAround(String orig) {
        if (orig.startsWith("`") && orig.endsWith("`")) {
            return orig.substring(1, orig.length() - 1);
        }
        return orig;
    }

    public static String trim(String s) {
        return Util.ltrim(Util.rtrim(s));
    }

    public static String ltrim(String s) {
        if (s == null) {
            return null;
        }
        char[] chs = s.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            char ch = chs[i];
            if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\f') continue;
            return s.substring(i);
        }
        return s;
    }

    public static String rtrim(String s) {
        if (s == null) {
            return null;
        }
        char[] chs = s.toCharArray();
        int n = chs.length;
        for (int i = n - 1; i >= 0; --i) {
            char ch = chs[i];
            if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\f') continue;
            return s.substring(0, i + 1);
        }
        return s;
    }

    public static Object getLevelValue(int levelType, Object value) {
        if (levelType == 0 || !(value instanceof java.util.Date)) {
            return value;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((java.util.Date)value);
        switch (levelType) {
            case 2: {
                return calendar.get(1);
            }
            case 3: {
                return calendar.get(2) / 3 + 1;
            }
            case 4: {
                return calendar.get(2) + 1;
            }
            case 5: {
                return calendar.get(3);
            }
            case 6: {
                return calendar.get(7);
            }
            case 7: {
                return calendar.get(5);
            }
            case 8: {
                return calendar.get(11);
            }
            case 9: {
                return calendar.get(12);
            }
            case 10: {
                return calendar.get(13);
            }
        }
        return value;
    }

    public static String decideDataType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "STRING";
        }
        if (value instanceof Number) {
            return "NUMERIC";
        }
        if (value instanceof Boolean) {
            return "BOOLEAN";
        }
        if (value instanceof Date) {
            return "DATE";
        }
        if (value instanceof Time) {
            return "TIME";
        }
        if (value instanceof Timestamp) {
            return "TIMESTAMP";
        }
        return "UNKNOWN";
    }

    public static String getLevelCaptionColumn(LevelDef levelDef) {
        String column = levelDef.column;
        if (levelDef.properties != null) {
            for (int i = 0; i < levelDef.properties.length; ++i) {
                String prop = levelDef.properties[i].name;
                if (prop.equals("name")) {
                    column = levelDef.properties[i].column;
                    continue;
                }
                if (!prop.equals("caption")) continue;
                return levelDef.properties[i].column;
            }
        }
        return column;
    }

    public static String getTimeLevelCaption(LevelDef levelDef) {
        try {
            switch (Util.getLevelType(levelDef.type)) {
                case 2: {
                    return "Year";
                }
                case 4: {
                    return "Month";
                }
                case 3: {
                    return "Quarter";
                }
                case 5: {
                    return "Week";
                }
                case 7: {
                    return "Day";
                }
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return levelDef.caption;
    }

    public static String getTimeLevelCaption(Level level) {
        String caption = level.getLevelDef().caption;
        if (caption != null && !"".equals(caption)) {
            return caption;
        }
        switch (level.getLevelType()) {
            case 2: {
                return "Year";
            }
            case 4: {
                return "Month";
            }
            case 3: {
                return "Quarter";
            }
            case 5: {
                return "Week";
            }
            case 7: {
                return "Day";
            }
        }
        return level.getCaption();
    }

    public static String fixTimeMemberCaption(Member member) {
        return Util.fixTimeMemberCaption(member, Config.getConfig(Locale.CHINA));
    }

    public static String fixTimeMemberCaption(Member member, Config config) {
        Object key = member.getKey();
        String name = key.toString();
        switch (member.getLevel().getLevelType()) {
            case 2: {
                name = Util.fixName(name, config.yearPrefix, config.yearPostfix);
                break;
            }
            case 4: {
                name = config.monthNames[((Number)key).intValue() - 1];
                break;
            }
            case 3: {
                name = config.quarterNames[((Number)key).intValue() - 1];
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                name = config.weekNames[((Number)key).intValue() - 1];
                break;
            }
            case 7: {
                name = Util.fixName(name, config.dayPrefix, config.dayPostfix);
                break;
            }
            case 8: {
                name = Util.fixName(name, config.hourPrefix, config.hourPostfix);
                break;
            }
            case 9: {
                name = Util.fixName(name, config.minutePrefix, config.minutePostfix);
                break;
            }
            case 10: {
                name = Util.fixName(name, config.secondPrefix, config.secondPostfix);
            }
        }
        return name;
    }

    private static String fixName(String name, String prefix, String postfix) {
        if (prefix != null) {
            name = prefix + name;
        }
        if (postfix != null) {
            name = name + postfix;
        }
        return name;
    }

    public static BigDecimal internBigDecimal(BigDecimal bd) {
        if (bd.compareTo(zeroDecimal) == 0) {
            return zeroDecimal;
        }
        if (bd.compareTo(oneDecimal) == 0) {
            return oneDecimal;
        }
        if (bd.compareTo(negOneDecimal) == 0) {
            return negOneDecimal;
        }
        return bd;
    }

    public static boolean tupleContains(Member[] first, Member[] second) {
        List<Member> list1 = Arrays.asList(first);
        List<Member> list2 = Arrays.asList(second);
        return list1.containsAll(list2);
    }
}

