/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import kd.epm.eb.algo.olap.util.Walkable;

public class Walker
implements Enumeration {
    private final Stack stack = new Stack();
    private Frame currentFrame = null;
    private Object nextNode;

    public Walker(Walkable root) {
        this.visit(null, root);
    }

    private void moveToNext() {
        if (this.stack.empty()) {
            return;
        }
        this.currentFrame = (Frame)this.stack.peek();
        do {
            Frame frame = (Frame)this.stack.peek();
            if (frame.children != null && ++frame.childIndex < frame.children.length) {
                this.visit(frame, frame.children[frame.childIndex]);
                return;
            }
            this.stack.pop();
        } while (!this.stack.empty());
        this.nextNode = null;
    }

    private void visit(Frame parent, Object node) {
        this.nextNode = node;
        this.stack.addElement(new Frame(parent, node));
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextNode != null;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        this.moveToNext();
        return this.currentFrame.node;
    }

    public void prune() {
        if (this.currentFrame.children != null) {
            this.currentFrame.childIndex = this.currentFrame.children.length;
        }
        if (this.hasMoreElements()) {
            Object nextFrameParentNode = ((Frame)this.stack.peek()).parent.node;
            if (nextFrameParentNode != this.currentFrame.node) {
                return;
            }
            this.stack.pop();
            if (this.currentFrame.parent != null) {
                this.currentFrame = this.currentFrame.parent;
            }
            this.nextElement();
        }
    }

    public void pruneSiblings() {
        this.prune();
        this.currentFrame = this.currentFrame.parent;
        if (this.currentFrame != null) {
            this.prune();
        }
    }

    public Object currentElement() {
        return this.currentFrame.node;
    }

    public int level() {
        int i = 0;
        Frame f = this.currentFrame;
        while (f != null) {
            ++i;
            f = f.parent;
        }
        return i;
    }

    public final Object getParent() {
        return this.getAncestor(1);
    }

    public final Object getAncestor(int iDepth) {
        Frame f = this.getAncestorFrame(iDepth);
        return f == null ? null : f.node;
    }

    private Frame getAncestorFrame(int iDepth) {
        Frame f = this.currentFrame;
        while (f != null) {
            if (iDepth-- == 0) {
                return f;
            }
            f = f.parent;
        }
        return null;
    }

    public int getOrdinal() {
        return this.currentFrame.parent == null ? 0 : Walker.arrayFind(this.currentFrame.parent.children, this.currentFrame.node);
    }

    public int getAncestorOrdinal(int iDepth) {
        Frame f = this.getAncestorFrame(iDepth);
        return f == null ? -1 : (f.parent == null ? 0 : Walker.arrayFind(f.parent.children, f.node));
    }

    public Object[] getChildren(Object node) {
        if (node instanceof Walkable) {
            return ((Walkable)node).getChildren();
        }
        return null;
    }

    private static int arrayFind(Object[] array, Object o) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != o) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) {
        Region region;
        PrintWriter pw = new PrintWriter(System.out);
        Region usa = new Region("USA", new Region[]{new Region("CA", new Region[]{new Region("San Francisco", new Region[]{new Region("WesternAddition", new Region[]{new Region("Haight", null)}), new Region("Soma", null)}), new Region("Los Angeles", null)}), new Region("WA", new Region[]{new Region("Seattle", null), new Region("Tacoma", null)})});
        Walker walker = new Walker(usa);
        while (walker.hasMoreElements()) {
            region = (Region)walker.nextElement();
            pw.println(region.name);
            pw.flush();
        }
        walker = new Walker(usa);
        Region.walkUntil(walker, "CA");
        walker.prune();
        region = (Region)walker.nextElement();
        pw.println(region.name);
        pw.flush();
        walker = new Walker(usa);
        Region.walkUntil(walker, "USA");
        walker.prune();
        region = (Region)walker.nextElement();
        if (region == null) {
            pw.println("null");
        }
        pw.flush();
        walker = new Walker(usa);
        Region.walkUntil(walker, "Los Angeles");
        walker.prune();
        region = (Region)walker.nextElement();
        pw.println(region.name);
        pw.flush();
        walker = new Walker(usa);
        Region.walkUntil(walker, "Haight");
        walker.prune();
        region = (Region)walker.nextElement();
        pw.println(region.name);
        pw.flush();
        walker = new Walker(usa);
        Region.walkUntil(walker, "Soma");
        walker.prune();
        region = (Region)walker.nextElement();
        pw.println(region.name);
        pw.flush();
        walker = new Walker(usa);
        Region.walkUntil(walker, "CA");
        walker.pruneSiblings();
        region = (Region)walker.nextElement();
        if (region == null) {
            pw.println("null");
            pw.flush();
        }
        walker = new Walker(usa);
        Region.walkUntil(walker, "Soma");
        walker.pruneSiblings();
        region = (Region)walker.nextElement();
        pw.println(region.name);
        pw.flush();
    }

    private static class Region
    implements Walkable {
        String name;
        Region[] children;

        Region(String name, Region[] children) {
            this.name = name;
            this.children = children;
        }

        @Override
        public Object[] getChildren() {
            return this.children;
        }

        public static void walkUntil(Walker walker, String name) {
            while (walker.hasMoreElements()) {
                Region region = (Region)walker.nextElement();
                if (!region.name.equals(name)) continue;
                break;
            }
        }
    }

    private class Frame {
        final Frame parent;
        final Object node;
        final Object[] children;
        int childIndex;

        Frame(Frame parent, Object node) {
            this.parent = parent;
            this.node = node;
            this.children = Walker.this.getChildren(node);
            this.childIndex = -1;
        }
    }
}

