/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.bcs.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.bcs.forecast.PredictDataService;
import kd.epm.bcs.forecast.PredictService;
import kd.epm.bcs.forecast.model.ResultModel;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.business.forecast.ForecastConstants;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.QueryService;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.business.forecast.model.PredParam;
import kd.epm.eb.business.forecast.model.PredTarget;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;

public class Predict {
    private static final Log log = LogFactory.getLog(Predict.class);
    private static final String LOG_PREFIX = "EB-PREDICT";
    private final long modelId;
    private final long datasetId;
    private final Long canvasId;
    private final Long sandboxId;
    private final Long schemeId;
    private final Long reportProcessId;
    private IModelCacheHelper modelCache;
    private List<Dimension> dimensionList;
    private List<String> sortedDimList;
    private boolean seasonal;
    private boolean holiday;
    private String unusualFill;
    private String useModel;
    private boolean autoWrite;
    private int sampleLen;
    private String predStartNumber;
    private String predEndNumber;
    private List<PredTarget> predTargetList;
    private List<PredFactor> predFactorList;
    private Map<String, List<Double>> factorDataMap;
    private String attach;
    private String reqType;
    private int predLength;
    private List<Member> periodList;
    private Set<String> periodNumSet;
    private BgPeriodHelper.PeriodType periodType;

    public Predict(String param, long modelId, long datasetId, Long schemeId, Long reportProcessId, Long canvasId, Long sandboxId) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.schemeId = schemeId;
        this.reportProcessId = reportProcessId;
        this.canvasId = canvasId;
        this.sandboxId = sandboxId;
        this.factorDataMap = Collections.emptyMap();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.parseParam(param);
        log.info("{} parseParam cost:{}ms param:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), param});
        stopwatch.reset();
    }

    private void parseParam(String param) {
        PredParam predParam = (PredParam)JSON.parseObject((String)param, PredParam.class);
        this.predStartNumber = predParam.getBpStart().getNumber();
        this.predEndNumber = predParam.getBpEnd().getNumber();
        this.sampleLen = predParam.getBpNum();
        this.seasonal = predParam.getSeasonal();
        this.holiday = predParam.getHoliday();
        this.unusualFill = predParam.getUnFill();
        this.useModel = predParam.getUseModel();
        this.autoWrite = predParam.getAutoWrite();
        this.reqType = predParam.getReqType();
        this.predTargetList = predParam.getTargets().stream().filter(target -> StringUtils.isNotBlank((CharSequence)target.getHashId())).collect(Collectors.toList());
        this.predFactorList = predParam.getFactors().stream().filter(factor -> StringUtils.isNotBlank((CharSequence)factor.getHashId())).collect(Collectors.toList());
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.dimensionList = this.modelCache.getDimensionList(Long.valueOf(this.datasetId));
        this.sortedDimList = this.dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        this.initSampleAndPredPeriod();
    }

    private void initSampleAndPredPeriod() {
        List<Member> predBgList;
        if (this.predStartNumber.equals(this.predEndNumber)) {
            Member member = this.modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, this.predStartNumber);
            predBgList = Collections.singletonList(member);
        } else {
            predBgList = this.modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), this.predStartNumber, this.predEndNumber, true);
        }
        this.periodType = BgPeriodHelper.parse((String)predBgList.get(0).getNumber());
        this.predLength = predBgList.size();
        Member sampleStartMember = this.modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), this.predStartNumber, -this.sampleLen);
        this.periodList = this.modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), sampleStartMember.getNumber(), this.predEndNumber, true);
        this.periodNumSet = this.periodList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
    }

    public long doPredict() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long predictRecordId = this.createPredictRecord();
        log.info("{} recordId: {} createRecord cost:{}ms", new Object[]{LOG_PREFIX, predictRecordId, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stopwatch.reset().start();
        this.queryFactorData();
        log.info("{} recordId: {} queryFactorData cost:{}ms", new Object[]{LOG_PREFIX, predictRecordId, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stopwatch.reset().start();
        this.updateDoingStatus(predictRecordId);
        EpmThreadPools.CommPools.execute(() -> {
            this.predTargetList.forEach(predTarget -> this.doPredict(predictRecordId, (PredTarget)predTarget));
            if (PredictRecordService.getInstance().updatePredict(predictRecordId)) {
                PredictService.getInstance().queryPredictData(predictRecordId);
            }
        });
        log.info("{} recordId: {} commitTask cost:{}ms", new Object[]{LOG_PREFIX, predictRecordId, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return predictRecordId;
    }

    private long createPredictRecord() {
        String targetName = this.predTargetList.stream().map(PredTarget::getName).collect(Collectors.joining(","));
        String factorName = this.predFactorList.stream().map(PredFactor::getName).collect(Collectors.joining(","));
        Map<String, String> factorNameMap = this.predFactorList.stream().collect(Collectors.toMap(k -> "A" + k.getHashId(), PredFactor::getName, (o1, o2) -> o2));
        return PredictRecordService.getInstance().create(this.modelId, this.datasetId, this.schemeId, this.reportProcessId, this.canvasId, this.sandboxId, this.attach, targetName, factorName, this.useModel, this.predStartNumber, this.predEndNumber, Integer.valueOf(this.sampleLen), this.predTargetList, this.autoWrite, JSONObject.toJSONString(factorNameMap), Integer.valueOf(this.periodType.getType()));
    }

    private void updateDoingStatus(long predictRecordId) {
        PredictRecordService.getInstance().updateStatus(predictRecordId, ForecastConstants.Status.DOING);
    }

    private void doPredict(long predictRecordId, PredTarget predTarget) {
        String requestId = "";
        String reason = "";
        ForecastConstants.Status status = ForecastConstants.Status.FAIL;
        Map cellDimMap = PredictHelper.json2Map((String)predTarget.getNumber());
        Long dimHashId = PredictHelper.calcDimHashId(this.dimensionList, (Map)cellDimMap);
        try {
            BigDecimal dataUnit;
            JSONObject pyReqModel;
            if (!PredictResultService.getInstance().updateDoing(predictRecordId, dimHashId.longValue())) {
                return;
            }
            Map sampleDimMap = PredictHelper.json2Map((String)predTarget.getSampleNumber());
            Map dimViewMap = PredictHelper.getViewMap((String)predTarget.getDimView());
            Set<String> unusualBgList = Collections.emptySet();
            if (StringUtils.isNotBlank((CharSequence)predTarget.getUnPeriodNumber())) {
                unusualBgList = new HashSet(JSON.parseArray((String)predTarget.getUnPeriodNumber(), String.class));
            }
            if ((pyReqModel = this.buildRequestModel(sampleDimMap, dimViewMap, unusualBgList, dataUnit = PredictHelper.getDataUnit((String)predTarget.getDataUnit()))) == null) {
                reason = ResManager.loadKDString((String)"\u6ca1\u6709\u8db3\u591f\u7684\u6837\u672c\u6570\u636e\u8fdb\u884c\u8bad\u7ec3\uff0c\u8bf7\u68c0\u67e5\u9884\u6d4b\u53c2\u6570\u548c\u7528\u6237\u6570\u636e\u6743\u9650\u3002", (String)"ForecastService_14", (String)"epm-eb-bcs", (Object[])new Object[0]);
            } else {
                requestId = RequestContext.get().getTenantId() + GlobalIdUtil.genGlobalLongId();
                ResultModel resultModel = PredictDataService.getInstance().startPredictService(pyReqModel, requestId);
                if (resultModel.getStatus().booleanValue() && requestId.equals(resultModel.getData().getString("requestId"))) {
                    status = ForecastConstants.Status.PREDICT;
                } else {
                    reason = resultModel.getMessage();
                    log.error(resultModel.toString(), (Object)reason);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            reason = ResManager.loadKDString((String)"\u8c03\u7528\u9884\u6d4b\u670d\u52a1\u62a5\u9519\u3002", (String)"ForecastService_16", (String)"epm-eb-bcs", (Object[])new Object[0]);
        }
        PredictResultService.getInstance().updateStatus(predictRecordId, dimHashId.longValue(), requestId, status, reason);
    }

    private void queryFactorData() {
        if (CollectionUtils.isEmpty(this.predFactorList)) {
            return;
        }
        List<Long> viewIds = this.queryViewIdExisted();
        HashSet excludeFactors = new HashSet(this.predFactorList.size());
        String firstPeriodNum = this.periodList.get(0).getNumber();
        String lastPeriodNum = this.periodList.get(this.periodList.size() - 1).getNumber();
        ArrayList factorDtoList = new ArrayList(this.predFactorList.size());
        this.predFactorList.forEach(factor -> {
            long modelId = IDUtils.toLong((Object)factor.getModel());
            long datasetId = IDUtils.toLong((Object)factor.getDataset());
            IModelCacheHelper factorModelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Member firstPeriodMember = factorModelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, firstPeriodNum);
            Member lastPeriodMember = factorModelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, lastPeriodNum);
            if (firstPeriodMember == null || lastPeriodMember == null) {
                excludeFactors.add(factor.getHashId());
                return;
            }
            Map viewMap = PredictHelper.getViewMap((String)factor.getDimView());
            Map memberInfo = PredictHelper.json2Map((String)factor.getDimConf());
            Map<String, Set> queryDim = memberInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
                List memberDtos = JSON.parseArray((String)((String)v.getValue()), MemberDto.class);
                if (CollectionUtils.isNotEmpty((Collection)memberDtos)) {
                    String dimNumber = (String)v.getKey();
                    String number = ((MemberDto)memberDtos.get(0)).getNumber();
                    this.checkDimension(factorModelCache, datasetId, dimNumber, (Long)viewMap.get(dimNumber), number, factor.getName(), viewIds);
                    return Sets.newHashSet((Object[])new String[]{number});
                }
                return Collections.emptySet();
            }, (o1, o2) -> {
                o2.addAll(o1);
                return o2;
            }));
            queryDim.put(SysDimensionEnum.BudgetPeriod.getNumber(), this.periodNumSet);
            QueryDto queryDto = QueryDtoHelper.getQueryDto((long)modelId, (long)datasetId, (Map)viewMap, (List)factorDtoList);
            QueryDtoHelper.mergeQueryDim((QueryDto)queryDto, queryDim);
        });
        if (CollectionUtils.isEmpty(factorDtoList)) {
            return;
        }
        kd.epm.eb.business.analysiscanvas.query.QueryService queryService = kd.epm.eb.business.analysiscanvas.query.QueryService.getInstance();
        if (IDUtils.isNotEmptyLong((Long)this.sandboxId).booleanValue()) {
            AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(this.sandboxId);
            queryService.querySandboxData(canvasBox, factorDtoList, null);
        } else {
            queryService.queryBaseData(factorDtoList, null);
        }
        this.factorDataMap = new HashMap<String, List<Double>>(this.predFactorList.size());
        this.predFactorList.forEach(factor -> {
            if (excludeFactors.contains(factor.getHashId())) {
                return;
            }
            long modelId = IDUtils.toLong((Object)factor.getModel());
            long datasetId = IDUtils.toLong((Object)factor.getDataset());
            Map viewMap = PredictHelper.json2Map((String)factor.getDimView());
            Map memberInfo = PredictHelper.json2Map((String)factor.getDimConf());
            BigDecimal dataUnit = PredictHelper.getDataUnit((String)factor.getDataUnit());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
            List sortedDimList = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Map<String, String> queryDim = memberInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
                List memberDtos = JSON.parseArray((String)((String)v.getValue()), MemberDto.class);
                if (CollectionUtils.isNotEmpty((Collection)memberDtos)) {
                    return ((MemberDto)memberDtos.get(0)).getNumber();
                }
                return modelCache.getDimension((String)v.getKey()).getNoneNumber();
            }, (o1, o2) -> o2));
            QueryDto queryDto = QueryDtoHelper.getQueryDto((long)modelId, (long)datasetId, (Map)viewMap, (List)factorDtoList);
            Map bgCellMap = queryDto.getQueryResult();
            int periodLen = this.periodList.size();
            int sampleLength = periodLen - this.predLength;
            ArrayList dataList = new ArrayList(20);
            AtomicBoolean emptyFlag = new AtomicBoolean(true);
            AtomicInteger indexCount = new AtomicInteger(0);
            this.periodList.forEach(mem -> {
                int index = indexCount.incrementAndGet();
                String bpNumber = mem.getNumber();
                BigDecimal xValueObj = this.getValue(bpNumber, queryDim, null, bgCellMap, modelCache, sortedDimList, dataUnit);
                if (index > sampleLength) {
                    // empty if block
                }
                if (xValueObj != null) {
                    dataList.add(xValueObj.doubleValue());
                    if (index <= sampleLength) {
                        emptyFlag.set(false);
                    }
                } else {
                    dataList.add(null);
                }
            });
            if (!emptyFlag.get()) {
                this.factorDataMap.put(factor.getHashId(), dataList);
            }
        });
    }

    public JSONObject buildRequestModel(Map<String, String> sampleDimMap, Map<String, Long> viewMap, Set<String> unusualBgList, BigDecimal dataUnit) {
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(sampleDimMap.size());
        sampleDimMap.forEach((dim, mem) -> {
            Set cfr_ignored_0 = queryDim.put((String)dim, Sets.newHashSet((Object[])new String[]{mem}));
        });
        queryDim.put(SysDimensionEnum.BudgetPeriod.getNumber(), this.periodNumSet);
        Map bgCellMap = QueryService.getInstance().queryCurrData(this.modelId, this.datasetId, this.sandboxId, queryDim, viewMap);
        if (MapUtils.isEmpty((Map)bgCellMap)) {
            return null;
        }
        JSONObject reqModelData = this.buildReqModelData(sampleDimMap, unusualBgList, bgCellMap, dataUnit);
        if (reqModelData == null) {
            return null;
        }
        return reqModelData;
    }

    private JSONObject buildReqModelData(Map<String, String> sampleDimMap, Set<String> unusualBgList, Map<MembersKey, BGCell> bgCellMap, BigDecimal dataUnit) {
        List<String> factorNumberList;
        JSONObject bizParamsJo = new JSONObject();
        String targetCol = "A" + sampleDimMap.get(SysDimensionEnum.Account.getNumber());
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"index", targetCol});
        List<String> list = factorNumberList = CollectionUtils.isNotEmpty(this.predFactorList) ? this.factorDataMap.keySet().stream().map(k -> "A" + k).collect(Collectors.toList()) : Collections.emptyList();
        if (CollectionUtils.isNotEmpty(factorNumberList)) {
            columns.addAll(factorNumberList);
        }
        List fieldList = columns.stream().map(e -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fieldKey", e);
            return jsonObject;
        }).collect(Collectors.toList());
        JSONObject field = new JSONObject();
        field.put("fieldList", fieldList);
        bizParamsJo.put("metadata", (Object)field);
        int periodLen = this.periodList.size();
        int sampleLength = periodLen - this.predLength;
        ArrayList dataset = new ArrayList(periodLen);
        ArrayList futureDataset = new ArrayList(periodLen);
        AtomicBoolean emptyFlag = new AtomicBoolean(true);
        AtomicInteger indexCount = new AtomicInteger(0);
        this.periodList.forEach(mem -> {
            int index = indexCount.incrementAndGet();
            ArrayList<Object> rowList = new ArrayList<Object>(20);
            String bpNumber = mem.getNumber();
            Date date = PredictHelper.periodNumberToDate((String)bpNumber);
            rowList.add(DateFormatUtils.ISO_DATE_FORMAT.format(date));
            ArrayList factorList = new ArrayList(this.predFactorList.size());
            if (CollectionUtils.isNotEmpty(this.predFactorList)) {
                this.predFactorList.forEach(factor -> {
                    Double factorVal = null;
                    List<Double> factorDataList = this.factorDataMap.get(factor.getHashId());
                    if (CollectionUtils.isEmpty(factorDataList)) {
                        return;
                    }
                    if (index <= factorDataList.size()) {
                        factorVal = factorDataList.get(index - 1);
                    }
                    factorList.add(factorVal);
                });
            }
            if (index > sampleLength) {
                rowList.add(null);
                rowList.addAll(factorList);
                futureDataset.add(rowList);
            } else {
                BigDecimal valueObj = this.getValue(bpNumber, sampleDimMap, unusualBgList, bgCellMap, this.modelCache, this.sortedDimList, dataUnit);
                if (valueObj != null) {
                    rowList.add(valueObj.doubleValue());
                    emptyFlag.set(false);
                } else {
                    rowList.add(null);
                }
                rowList.addAll(factorList);
                dataset.add(rowList);
            }
        });
        if (emptyFlag.get()) {
            return null;
        }
        JSONObject scheme = this.buildScheme(targetCol, factorNumberList);
        bizParamsJo.put("dataset", dataset);
        bizParamsJo.put("futureDataset", futureDataset);
        bizParamsJo.put("scheme", (Object)scheme);
        return bizParamsJo;
    }

    private JSONObject buildScheme(String targetCol, List<String> columns) {
        JSONObject json = new JSONObject();
        json.put("ftimefield", (Object)"index");
        json.put("ftargetfield", (Object)Lists.newArrayList((Object[])new String[]{targetCol}));
        json.put("ftimegranularity", (Object)this.getTimeGranularity());
        json.put("fpredictlength", (Object)this.predLength);
        json.put("falgorithm", (Object)Lists.newArrayList((Object[])new String[]{this.useModel}));
        json.put("fpredictstartdate", (Object)DateFormatUtils.ISO_DATE_FORMAT.format(PredictHelper.periodNumberToDate((String)this.predStartNumber)));
        json.put("ffeaturefield", columns);
        json.put("fnanfill", (Object)this.unusualFill);
        json.put("fseasonal", (Object)this.seasonal);
        json.put("fholiday", (Object)this.holiday);
        json.put("freturndata", (Object)Lists.newArrayList((Object[])new String[]{"evaluation", "confidence", "corr", "fitval", "pred", "actpred"}));
        return json;
    }

    private String getTimeGranularity() {
        if (this.periodType == null || this.periodType.getType() == 4) {
            return "fmonth";
        }
        if (this.periodType.getType() == 1) {
            return "fyear";
        }
        if (this.periodType.getType() == 2) {
            return "fhalf_year";
        }
        if (this.periodType.getType() == 3) {
            return "fquarter";
        }
        if (this.periodType.getType() == 7) {
            return "fweek";
        }
        if (this.periodType.getType() == 8) {
            return "fdate";
        }
        return "fmonth";
    }

    private BigDecimal getValue(String bpNumber, Map<String, String> dimNum, Set<String> unusualBgList, Map<MembersKey, BGCell> bgCellMap, IModelCacheHelper modelCache, List<String> sortedDimList, BigDecimal dataUnit) {
        if (CollectionUtils.isNotEmpty(unusualBgList) && unusualBgList.contains(bpNumber)) {
            return null;
        }
        HashMap queryCellMap = Maps.newHashMap(dimNum);
        queryCellMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpNumber);
        Object cellValue = QueryService.getInstance().getCellValue(modelCache, (Map)queryCellMap, sortedDimList, bgCellMap, dataUnit);
        BigDecimal valueObj = null;
        if (cellValue != null) {
            valueObj = cellValue instanceof Long ? BigDecimal.valueOf((Long)cellValue) : (BigDecimal)cellValue;
        }
        return valueObj;
    }

    private List<Long> queryViewIdExisted() {
        Set viewIds = this.predFactorList.stream().flatMap(e -> PredictHelper.getViewMap((String)e.getDimView()).values().stream()).filter(IDUtils::isNotNull).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", viewIds)});
        return query.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    private void checkDimension(IModelCacheHelper modelCache, Long datasetId, String dimNumber, Long viewId, String memNumber, String factorName, List<Long> viewIds) {
        Map dimensionMap = modelCache.getDimensionMap(datasetId);
        Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f71\u54cd\u56e0\u7d20\uff1a%1\u7684\u7ef4\u5ea6[%2]\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"Predict_0", (String)"epm-eb-bcs", (Object[])new Object[]{factorName, dimNumber}));
        }
        if (IDUtils.isNotNull((Long)viewId) && !viewIds.contains(viewId)) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u5f71\u54cd\u56e0\u7d20\uff1a%1\u7684\u7ef4\u5ea6\u201c%2\u201d\u7684\u89c6\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u89c6\u56feid\u4e3a\u201c%3\u201c\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"Predict_1", (String)"epm-eb-bcs", (Object[])new Object[]{factorName, dimNumber, viewId}));
        }
        Member member = modelCache.getMember(dimNumber, viewId, memNumber);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f71\u54cd\u56e0\u7d20\uff1a%1\u7684\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u201c%3\u201d\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"Predict_2", (String)"epm-eb-bcs", (Object[])new Object[]{factorName, dimension.getName(), memNumber}));
        }
    }
}

