/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.bcs.forecast;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.bcs.forecast.model.ResultModel;

public class PredictDataService {
    private static final Log log = LogFactory.getLog(PredictDataService.class);
    private static final String LOG_PREFIX = "EB-PREDICT-DATA";

    public static PredictDataService getInstance() {
        return InnerClass.instance;
    }

    private PredictDataService() {
    }

    public ResultModel startPredictService(JSONObject bizParamsJo, String requestId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("{} startPredict bizParamsJo:{} requestId:{}", new Object[]{LOG_PREFIX, bizParamsJo, requestId});
        int requestType = 1;
        String bizAppId = "bgm";
        String bizParams = bizParamsJo.toJSONString();
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"ids", (String)"GpeService", (String)"predict", (Object[])new Object[]{requestId, requestType, bizAppId, bizParams});
        log.info("{} startPredict requestId:{} cost:{}ms resp:{}", new Object[]{LOG_PREFIX, requestId, stopwatch.elapsed(TimeUnit.MILLISECONDS), result});
        return (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
    }

    public ResultModel queryPredictServiceStatus(String requestId) {
        log.info("{} queryPredictStatus requestId:{}", (Object)LOG_PREFIX, (Object)requestId);
        String bizAppId = "bgm";
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"ids", (String)"GpeService", (String)"getRequestStatus", (Object[])new Object[]{requestId, bizAppId});
        log.info("{} queryPredictStatus requestId:{} resp:{}", new Object[]{LOG_PREFIX, requestId, result});
        return (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
    }

    public ResultModel queryPredictServiceData(String requestId) {
        log.info("{} queryPredictData requestId:{}", (Object)LOG_PREFIX, (Object)requestId);
        String bizAppId = "bgm";
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"ids", (String)"GpeService", (String)"getPredictResult", (Object[])new Object[]{requestId, bizAppId});
        log.info("{} queryPredictData requestId:{} resp:{}", new Object[]{LOG_PREFIX, requestId, result});
        return (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
    }

    private static class InnerClass {
        private static final PredictDataService instance = new PredictDataService();

        private InnerClass() {
        }
    }
}

