/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.bcs.forecast;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.bcs.forecast.PredictDataService;
import kd.epm.bcs.forecast.model.ResultModel;
import kd.epm.bcs.starter.EpmBcsAppStarter;
import kd.epm.eb.business.forecast.ForecastConstants;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.WriteService;
import kd.epm.eb.business.forecast.entity.PredictRecord;
import kd.epm.eb.business.forecast.entity.PredictResult;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.common.thread.EpmThreadPools;
import org.apache.commons.lang3.StringUtils;

public class PredictResultConsumer {
    private static final Log log = LogFactory.getLog(EpmBcsAppStarter.class);
    private static final ConcurrentHashMap<String, String> taskMap = new ConcurrentHashMap(100);
    private static final int MAX_RETRY = 10;

    public static PredictResultConsumer getInstance() {
        return InnerClass.instance;
    }

    private PredictResultConsumer() {
    }

    public void offer(int retryTimes, PredictResult result) {
        String taskKey = PredictResultConsumer.getTaskKey(result.getId());
        taskMap.computeIfAbsent(taskKey, k -> {
            EpmThreadPools.predictThreadPool.execute((Runnable)new PredictConsumer(retryTimes, result));
            return "1";
        });
    }

    public static String getTaskKey(Long pkId) {
        return RequestContext.get().getTenantId() + '!' + pkId;
    }

    private static void removeTask(Long pkId) {
        taskMap.remove(PredictResultConsumer.getTaskKey(pkId));
    }

    class PredictConsumer
    implements Runnable {
        private final long createTime;
        private final int retryTimes;
        private final PredictResult result;

        public PredictConsumer(int retryTimes, PredictResult result) {
            this.retryTimes = ++retryTimes;
            this.createTime = System.currentTimeMillis();
            this.result = result;
        }

        @Override
        public void run() {
            try {
                long waitTime = System.currentTimeMillis() - this.createTime;
                if (waitTime < 4000L) {
                    TimeUnit.MILLISECONDS.sleep(4000L - waitTime);
                }
                log.info("PredictResultConsumer queryResult id:{} retry:{}", (Object)this.result.getId(), (Object)this.retryTimes);
                boolean needRetry = false;
                String requestId = this.result.getRequestId();
                if (StringUtils.isEmpty((CharSequence)requestId)) {
                    String message = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u672a\u8fdb\u884c\u9884\u6d4b\u3002", (String)"ForecastService_17", (String)"epm-eb-bcs", (Object[])new Object[0]);
                    PredictResultService.getInstance().updateStatus(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), "", ForecastConstants.Status.FAIL, message);
                    return;
                }
                ResultModel resultModel = PredictDataService.getInstance().queryPredictServiceStatus(requestId);
                JSONObject data = resultModel.getData();
                if (resultModel.getStatus().booleanValue() && data.getInteger("status") == 20) {
                    ResultModel resultData = PredictDataService.getInstance().queryPredictServiceData(requestId);
                    if (resultData.getStatus().booleanValue() && resultData.getData() != null) {
                        PredModel predModel = null;
                        String reason = "";
                        try {
                            predModel = this.refreshPredictResult(this.result, resultData);
                        }
                        catch (Exception e) {
                            reason = e.getMessage();
                        }
                        ForecastConstants.Status status = predModel == null ? ForecastConstants.Status.FAIL : ForecastConstants.Status.SUCCESS;
                        PredictResultService.getInstance().update(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), predModel, status, reason);
                        if (Boolean.parseBoolean(this.result.getAutoWrite()) && predModel != null) {
                            try {
                                this.resultWrite(this.result, predModel);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                log.error("predictResult: {}", (Object)JSONObject.toJSONString((Object)this.result));
                                log.error("predModel: {}", (Object)JSONObject.toJSONString((Object)predModel));
                            }
                        }
                    } else {
                        PredictResultService.getInstance().updateStatus(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), requestId, ForecastConstants.Status.FAIL, resultModel.getMessage());
                    }
                } else if (resultModel.getStatus().booleanValue() && data.getInteger("status") == 30) {
                    PredictResultService.getInstance().updateStatus(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), requestId, ForecastConstants.Status.FAIL, data.getString("failMsg"));
                } else if (!resultModel.getStatus().booleanValue()) {
                    PredictResultService.getInstance().updateStatus(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), requestId, ForecastConstants.Status.FAIL, resultModel.getMessage());
                } else if (this.retryTimes <= 10) {
                    needRetry = true;
                } else {
                    log.info("PredictResultConsumer queryResult id:{} retry times:{} over max, abort!", (Object)this.result.getId(), (Object)this.retryTimes);
                }
                PredictResultConsumer.removeTask(this.result.getId());
                if (needRetry) {
                    PredictResultConsumer.this.offer(this.retryTimes, this.result);
                }
            }
            catch (Exception e) {
                log.error("PredictResultConsumer error: " + e.getMessage(), (Throwable)e);
                PredictResultService.getInstance().updateStatus(this.result.getRecordId().longValue(), this.result.getDimHash().longValue(), this.result.getRequestId(), ForecastConstants.Status.FAIL, e.getMessage());
            }
        }

        public PredModel refreshPredictResult(PredictResult result, ResultModel resultData) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            DecimalFormat decimalFormat = new DecimalFormat("#.####");
            String targetName = "A" + result.getAccount();
            Integer periodType = Integer.parseInt(result.getPeriodType().toString());
            JSONObject predFactorMap = JSONObject.parseObject((String)result.getFactorName());
            PredModel predModel = new PredModel();
            JSONObject data = resultData.getData();
            List fActTime = JSONObject.parseArray((String)data.getString("facttime"), String.class);
            List fPredTime = JSONObject.parseArray((String)data.getString("fpredtime"), String.class);
            List fPredDetail = JSONObject.parseArray((String)data.getString("fpreddetail"), JSONObject.class);
            Optional<JSONObject> fPredDetailField = fPredDetail.stream().filter(e -> targetName.equals(e.getString("ftargetfield"))).findFirst();
            if (fPredDetailField.isPresent()) {
                JSONObject corr;
                JSONObject targetDetail = fPredDetailField.get();
                List sampleIndexList = fActTime.stream().map(e -> {
                    try {
                        return sdf.parse((String)e).getTime();
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toList());
                predModel.setSampleIndexList(sampleIndexList);
                JSONArray sampleDataJSON = targetDetail.getJSONArray("factpred");
                if (sampleDataJSON != null) {
                    List sampleDataList = sampleDataJSON.stream().map(d -> Double.parseDouble(decimalFormat.format(d))).collect(Collectors.toList());
                    predModel.setSampleDataList(sampleDataList);
                }
                List predIndexList = fPredTime.stream().map(e -> {
                    try {
                        return sdf.parse((String)e).getTime();
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toList());
                predModel.setPredIndexList(predIndexList);
                JSONObject fEvaluation = targetDetail.getJSONObject("ffitevaluation");
                predModel.setMae(decimalFormat.format(fEvaluation.getDouble("mae")));
                predModel.setMse(decimalFormat.format(fEvaluation.getDouble("mse")));
                predModel.setRmse(decimalFormat.format(fEvaluation.getDouble("rmse")));
                predModel.setR2(decimalFormat.format(fEvaluation.getDouble("r2")));
                JSONArray confidence = targetDetail.getJSONArray("fconfidence");
                if (confidence != null && confidence.size() > 0) {
                    ArrayList confidenceStartList = new ArrayList(confidence.size());
                    ArrayList confidenceEndList = new ArrayList(confidence.size());
                    confidence.forEach(v -> {
                        JSONArray sub = (JSONArray)v;
                        if (sub.size() != 2) {
                            return;
                        }
                        Double s = sub.getDouble(0);
                        Double e = sub.getDouble(1);
                        confidenceStartList.add(Double.parseDouble(decimalFormat.format(s)));
                        confidenceEndList.add(Double.parseDouble(decimalFormat.format(e)));
                    });
                    predModel.setConfidenceMinList(confidenceStartList);
                    predModel.setConfidenceMaxList(confidenceEndList);
                }
                List predList = targetDetail.getJSONArray("fpred").stream().map(d -> Double.parseDouble(decimalFormat.format(d))).collect(Collectors.toList());
                predModel.setPredDataList(predList);
                long fitStartPoint = (Long)predModel.getSampleIndexList().get(0);
                List fitIndexList = PredictHelper.buildTimeList((Long)fitStartPoint, (int)predModel.getSampleIndexList().size(), (Integer)periodType);
                fitIndexList.remove(0);
                predModel.setFitIndexList(fitIndexList);
                JSONArray fitDataJSONArray = targetDetail.getJSONArray("ffitval");
                if (fitDataJSONArray != null) {
                    List fitDataList = fitDataJSONArray.stream().map(d -> Double.parseDouble(decimalFormat.format(d))).collect(Collectors.toList());
                    fitDataList.remove(0);
                    predModel.setFitDataList(fitDataList);
                }
                if ((corr = targetDetail.getJSONObject("fcorr")) != null && corr.size() > 0) {
                    ArrayList<JSONObject> corrList = new ArrayList<JSONObject>(corr.size());
                    for (Map.Entry entry : corr.entrySet()) {
                        String num = (String)entry.getKey();
                        JSONObject corrObj = new JSONObject();
                        if ("__fholiday__".equals(num) || "__fseasonal__".equals(num)) {
                            String name = "__fholiday__".equals(num) ? ResManager.loadKDString((String)"\u8282\u5047\u65e5", (String)"ForecastService_6", (String)"epm-eb-bcs", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b63\u8282\u6027", (String)"ForecastService_7", (String)"epm-eb-bcs", (Object[])new Object[0]);
                            corrObj.fluentPut("num", (Object)num).fluentPut("value", entry.getValue()).fluentPut("name", (Object)name);
                        } else {
                            corrObj.fluentPut("num", (Object)num).fluentPut("value", entry.getValue());
                            if (predFactorMap != null) {
                                corrObj.put("name", (Object)predFactorMap.getString(num));
                            }
                        }
                        corrList.add(corrObj);
                    }
                    corrList.sort((o1, o2) -> {
                        Double value2;
                        Double value1;
                        if (StringUtils.isBlank((CharSequence)o1.getString("value")) && StringUtils.isBlank((CharSequence)o2.getString("value"))) {
                            return 0;
                        }
                        if (StringUtils.isBlank((CharSequence)o1.getString("value"))) {
                            return 1;
                        }
                        if (StringUtils.isBlank((CharSequence)o2.getString("value"))) {
                            return -1;
                        }
                        try {
                            value1 = Double.valueOf(o1.getString("value"));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            return -1;
                        }
                        try {
                            value2 = Double.valueOf(o2.getString("value"));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            return 1;
                        }
                        return value2.compareTo(value1);
                    });
                    predModel.setCorrList(corrList);
                }
                return predModel;
            }
            return null;
        }

        private void resultWrite(PredictResult result, PredModel predModel) {
            PredictRecord record = this.getRecord(result.getRecordId());
            Map dimViewMap = PredictHelper.json2Map((String)result.getDimView());
            List members = Collections.emptyList();
            if (StringUtils.isNotBlank((CharSequence)result.getMembers())) {
                members = Arrays.stream(result.getMembers().split(",")).collect(Collectors.toList());
            }
            int periodType = result.getPeriodType().intValue();
            predModel.setPeriodType(Integer.valueOf(periodType));
            predModel.setDimViewMap(dimViewMap);
            predModel.setMembers(members);
            predModel.setDataUnit(result.getDataUnit());
            predModel.setPredIndexNumberList(PredictHelper.transTime2PeriodNumber((List)predModel.getPredIndexList(), (Integer)periodType));
            WriteService.getInstance().write(record.getModel().longValue(), record.getDataset().longValue(), record.getCanvasId(), record.getSandboxId(), Collections.singletonList(predModel));
        }

        public PredictRecord getRecord(Long recordId) {
            return PredictRecordService.getInstance().load(recordId.longValue());
        }
    }

    private static class InnerClass {
        private static final PredictResultConsumer instance = new PredictResultConsumer();

        private InnerClass() {
        }
    }
}

