/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.bcs.forecast;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.bcs.forecast.Predict;
import kd.epm.bcs.forecast.PredictResultConsumer;
import kd.epm.eb.business.forecast.PredictResultService;
import kd.epm.eb.business.forecast.entity.PredictResult;
import org.apache.commons.collections4.CollectionUtils;

public class PredictService {
    private static final Log log = LogFactory.getLog(PredictService.class);
    private static final String LOG_PREFIX = "EB-PREDICT-SERV";

    public static PredictService getInstance() {
        return InnerClass.instance;
    }

    public long predict(String param, long modelId, long datasetId, Long schemeId, Long reportProcessId, Long canvasId, Long sandboxId) {
        log.info("{} predict model:{} dataset:{} scheme:{} process:{} canvas:{} sandbox:{}", new Object[]{LOG_PREFIX, modelId, datasetId, schemeId, reportProcessId, canvasId, sandboxId});
        Predict predict = new Predict(param, modelId, datasetId, schemeId, reportProcessId, canvasId, sandboxId);
        return predict.doPredict();
    }

    public void queryPredictData(Long recordId) {
        List predictResults = PredictResultService.getInstance().queryPredict(Collections.singletonList(recordId));
        if (CollectionUtils.isEmpty((Collection)predictResults)) {
            return;
        }
        PredictResultConsumer consumer = PredictResultConsumer.getInstance();
        predictResults.forEach(predictResult -> consumer.offer(0, (PredictResult)predictResult));
    }

    private static class InnerClass {
        private static final PredictService instance = new PredictService();

        private InnerClass() {
        }
    }
}

