/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.adjrecord;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.adjrecord.AdjustSaveDto;
import kd.epm.eb.common.utils.cache.AbstractCacheServiceHelper;

public class AdjustRecordCacheHelper
extends AbstractCacheServiceHelper {
    private static final Log log = LogFactory.getLog(AdjustRecordCacheHelper.class);

    public static List<AdjustSaveDto> getAdjustRecordCache(String key) {
        List<AdjustSaveDto> adjustSaveDtos = new ArrayList<AdjustSaveDto>(16);
        try {
            String cacheStr = AdjustRecordCacheHelper.get(key, String.class);
            if (cacheStr == null) {
                return adjustSaveDtos;
            }
            adjustSaveDtos = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            if (adjustSaveDtos == null) {
                adjustSaveDtos = new ArrayList(16);
            }
        }
        catch (Exception e) {
            log.error("getAdjustRecordCache-error,", (Throwable)e);
        }
        return adjustSaveDtos;
    }

    public static void saveAdjustRecordCache(String key, List<AdjustSaveDto> adjustSaveDtos) {
        try {
            AdjustRecordCacheHelper.put(key, SerializationUtils.serializeToBase64(adjustSaveDtos), 18000);
        }
        catch (Exception e) {
            log.error("saveAdjustRecordCache-error", (Throwable)e);
        }
    }

    public static void clearCache(String key) {
        AdjustRecordCacheHelper.remove(key);
    }
}

