/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.adjrecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.epm.eb.common.ebcommon.common.Tuple;

public class AdjustRecordParam
implements Serializable {
    private static final long serialVersionUID = -8654436812489777872L;
    private int index = 0;
    private List<String> dimMembers = new ArrayList<String>();
    private List<String> memberPos = new ArrayList<String>();
    private List<Object> memberValues = new ArrayList<Object>();
    private HashMap<String, ArrayList<Integer>> memberIndex = new HashMap();
    private HashMap<String, Integer> posIndex = new HashMap();

    public List<String> getDimMembers() {
        return this.dimMembers;
    }

    public void setDimMembers(List<String> dimMembers) {
        this.dimMembers = dimMembers;
    }

    public List<String> getMemberPos() {
        return this.memberPos;
    }

    public void setMemberPos(List<String> memberPos) {
        this.memberPos = memberPos;
    }

    public List<Object> getMemberValues() {
        return this.memberValues;
    }

    public void setMemberValues(List<Object> memberValues) {
        this.memberValues = memberValues;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public HashMap<String, ArrayList<Integer>> getMemberIndex() {
        return this.memberIndex;
    }

    public void setMemberIndex(HashMap<String, ArrayList<Integer>> memberIndex) {
        this.memberIndex = memberIndex;
    }

    public HashMap<String, Integer> getPosIndex() {
        return this.posIndex;
    }

    public void setPosIndex(HashMap<String, Integer> posIndex) {
        this.posIndex = posIndex;
    }

    public void addMember(String memberJson) {
        this.addMember(memberJson, null);
    }

    public void addMember(String memberJson, String memberPx) {
        this.addMember(memberJson, memberPx, null);
    }

    public void addMember(String memberJson, String memberPx, Object value) {
        int i = this.index++;
        this.dimMembers.add(i, memberJson);
        this.memberPos.add(i, memberPx);
        this.memberValues.add(i, value);
        ArrayList<Integer> integers = this.memberIndex.get(memberJson);
        if (integers == null) {
            integers = new ArrayList(1);
        }
        integers.add(i);
        this.memberIndex.put(memberJson, integers);
        this.posIndex.put(memberPx, i);
    }

    public int size() {
        return this.index;
    }

    public Tuple<String, String, Object> getDataByMember(String memberJson) {
        ArrayList<Integer> index = this.memberIndex.get(memberJson);
        if (index == null || index.size() < 1) {
            return Tuple.create(null, null, null);
        }
        String pos = index.stream().map(k -> this.memberPos.get((int)k)).collect(Collectors.joining(";"));
        return Tuple.create(this.dimMembers.get(index.get(0)), pos, this.memberValues.get(index.get(0)));
    }

    public Tuple<String, String, Object> getDataByIdx(int idx) {
        if (idx >= this.index) {
            return Tuple.create(null, null, null);
        }
        return Tuple.create(this.dimMembers.get(idx), this.memberPos.get(idx), this.memberValues.get(idx));
    }

    public Tuple<String, String, Object> getDataByPos(String posStr) {
        Integer index = this.posIndex.get(posStr);
        if (index == null || index == -1) {
            return Tuple.create(null, null, null);
        }
        return Tuple.create(this.dimMembers.get(index), this.memberPos.get(index), this.memberValues.get(index));
    }

    public AdjustRecordParam sort() {
        Integer[] indices = new Integer[this.index];
        for (int i = 0; i < this.index; ++i) {
            indices[i] = i;
        }
        Collections.sort(Arrays.asList(indices), new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                String row2;
                if (AdjustRecordParam.this.memberPos.get(o1) == null || AdjustRecordParam.this.memberPos.get(o2) == null) {
                    return -1;
                }
                String row1 = ((String)AdjustRecordParam.this.memberPos.get(o1)).replaceAll("\\d", "");
                if (!row1.equals(row2 = ((String)AdjustRecordParam.this.memberPos.get(o2)).replaceAll("\\d", ""))) {
                    return row1.compareTo(row2);
                }
                return Integer.parseInt(((String)AdjustRecordParam.this.memberPos.get(o1)).replaceAll("[a-zA-Z]", "")) - Integer.parseInt(((String)AdjustRecordParam.this.memberPos.get(o2)).replaceAll("[a-zA-Z]", ""));
            }
        });
        ArrayList<String> copyDimMembers = new ArrayList<String>(this.dimMembers);
        ArrayList<String> copyMemberPros = new ArrayList<String>(this.memberPos);
        ArrayList<Object> copyMemberValues = new ArrayList<Object>(this.memberValues);
        this.dimMembers.clear();
        this.memberPos.clear();
        this.memberValues.clear();
        this.memberIndex.clear();
        this.posIndex.clear();
        this.index = 0;
        for (Integer idx : indices) {
            int newIndx;
            ++this.index;
            this.dimMembers.add(newIndx, (String)copyDimMembers.get(idx));
            this.memberPos.add(newIndx, (String)copyMemberPros.get(idx));
            this.memberValues.add(newIndx, copyMemberValues.get(idx));
            ArrayList<Integer> integers = this.memberIndex.get(copyDimMembers.get(idx));
            if (integers == null) {
                integers = new ArrayList(1);
            }
            integers.add(newIndx);
            this.memberIndex.put((String)copyDimMembers.get(idx), integers);
            this.posIndex.put((String)copyMemberPros.get(idx), newIndx);
        }
        return this;
    }
}

