/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.constants;

import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum ApplicableObjectEnum {
    None("0", ApplicableObjectEnum.getNoneMame()),
    Self("1", ApplicableObjectEnum.getSelfName()),
    YearOnYear("2", ApplicableObjectEnum.getYOYName()),
    YoyGrowth("3", ApplicableObjectEnum.getYGName()),
    Ring("4", ApplicableObjectEnum.getRingName()),
    RingGrowth("5", ApplicableObjectEnum.getRGName()),
    BudgetExeGrowth("6", ApplicableObjectEnum.getBEName());

    private String index;
    private MultiLangEnumBridge name;

    private ApplicableObjectEnum(String index, MultiLangEnumBridge name) {
        this.index = index;
        this.name = name;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public void setName(String name) {
        this.name = new MultiLangEnumBridge(name, "", "");
    }

    public String toString() {
        return "ApplicableObjectEnum{index='" + this.index + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public static ApplicableObjectEnum getEnumByIndex(String index) {
        for (ApplicableObjectEnum value : ApplicableObjectEnum.values()) {
            if (!index.equals(value.index)) continue;
            return value;
        }
        throw new KDBizException("not find ApplicableObjectEnum by index: " + index);
    }

    public static boolean isRateEnum(String index) {
        return ApplicableObjectEnum.YoyGrowth.index.equals(index) || ApplicableObjectEnum.RingGrowth.index.equals(index) || ApplicableObjectEnum.BudgetExeGrowth.index.equals(index);
    }

    private static MultiLangEnumBridge getBEName() {
        return new MultiLangEnumBridge("\u9884\u7b97\u6267\u884c\u7387", "ApplicableObjectEnum_6", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getRGName() {
        return new MultiLangEnumBridge("\u73af\u6bd4\u589e\u957f\u7387", "ApplicableObjectEnum_5", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getRingName() {
        return new MultiLangEnumBridge("\u73af\u6bd4", "ApplicableObjectEnum_4", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getYGName() {
        return new MultiLangEnumBridge("\u540c\u6bd4\u589e\u957f\u7387", "ApplicableObjectEnum_3", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getYOYName() {
        return new MultiLangEnumBridge("\u540c\u6bd4", "ApplicableObjectEnum_2", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getSelfName() {
        return new MultiLangEnumBridge("\u81ea\u8eab", "ApplicableObjectEnum_1", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getNoneMame() {
        return new MultiLangEnumBridge("\u4e0d\u9002\u7528", "ApplicableObjectEnum_0", "epm-eb-formplugin");
    }
}

