/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.constants;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum UnitEnum {
    SINGLE(UnitEnum.getSingle(), 0),
    THOUSAND(UnitEnum.getThousand(), 3),
    TEN_THOUSAND(UnitEnum.getTenThousand(), 4),
    MILLION(UnitEnum.getMillion(), 6),
    HUNDRED_MILLION(UnitEnum.getHundredMillion(), 8);

    private final MultiLangEnumBridge name;
    private final int unit;

    private UnitEnum(MultiLangEnumBridge name, int unit) {
        this.name = name;
        this.unit = unit;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public int getUnit() {
        return this.unit;
    }

    public static UnitEnum getUnitEnumByUnit(int unit) {
        for (UnitEnum unitEnum : UnitEnum.values()) {
            if (unitEnum.unit != unit) continue;
            return unitEnum;
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u5355\u4f4d\u7c7b\u578b\uff1a%1", (String)"UnitEnum_3", (String)"epm-eb-common", (Object[])new Object[]{unit}));
    }

    private static MultiLangEnumBridge getSingle() {
        return new MultiLangEnumBridge("\u4e2a", "UnitEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getThousand() {
        return new MultiLangEnumBridge("\u5343", "UnitEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getTenThousand() {
        return new MultiLangEnumBridge("\u4e07", "UnitEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMillion() {
        return new MultiLangEnumBridge("\u767e\u4e07", "UnitEnum_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getHundredMillion() {
        return new MultiLangEnumBridge("\u4ebf", "UnitEnum_6", "epm-eb-common");
    }
}

