/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.constants;

import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;

public enum VariableTypeEnum {
    Combination("v_combination", VariableTypeEnum.getCombName(), "eb_dimcombinationentity", "eb_dimcombination_new", 2),
    Parameter("v_parameter", VariableTypeEnum.getParamName(), "eb_dimensionparameter", "eb_dimensionparameter", 1),
    Condition("v_condition", VariableTypeEnum.getCondName(), "eb_judgecondition", "eb_judgecondition", 3),
    Function("v_function", VariableTypeEnum.getCondition(), "eb_analyzereportfuntion", "eb_analyzereportfuntion", 4),
    RptSection("v_rptSection", VariableTypeEnum.getRptSectionName(), "eb_rptsection", "eb_rptsection", 5);

    private String number;
    private MultiLangEnumBridge name;
    private String metadata;
    private String showPage;
    private Integer seq;

    private VariableTypeEnum(String number, MultiLangEnumBridge name, String metadata, String showpage, Integer seq) {
        this.number = number;
        this.name = name;
        this.metadata = metadata;
        this.showPage = showpage;
        this.seq = seq;
    }

    public static VariableTypeEnum getVariableTypeByNumber(String number) {
        for (VariableTypeEnum value : VariableTypeEnum.values()) {
            if (!value.number.equals(number)) continue;
            return value;
        }
        return null;
    }

    public MemberTypeEnum getRefMemberType() {
        MemberTypeEnum result;
        switch (this) {
            case Function: {
                result = MemberTypeEnum.RPTFUNCTION;
                break;
            }
            case Condition: {
                result = MemberTypeEnum.JUDGECONDITION;
                break;
            }
            case Combination: {
                result = MemberTypeEnum.DIMGROUP;
                break;
            }
            default: {
                result = MemberTypeEnum.DIMENSIONPARAM;
            }
        }
        return result;
    }

    public MemberQuoteResourceEnum getRefQuoteResource() {
        MemberQuoteResourceEnum result;
        switch (this) {
            case Function: {
                result = MemberQuoteResourceEnum.RptFunction;
                break;
            }
            case Condition: {
                result = MemberQuoteResourceEnum.JudgeCondition;
                break;
            }
            case Combination: {
                result = MemberQuoteResourceEnum.DimGroup;
                break;
            }
            default: {
                result = MemberQuoteResourceEnum.DIMENSIONPARAM;
            }
        }
        return result;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public void setName(String name) {
        this.name = new MultiLangEnumBridge(name, "", "");
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getShowPage() {
        return this.showPage;
    }

    public void setShowPage(String showPage) {
        this.showPage = showPage;
    }

    private static MultiLangEnumBridge getCondName() {
        return new MultiLangEnumBridge("\u5224\u65ad\u6761\u4ef6", "VariableTypeEnum_2", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getCombName() {
        return new MultiLangEnumBridge("\u6307\u6807", "VariableTypeEnum_1", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getCondition() {
        return new MultiLangEnumBridge("\u51fd\u6570", "VariableTypeEnum_3", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getParamName() {
        return new MultiLangEnumBridge("\u53c2\u6570", "VariableTypeEnum_0", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getRptSectionName() {
        return new MultiLangEnumBridge("\u62a5\u8868\u5207\u7247", "VariableTypeEnum_4", "epm-eb-formplugin");
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getSeq() {
        return this.seq;
    }
}

