/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.constants;

import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum WarnGraphEnum {
    none("0", "", WarnGraphEnum.getNoneName()),
    up("1", "\u2191", WarnGraphEnum.getUpName()),
    down("2", "\u2193", WarnGraphEnum.getDownName()),
    square("3", "\u25a1", WarnGraphEnum.getSquareName()),
    circular("4", "\u25cb", WarnGraphEnum.getCircularName()),
    triangle("5", "\u25b3", WarnGraphEnum.getTriangleName());

    private String index;
    private String content;
    private MultiLangEnumBridge describe;

    private WarnGraphEnum(String index, String content, MultiLangEnumBridge describe) {
        this.index = index;
        this.content = content;
        this.describe = describe;
    }

    private String getContentByIndex(String index) {
        for (WarnGraphEnum value : WarnGraphEnum.values()) {
            if (!index.equals(value.index)) continue;
            return value.content;
        }
        throw new KDBizException("not fond correct graph by " + index);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDescribe() {
        return this.describe.loadKDString();
    }

    public void setDescribe(String describe) {
        this.describe = new MultiLangEnumBridge(describe, "", "");
    }

    private static MultiLangEnumBridge getTriangleName() {
        return new MultiLangEnumBridge("\u4e09\u89d2\u5f62", "WarnGraphEnum_6", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getCircularName() {
        return new MultiLangEnumBridge("\u5706\u5f62", "WarnGraphEnum_5", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getSquareName() {
        return new MultiLangEnumBridge("\u6b63\u65b9\u5f62", "WarnGraphEnum_4", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getDownName() {
        return new MultiLangEnumBridge("\u4e0b\u7bad\u5934", "WarnGraphEnum_2", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getUpName() {
        return new MultiLangEnumBridge("\u4e0a\u7bad\u5934", "WarnGraphEnum_1", "epm-eb-formplugin");
    }

    private static MultiLangEnumBridge getNoneName() {
        return new MultiLangEnumBridge("\u4e0d\u9002\u7528", "WarnGraphEnum_0", "epm-eb-formplugin");
    }
}

