/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.condition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.analysereport.constants.ConditionCompareType;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.IConditionData;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.utils.IDUtils;

public class JudgeCondition
implements Serializable,
IConditionData {
    private static final long serialVersionUID = 1L;
    List<Condition> conditionList = new ArrayList<Condition>(16);

    public void addCondition(Condition condition) {
        this.conditionList.add(condition);
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    @Override
    public void selectQuote(VarQuoteInfo quoteInfo) {
        for (Condition condition : this.conditionList) {
            if (IDUtils.isNotEmptyLong(condition.getLeftVal()).booleanValue()) {
                quoteInfo.addDimGroupId(condition.getLeftVal());
            }
            if (!IDUtils.isNotEmptyLong(condition.getRightVal()).booleanValue()) continue;
            quoteInfo.addDimGroupId(condition.getRightVal());
        }
    }

    @Override
    public void check(CheckResult checkResult) {
        int rowCount = 1;
        int leftBracketCount = 0;
        for (Condition condition : this.getConditionList()) {
            if (IDUtils.isNull(condition.getLeftVal())) {
                checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u2018\u8fc7\u6ee4\u6761\u4ef6\u2019\u5206\u5f55\u7b2c%1\u884c\u2018\u7ef4\u5ea6\u7ec4\u5408\u503c\u2019\u672a\u586b", (String)"JudgeCondition_1", (String)"epm-eb-common", (Object[])new Object[]{rowCount}));
            }
            if (ConditionCompareType.DIMGROUP.getValue().equals(condition.getRightValueType()) && IDUtils.isNull(condition.getRightVal())) {
                checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u201c\u8fc7\u6ee4\u6761\u4ef6\u201d\u5206\u5f55\u7b2c%s\u884c\u201c\u7ec4\u5408\u503c\u201d\u672a\u586b\u3002", (String)"JudgeCondition_2", (String)"epm-eb-common", (Object[])new Object[]{rowCount}));
            } else if (ConditionCompareType.FIXDATA.getValue().equals(condition.getRightValueType()) && condition.getRightNumVal() == null) {
                checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u2018\u8fc7\u6ee4\u6761\u4ef6\u2019\u5206\u5f55\u7b2c%s\u884c\u2018\u56fa\u5b9a\u503c\u2019\u672a\u586b", (String)"JudgeCondition_3", (String)"epm-eb-common", (Object[])new Object[]{rowCount}));
            }
            if (leftBracketCount >= 0) {
                if (condition.isHasLeftBracket()) {
                    ++leftBracketCount;
                }
                if (condition.isHasRightBracket()) {
                    --leftBracketCount;
                }
            }
            ++rowCount;
        }
        if (leftBracketCount != 0) {
            checkResult.addErrorInfo(ResManager.loadKDString((String)"\u2018\u8fc7\u6ee4\u6761\u4ef6\u2019\u5206\u5f55\u7684\u62ec\u53f7\u6570\u4e0d\u5339\u914d\u3002", (String)"JudgeCondition_4", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }
}

