/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.fileimport;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;

public class RptVarImportLog
implements Serializable {
    private String varNum;
    private String varName;
    private String varType;
    private String importType;
    private boolean importStatus;
    private String errLog;

    public RptVarImportLog() {
    }

    public RptVarImportLog(String varNum, String varName, String varType, String importType, boolean importStatus, String errLog) {
        this.varNum = varNum;
        this.varName = varName;
        this.varType = varType;
        this.importType = importType;
        this.importStatus = importStatus;
        this.errLog = errLog;
    }

    public static DynamicObject toDynamicObject(Long modelId, Long bizModelId, String varNum, String varName, String varType, boolean replaceImport, boolean importStatus, String errLog) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysevarimportlog");
        object.set("model", (Object)modelId);
        object.set("bizmodel", (Object)bizModelId);
        object.set("varnumber", (Object)(varNum != null && varNum.length() > 255 ? varNum.substring(0, 255) : varNum));
        object.set("varname", (Object)(varName != null && varName.length() > 255 ? varName.substring(0, 255) : varName));
        object.set("vartype", (Object)(varType != null && varType.length() > 255 ? varType.substring(0, 255) : varType));
        object.set("importtype", (Object)(replaceImport ? "2" : "1"));
        object.set("importstatus", (Object)(importStatus ? "1" : "0"));
        object.set("reason", (Object)(errLog != null && errLog.length() > 2000 ? errLog.substring(0, 2000) : errLog));
        VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber(varType);
        if (variableTypeEnum != null) {
            object.set("vartypeseq", (Object)variableTypeEnum.getSeq());
        }
        return object;
    }

    public String getVarNum() {
        return this.varNum;
    }

    public void setVarNum(String varNum) {
        this.varNum = varNum;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getVarType() {
        return this.varType;
    }

    public void setVarType(String varType) {
        this.varType = varType;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public boolean isImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(boolean importStatus) {
        this.importStatus = importStatus;
    }

    public String getErrLog() {
        return this.errLog;
    }

    public void setErrLog(String errLog) {
        this.errLog = errLog;
    }
}

