/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.formula;

import com.alibaba.fastjson.annotation.JSONField;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.epm.eb.common.analysereport.constants.DataFormatTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupDataFormat;

public class DimGroupResult {
    private boolean numberType = true;
    private Object rowResult;
    private BigDecimal result = BigDecimal.ZERO;
    private boolean hasUnit = false;
    private DimGroupTypeEnum dimGroupType;
    private DimGroupDataFormat dimGroupDataFormat;
    private boolean needChangeRateDigit = false;

    @JSONField(serialize=false, deserialize=false)
    public String getShowResult() {
        String showResult = "";
        if (!this.numberType) {
            if (this.rowResult instanceof Date) {
                Date date = (Date)this.rowResult;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                showResult = sdf.format(date);
            } else if (this.rowResult != null) {
                showResult = this.rowResult.toString();
            }
        } else {
            DimGroupDataFormat dimGroupDataFormat = this.getDimGroupDataFormat();
            if (DataFormatTypeEnum.RATE == dimGroupDataFormat.getDataFormat()) {
                BigDecimal multiply = this.result.multiply(BigDecimal.TEN.pow(2));
                multiply = multiply.setScale(dimGroupDataFormat.getDigit(), RoundingMode.HALF_UP);
                showResult = multiply + "%";
            } else {
                BigDecimal divide = this.result.divide(BigDecimal.TEN.pow(dimGroupDataFormat.getUnit()), dimGroupDataFormat.getDigit(), RoundingMode.HALF_UP);
                StringBuilder formatStr = new StringBuilder("#,##0");
                if (dimGroupDataFormat.getDigit() > 0) {
                    formatStr.append('.');
                    for (int i = 0; i < dimGroupDataFormat.getDigit(); ++i) {
                        formatStr.append('0');
                    }
                }
                showResult = new DecimalFormat(formatStr.toString()).format(divide);
            }
        }
        return showResult;
    }

    @JSONField(serialize=false, deserialize=false)
    public BigDecimal getToCalculateResult() {
        DimGroupDataFormat dimGroupDataFormat = this.getDimGroupDataFormat();
        BigDecimal toCalculateResult = DataFormatTypeEnum.RATE == dimGroupDataFormat.getDataFormat() ? this.result.setScale(dimGroupDataFormat.getDigit() + 2, RoundingMode.HALF_UP) : this.result.setScale(dimGroupDataFormat.getDigit(), RoundingMode.HALF_UP);
        return toCalculateResult;
    }

    public DimGroupResult(Object rowResult) {
        this.numberType = false;
        this.rowResult = rowResult;
    }

    public DimGroupResult(BigDecimal result, Boolean hasUnit, DimGroupTypeEnum dimGroupType, DimGroupDataFormat dimGroupDataFormat) {
        this.result = result;
        this.hasUnit = hasUnit;
        this.dimGroupType = dimGroupType;
        this.dimGroupDataFormat = dimGroupDataFormat;
    }

    public DimGroupResult() {
    }

    public boolean isNumberType() {
        return this.numberType;
    }

    public void setNumberType(boolean numberType) {
        this.numberType = numberType;
    }

    public Object getRowResult() {
        return this.rowResult;
    }

    public void setRowResult(Object rowResult) {
        this.rowResult = rowResult;
    }

    public BigDecimal getResult() {
        return this.result;
    }

    public void setResult(BigDecimal result) {
        this.result = result;
    }

    public boolean isHasUnit() {
        return this.hasUnit;
    }

    public void setHasUnit(boolean hasUnit) {
        this.hasUnit = hasUnit;
    }

    public DimGroupTypeEnum getDimGroupType() {
        return this.dimGroupType;
    }

    public void setDimGroupType(DimGroupTypeEnum dimGroupType) {
        this.dimGroupType = dimGroupType;
    }

    public DimGroupDataFormat getDimGroupDataFormat() {
        return this.dimGroupDataFormat;
    }

    public void setDimGroupDataFormat(DimGroupDataFormat dimGroupDataFormat) {
        this.dimGroupDataFormat = dimGroupDataFormat;
    }

    public boolean isNeedChangeRateDigit() {
        return this.needChangeRateDigit;
    }

    public void setNeedChangeRateDigit(boolean needChangeRateDigit) {
        this.needChangeRateDigit = needChangeRateDigit;
    }

    public String toString() {
        if (this.numberType) {
            return "DimGroupResult{result=" + this.result + ", hasUnit=" + this.hasUnit + ", dimGroupType=" + (this.dimGroupType != null ? this.dimGroupType.getName() : "") + ", dimGroupDataFormat=" + (this.dimGroupDataFormat != null ? this.dimGroupDataFormat.toString() : "") + ", needChangeRateDigit=" + this.needChangeRateDigit + '}';
        }
        return "DimGroupResult{rowResult=" + this.rowResult + '}';
    }
}

