/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.formula;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.analysereport.constants.LogicOperationEnum;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;

public class FormulaNode {
    protected boolean hasLeftParentheses = false;
    protected boolean hasRightParentheses = false;
    protected FormulaNode nextNode;
    protected LogicOperationEnum logicOperation;

    public boolean isHasLeftParentheses() {
        return this.hasLeftParentheses;
    }

    public void setHasLeftParentheses(boolean hasLeftParentheses) {
        this.hasLeftParentheses = hasLeftParentheses;
    }

    public boolean isHasRightParentheses() {
        return this.hasRightParentheses;
    }

    public void setHasRightParentheses(boolean hasRightParentheses) {
        this.hasRightParentheses = hasRightParentheses;
    }

    public FormulaNode getNextNode() {
        return this.nextNode;
    }

    public void setNextNode(FormulaNode nextNode) {
        this.nextNode = nextNode;
    }

    public LogicOperationEnum getLogicOperation() {
        return this.logicOperation;
    }

    public void setLogicOperation(LogicOperationEnum logicOperation) {
        this.logicOperation = logicOperation;
    }

    public String toString() {
        FormulaNode nextNode;
        StringBuilder formulaString = new StringBuilder();
        if (this.isHasLeftParentheses()) {
            formulaString.append(LogicOperationEnum.LEFTPARENTHESES.getExpress());
        }
        this.addCurFormulaString(formulaString);
        if (this.isHasRightParentheses()) {
            formulaString.append(LogicOperationEnum.RIGHTPARENTHESES.getExpress());
        }
        if ((nextNode = this.getNextNode()) != null) {
            formulaString.append(this.getLogicOperation().getExpress());
            formulaString.append(nextNode.toString());
        }
        return formulaString.toString();
    }

    protected void addCurFormulaString(StringBuilder formulaString) {
    }

    public void calculate(Map<Long, DimGroupResult> dimGroupValues, DimGroupResult calResult, LogicOperationEnum logicOperation, int calDigit) {
        BigDecimal baseData = calResult.getResult();
        BigDecimal curNodeValue = this.calculateCurNode(dimGroupValues, calDigit);
        switch (logicOperation) {
            case PLUS: {
                baseData = baseData.add(curNodeValue);
                break;
            }
            case SUBTRACT: {
                baseData = baseData.subtract(curNodeValue);
                break;
            }
            case MULTIPLE: {
                baseData = baseData.multiply(curNodeValue);
                break;
            }
            case DIVIDE: {
                if (curNodeValue.compareTo(BigDecimal.ZERO) == 0) {
                    baseData = BigDecimal.ZERO;
                    break;
                }
                baseData = baseData.divide(curNodeValue, calDigit, RoundingMode.HALF_UP);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u903b\u8f91\u7b26\u53f7\uff1a%1", (String)"FormulaNode_0", (String)"epm-eb-common", (Object[])new Object[]{logicOperation.getExpress()}));
            }
        }
        baseData = baseData.setScale(calDigit, RoundingMode.HALF_UP);
        calResult.setResult(baseData);
        FormulaNode nextNode = this.getNextNode();
        if (nextNode != null) {
            nextNode.calculate(dimGroupValues, calResult, this.getLogicOperation(), calDigit);
        }
    }

    protected BigDecimal calculateCurNode(Map<Long, DimGroupResult> dimGroupValues, int calDigit) {
        return BigDecimal.ZERO;
    }
}

