/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.epm.eb.common.analysereport.constants.FunOperationEnum;
import kd.epm.eb.common.analysereport.constants.LogicOperationEnum;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaNode;
import kd.epm.eb.common.analysereport.pojo.formula.FunctionCalculate;

public class FunFormulaNode
extends FormulaNode {
    private FunOperationEnum funOperation;
    private List<FormulaNode> funArgs = new ArrayList<FormulaNode>(16);

    public FunOperationEnum getFunOperation() {
        return this.funOperation;
    }

    public void setFunOperation(FunOperationEnum funOperation) {
        this.funOperation = funOperation;
    }

    public List<FormulaNode> getFunArgs() {
        return this.funArgs;
    }

    public void setFunArgs(List<FormulaNode> funArgs) {
        this.funArgs = funArgs;
    }

    @Override
    protected void addCurFormulaString(StringBuilder formulaString) {
        formulaString.append("@function{");
        formulaString.append(this.funOperation.getExpress());
        formulaString.append("(");
        if (this.funArgs.size() != 0) {
            formulaString.append(this.funArgs.stream().map(FormulaNode::toString).collect(Collectors.joining(",")));
        }
        formulaString.append(")}");
    }

    @Override
    protected BigDecimal calculateCurNode(Map<Long, DimGroupResult> dimGroupValues, int calDigit) {
        ArrayList<BigDecimal> argValues = new ArrayList<BigDecimal>(16);
        for (FormulaNode funArgNode : this.funArgs) {
            DimGroupResult dimGroupResult = new DimGroupResult();
            funArgNode.calculate(dimGroupValues, dimGroupResult, LogicOperationEnum.PLUS, calDigit);
            argValues.add(dimGroupResult.getResult());
        }
        FunOperationEnum funOperation = this.getFunOperation();
        Class<FunctionCalculate> calculateClass = funOperation.getCalculateClass();
        FunctionCalculate functionCalculate = (FunctionCalculate)TypesContainer.createInstance(calculateClass);
        functionCalculate.setArgs(argValues);
        return functionCalculate.getResult();
    }
}

