/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.functions;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.analysereport.constants.FunctionEnum;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.functions.OrderFunction;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.StepDataContainer;
import kd.epm.eb.common.utils.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(name="OrderFunction", value=OrderFunction.class)})
public class Function
implements Serializable {
    private FunctionEnum functionType;
    private StepDataContainer stepData;
    private String name;
    private String number;
    private Long modelId;
    private Long busModelId;
    private String description;
    private Long id;

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBusModelId() {
        return this.busModelId;
    }

    public void setBusModelId(Long busModelId) {
        this.busModelId = busModelId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JSONField(serialize=false, deserialize=false)
    public <T extends FunctionStepData> T getStepData(String stepKey) {
        return this.getStepDataContainer().getStepData(stepKey);
    }

    @JSONField(serialize=false, deserialize=false)
    public <T extends FunctionStepData> T getStepData(FunctionStepEnum stepEnum) {
        return this.getStepData(stepEnum.name());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public FunctionEnum getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionEnum functionType) {
        this.functionType = functionType;
    }

    public StepDataContainer getStepDataContainer() {
        if (this.stepData == null) {
            this.stepData = new StepDataContainer();
        }
        return this.stepData;
    }

    public void setStepData(StepDataContainer stepData) {
        this.stepData = stepData;
    }

    public void setStepData(String stepDataStr) {
        if (StringUtils.isNotEmpty(stepDataStr) && !"null".equals(stepDataStr)) {
            this.stepData = (StepDataContainer)SerializationUtils.fromJsonString((String)stepDataStr, StepDataContainer.class);
        }
    }

    @JSONField(serialize=false, deserialize=false)
    public void setStepData(FunctionStepData stepData) {
        this.getStepDataContainer().setStepData(stepData);
    }

    public void removeStepData(String stepKey) {
        this.getStepDataContainer().removeStepData(stepKey);
    }

    public String getName() {
        return this.name;
    }

    public static Function getInstance(FunctionEnum functionType) {
        Function function = functionType == FunctionEnum.ORDER ? new OrderFunction() : new Function();
        function.setFunctionType(functionType);
        return function;
    }

    @JSONField(serialize=false, deserialize=false)
    public String getStepDataStr() {
        String dataStr = "";
        try {
            dataStr = new ObjectMapper().writerFor((TypeReference)new TypeReference<Map<String, FunctionStepData>>(){}).writeValueAsString((Object)this.stepData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return dataStr;
    }
}

