/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.functions.steps;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

@JsonTypeName(value="MemberFilter")
public class MemberFilter
extends FunctionStepData {
    private static final long serialVersionUID = -8720262645061439689L;
    private List<MemberRange> memberRanges;
    private JudgeCondition filterJudgeCondition;

    public List<MemberRange> getMemberRanges() {
        if (this.memberRanges == null) {
            this.memberRanges = new ArrayList<MemberRange>(16);
        }
        return this.memberRanges;
    }

    public void setMemberRanges(List<MemberRange> memberRanges) {
        this.memberRanges = memberRanges;
    }

    public JudgeCondition getFilterCondition() {
        return this.filterJudgeCondition;
    }

    public void setFilterCondition(JudgeCondition filterJudgeCondition) {
        this.filterJudgeCondition = filterJudgeCondition;
    }

    @Override
    @JSONField(serialize=false, deserialize=false)
    public FunctionStepEnum getStepType() {
        return FunctionStepEnum.MEMBERFILTER;
    }

    @Override
    public void selectQuote(VarQuoteInfo quoteInfo) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(quoteInfo.getModelId());
        this.getMemberRanges().forEach(memberRange -> {
            Dimension dimension = modelCacheHelper.getDimension(memberRange.getDimNum());
            if (dimension != null) {
                Long viewId = memberRange.getViewId();
                memberRange.getMemberInfoList().forEach(memberInfo -> {
                    Member member = dimension.getMember(viewId, memberInfo.getMembNum());
                    if (member != null) {
                        quoteInfo.addMemberId(dimension.getId(), member.getId());
                    }
                });
                if (IDUtils.isNotEmptyLong(viewId).booleanValue()) {
                    quoteInfo.addViewId(dimension.getId(), viewId);
                }
            }
        });
        if (this.filterJudgeCondition != null) {
            this.filterJudgeCondition.selectQuote(quoteInfo);
        }
    }

    @Override
    public void check(CheckResult checkResult) {
        List<MemberRange> memberRangeList = this.getMemberRanges();
        if (memberRangeList.isEmpty()) {
            checkResult.addErrorInfo(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6210\u5458\u8303\u56f4\u3002", (String)"MemberFilter_3", (String)"epm-eb-common", (Object[])new Object[0]));
        } else {
            int rowCount = 1;
            for (MemberRange memberRange : memberRangeList) {
                if (memberRange.getMemberInfoList().isEmpty()) {
                    checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u2018\u6210\u5458\u8303\u56f4\u2019\u7b2c%1\u884c\u5206\u5f55\u2018\u5df2\u9009\u6210\u5458\u2019\u4e3a\u7a7a", (String)"MemberFilter_1", (String)"epm-eb-common", (Object[])new Object[]{rowCount}));
                }
                if (StringUtils.isEmpty(memberRange.getDimNum())) {
                    checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u2018\u6210\u5458\u8303\u56f4\u2019\u7b2c%1\u884c\u5206\u5f55\u2018\u7ef4\u5ea6\u2019\u672a\u586b", (String)"MemberFilter_2", (String)"epm-eb-common", (Object[])new Object[]{rowCount}));
                }
                ++rowCount;
            }
            JudgeCondition filterCondition = this.getFilterCondition();
            if (filterCondition != null) {
                filterCondition.check(checkResult);
            }
        }
    }
}

