/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.functions.steps;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FieldLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

@JsonTypeName(value="ShowLayout")
public class ShowLayout
extends FunctionStepData {
    private static final long serialVersionUID = 3276247496279347329L;
    private int showAmount;
    private String showWay;
    private String fillWay;
    private String fillWayText;
    private List<FieldLayout> fieldLayoutList;
    private Map<String, Long> pageDimMembers = new HashMap<String, Long>(16);
    private Map<String, Long> pageDimMemberViewIds = new HashMap<String, Long>(16);
    private Map<Long, Long> memberVarValMap = new HashMap<Long, Long>(16);
    private Map<Long, Long> memberVarValViewIdMap = new HashMap<Long, Long>(16);

    public int getShowAmount() {
        return this.showAmount;
    }

    public void setShowAmount(int showAmount) {
        this.showAmount = showAmount;
    }

    public String getShowWay() {
        return this.showWay;
    }

    public void setShowWay(String showWay) {
        this.showWay = showWay;
    }

    public String getFillWay() {
        return this.fillWay;
    }

    public void setFillWay(String fillWay) {
        this.fillWay = fillWay;
    }

    public List<FieldLayout> getFieldLayoutList() {
        if (this.fieldLayoutList == null) {
            this.fieldLayoutList = new ArrayList<FieldLayout>(16);
        }
        return this.fieldLayoutList;
    }

    public void setFieldLayoutList(List<FieldLayout> fieldLayoutList) {
        this.fieldLayoutList = fieldLayoutList;
    }

    @Override
    @JSONField(serialize=false, deserialize=false)
    public FunctionStepEnum getStepType() {
        return FunctionStepEnum.SHOWSETTING;
    }

    public String getFillWayText() {
        return this.fillWayText;
    }

    public void setFillWayText(String fillWayText) {
        this.fillWayText = fillWayText;
    }

    @Override
    public void selectQuote(VarQuoteInfo quoteInfo) {
        this.getFieldLayoutList().forEach(fieldLayout -> {
            if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldLayout.getFieldType())) {
                quoteInfo.addDimGroupId(IDUtils.toLong(fieldLayout.getShowField()));
            } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldLayout.getFieldType())) {
                quoteInfo.addConditionId(IDUtils.toLong(fieldLayout.getShowField()));
            }
        });
    }

    public Map<String, Long> getPageDimMembers() {
        return this.pageDimMembers;
    }

    public Map<Long, Long> getMemberVarValMap() {
        return this.memberVarValMap;
    }

    public Map<Long, Long> getMemberVarValViewIdMap() {
        return this.memberVarValViewIdMap;
    }

    public void setMemberVarValViewIdMap(Map<Long, Long> memberVarValViewIdMap) {
        this.memberVarValViewIdMap = memberVarValViewIdMap;
    }

    public Map<String, Long> getPageDimMemberViewIds() {
        return this.pageDimMemberViewIds;
    }

    public void setPageDimMemberViewIds(Map<String, Long> pageDimMemberViewIds) {
        this.pageDimMemberViewIds = pageDimMemberViewIds;
    }

    @Override
    public void check(CheckResult checkResult) {
        int showAmount = this.getShowAmount();
        if (showAmount < 1 || showAmount > 100) {
            checkResult.addErrorInfo(ResManager.loadKDString((String)"\u663e\u793a\u6b21\u5e8f\u8d85\u51fa\u6570\u503c\u8303\u56f4[1,100]", (String)"ShowLayout_2", (String)"epm-eb-common", (Object[])new Object[0]));
        } else {
            List<FieldLayout> fieldLayoutList = this.getFieldLayoutList();
            int rowIndex = 1;
            for (FieldLayout fieldLayout : fieldLayoutList) {
                if (StringUtils.isEmpty(fieldLayout.getShowField()) && !FieldTypeEnum.TEXT.getValue().equals(fieldLayout.getFieldType())) {
                    checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u2018\u663e\u793a\u5185\u5bb9\u2019\u7b2c%1\u884c\u5206\u5f55\u2018\u663e\u793a\u5b57\u6bb5\u2019\u672a\u586b", (String)"ShowLayout_1", (String)"epm-eb-common", (Object[])new Object[]{rowIndex}));
                }
                ++rowIndex;
            }
        }
    }
}

