/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.functions.steps;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.constants.SortWayEnum;
import kd.epm.eb.common.analysereport.jsonutil.SortAccordDeserializer;
import kd.epm.eb.common.analysereport.jsonutil.SortAccordSerializer;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.utils.IDUtils;

@JsonTypeName(value="SortWay")
public class SortWay
extends FunctionStepData {
    private static final long serialVersionUID = 8630017446318042793L;
    private String sortWay;
    @JsonDeserialize(using=SortAccordDeserializer.class)
    @JsonSerialize(using=SortAccordSerializer.class)
    private Long sortAccord;
    private JudgeCondition sortJudgeCondition;

    public String getSortWay() {
        return this.sortWay;
    }

    public void setSortWay(String sortWay) {
        this.sortWay = sortWay;
    }

    public Long getSortAccord() {
        return this.sortAccord;
    }

    public void setSortAccord(Long sortAccord) {
        this.sortAccord = sortAccord;
    }

    public JudgeCondition getSortCondition() {
        return this.sortJudgeCondition;
    }

    public void setSortCondition(JudgeCondition sortJudgeCondition) {
        this.sortJudgeCondition = sortJudgeCondition;
    }

    @Override
    @JSONField(serialize=false, deserialize=false)
    public FunctionStepEnum getStepType() {
        return FunctionStepEnum.SORTWAY;
    }

    @Override
    public void selectQuote(VarQuoteInfo quoteInfo) {
        if (IDUtils.isNotEmptyLong(this.sortAccord).booleanValue()) {
            quoteInfo.addDimGroupId(this.sortAccord);
        }
        if (this.sortJudgeCondition != null) {
            this.sortJudgeCondition.selectQuote(quoteInfo);
        }
    }

    @Override
    public void check(CheckResult checkResult) {
        SortWayEnum sortWayByVal = SortWayEnum.getSortWayByVal(this.getSortWay());
        if (SortWayEnum.NULL != sortWayByVal && IDUtils.isNull(this.getSortAccord())) {
            checkResult.addErrorInfo(ResManager.loadKDString((String)"\u6392\u5e8f\u4f9d\u636e\u5b57\u6bb5\u672a\u586b", (String)"SortWay_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        JudgeCondition sortCondition = this.getSortCondition();
        if (!(SortWayEnum.CONDITIONDOWN != sortWayByVal && SortWayEnum.CONDITIONUP != sortWayByVal || sortCondition != null && !this.getSortCondition().getConditionList().isEmpty())) {
            checkResult.addErrorInfo(ResManager.loadKDString((String)"\u6761\u4ef6\u5224\u65ad\u5347\u964d\u5e8f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String)"SortWay_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (sortCondition != null) {
            sortCondition.check(checkResult);
        }
    }
}

