/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.analysereport.pojo.section;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.pojo.section.MultiTypeMember;
import kd.epm.eb.common.utils.StringUtils;

public class RptSection {
    private Long id;
    private Long modelId;
    private Long bizModelId;
    private Long templateId;
    private String name;
    private String number;
    private Map<String, MultiTypeMember> pageViewDimInfo = new HashMap<String, MultiTypeMember>(16);
    private Map<String, MultiTypeMember> orderDimInfo = new HashMap<String, MultiTypeMember>(16);

    public RptSection(Long id, Long modelId, Long bizModelId, Long templateId, String name, String number) {
        this.id = id;
        this.modelId = modelId;
        this.bizModelId = bizModelId;
        this.templateId = templateId;
        this.name = name;
        this.number = number;
    }

    public Long getId() {
        return this.id;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public Map<String, MultiTypeMember> getPageViewDimInfo() {
        return this.pageViewDimInfo;
    }

    public Map<String, MultiTypeMember> getOrderDimInfo() {
        return this.orderDimInfo;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public static RptSection of(DynamicObject object) {
        Long id = object.getLong("id");
        Long modelId = object.getLong("model.id");
        Long bizModelId = object.getLong("bizmodel.id");
        Long tempId = object.getLong("template.id");
        String name = object.getString("name");
        String number = object.getString("number");
        RptSection section = new RptSection(id, modelId, bizModelId, tempId, name, number);
        DynamicObjectCollection memberEntry = object.getDynamicObjectCollection("memberentry");
        RptSection.ofEntry(false, memberEntry, section.getPageViewDimInfo());
        DynamicObjectCollection orderEntry = object.getDynamicObjectCollection("orderentry");
        RptSection.ofEntry(true, orderEntry, section.getOrderDimInfo());
        return section;
    }

    private static void ofEntry(boolean isOrder, DynamicObjectCollection entryRow, Map<String, MultiTypeMember> memberMap) {
        String dimTypeKey;
        String memberKey;
        String viewKey;
        String dimKey;
        if (isOrder) {
            dimKey = "dimension1.number";
            viewKey = "dimview1.id";
            memberKey = "member1";
            dimTypeKey = "dimmembertype1";
        } else {
            dimKey = "dimension.number";
            viewKey = "dimview.id";
            memberKey = "member";
            dimTypeKey = "dimmembertype";
        }
        for (DynamicObject memberRow : entryRow) {
            String dimNumber = memberRow.getString(dimKey);
            if (!StringUtils.isNotEmpty(dimNumber)) continue;
            String dimMemberType = memberRow.getString(dimTypeKey);
            DynamicObject memberObj = memberRow.getDynamicObject(memberKey);
            Long viewId = memberRow.getLong(viewKey);
            Long memberId = memberObj == null ? 0L : memberObj.getLong("id");
            String memberNum = memberObj == null ? null : memberObj.getString("number");
            MultiTypeMember member = new MultiTypeMember(DimMemberTypeEnum.getDimMemberTypeEnumByIndex(dimMemberType), memberId, memberNum, viewId);
            memberMap.put(dimNumber, member);
        }
    }
}

