/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applyTemplate;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum TempDimConfigType {
    HIDEDIM(TempDimConfigType.getHideDim(), "hid", "panel1"),
    ROWDIM(TempDimConfigType.getRowDim(), "row", "panel3"),
    COLDIM(TempDimConfigType.getColDim(), "rank", "panel4");

    private final MultiLangEnumBridge name;
    private final String number;
    private final String value;

    private TempDimConfigType(MultiLangEnumBridge name, String number, String value) {
        this.name = name;
        this.number = number;
        this.value = value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    private static MultiLangEnumBridge getHideDim() {
        return new MultiLangEnumBridge("\u9690\u85cf\u7ef4", "TempDimConfigType_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRowDim() {
        return new MultiLangEnumBridge("\u884c\u7ef4", "TempDimConfigType_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getColDim() {
        return new MultiLangEnumBridge("\u5217\u7ef4", "TempDimConfigType_3", "epm-eb-common");
    }

    public static TempDimConfigType getDimFlexTypeByPanel(String panel) {
        for (TempDimConfigType dimConfigType : TempDimConfigType.values()) {
            if (!dimConfigType.value.equals(panel)) continue;
            return dimConfigType;
        }
        return HIDEDIM;
    }

    public static TempDimConfigType getDimFlexTypeByNumber(String number) {
        for (TempDimConfigType dimConfigType : TempDimConfigType.values()) {
            if (!dimConfigType.number.equals(number)) continue;
            return dimConfigType;
        }
        return HIDEDIM;
    }
}

