/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applyTemplate.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.epm.eb.common.applyTemplate.constants.BussPlanEntryPresetFieldsEnum;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.StringUtils;

public class CustomControlHelper {
    private CustomControlHelper() {
    }

    public static EntryFieldAp createEntryFieldAp(String fieldKey, String fieldName, FieldTypeEnum fieldTypeEnum) {
        HashMap<String, String> propMap = new HashMap<String, String>(16);
        propMap.put("lock", "new,view");
        EntryFieldAp entryFieldAp = CustomControlHelper.createDynamicEntryFieldAp(fieldKey, fieldName, propMap);
        switch (fieldTypeEnum) {
            case TextField: {
                TextField textField = CustomControlHelper.createDynamicTextField(fieldKey, fieldName);
                entryFieldAp.setField((Field)textField);
                break;
            }
            case Boolean: {
                propMap.remove("lock");
                entryFieldAp = CustomControlHelper.createDynamicEntryFieldAp(fieldKey, fieldName, propMap);
                entryFieldAp.setLabelDirection("true");
                CheckBoxField dynamicCheckBoxField = CustomControlHelper.createDynamicCheckBoxField(fieldKey, fieldName);
                entryFieldAp.setField((Field)dynamicCheckBoxField);
                break;
            }
            case BaseDataField: {
                propMap.remove("lock");
                entryFieldAp = CustomControlHelper.createDynamicEntryFieldAp(fieldKey, fieldName, propMap);
                entryFieldAp.setQuickAddNew(false);
                BasedataField basedataField = CustomControlHelper.createDynamicBasedataField(fieldKey, fieldName);
                basedataField.setViewDetail(false);
                entryFieldAp.setField((Field)basedataField);
                break;
            }
            case MulBaseDataField: {
                propMap.remove("lock");
                entryFieldAp = CustomControlHelper.createDynamicEntryFieldAp(fieldKey, fieldName, propMap);
                entryFieldAp.setQuickAddNew(false);
                MulBasedataField mulBasedataField = CustomControlHelper.createDynamicMulBasedataField(fieldKey, fieldName);
                entryFieldAp.setField((Field)mulBasedataField);
                break;
            }
        }
        return entryFieldAp;
    }

    public static EntryFieldAp createEntryMainBudgetInfoOrBusinessPlanSheetFieldAp(String fieldKey, String fieldName, FieldTypeEnum fieldTypeEnum, List<ComboItem> comboItems) {
        HashMap<String, String> propMap = new HashMap<String, String>(16);
        propMap.put("lock", "new,view");
        EntryFieldAp entryFieldAp = CustomControlHelper.createDynamicEntryFieldAp(fieldKey, fieldName, propMap);
        switch (fieldTypeEnum) {
            case TextField: {
                if (BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey().equals(fieldKey)) {
                    ComboField comboField = CustomControlHelper.createDynamicComboField(fieldKey, fieldName);
                    comboField.setMustInput(true);
                    comboField.setItems(comboItems);
                    entryFieldAp.setField((Field)comboField);
                    entryFieldAp.setLock("");
                    entryFieldAp.setFireUpdEvt(true);
                    break;
                }
                if (!BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey().equals(fieldKey)) break;
                propMap.remove("lock");
                MulComboField mulComboField = CustomControlHelper.createDynamicMulComboField(fieldKey, fieldName);
                mulComboField.setItems(comboItems);
                entryFieldAp.setField((Field)mulComboField);
                entryFieldAp.setLock("");
                entryFieldAp.setFireUpdEvt(true);
                break;
            }
        }
        return entryFieldAp;
    }

    private static ComboField createDynamicComboField(String fieldKey, String fieldName) {
        ComboField ComboField2 = new ComboField();
        ComboField2.setKey(fieldKey);
        ComboField2.setId(fieldKey);
        ComboField2.setName(new LocaleString(fieldName));
        return ComboField2;
    }

    private static MulComboField createDynamicMulComboField(String fieldKey, String fieldName) {
        MulComboField mulComboField = new MulComboField();
        mulComboField.setKey(fieldKey);
        mulComboField.setId(fieldKey);
        mulComboField.setName(new LocaleString(fieldName));
        return mulComboField;
    }

    public static MulBasedataField createDynamicMulBasedataField(String fieldKey, String fieldName) {
        MulBasedataField field = new MulBasedataField();
        field.setMustInput(true);
        field.setKey(fieldKey);
        field.setId(fieldKey);
        field.setBasedataEditStyle(1);
        field.setName(new LocaleString(fieldName));
        return field;
    }

    public static BasedataField createDynamicBasedataField(String fieldKey, String fieldName) {
        BasedataField field = new BasedataField();
        field.setMustInput(true);
        field.setKey(fieldKey);
        field.setId(fieldKey);
        field.setName(new LocaleString(fieldName));
        return field;
    }

    public static CheckBoxField createDynamicCheckBoxField(String fieldKey, String fieldName) {
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setKey(fieldKey);
        checkBoxField.setName(new LocaleString(fieldName));
        checkBoxField.setShowStyle(2);
        return checkBoxField;
    }

    public static EntryAp createDynamicEntryAp(String entryKey) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        entryAp.setPageRow(50);
        entryAp.setOrderAndFilter(0);
        return entryAp;
    }

    public static FlexPanelAp createDynamicFlexPanelAp(String panelKey) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(panelKey);
        return flexPanelAp;
    }

    public static FieldAp createDynamicFieldAp(String fieldKey, String fieldName, Map<String, String> propMap) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(fieldKey);
        fieldAp.setName(new LocaleString(fieldName));
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    public static EntryFieldAp createDynamicEntryFieldAp(String fieldKey, String fieldName, Map<String, String> propMap) {
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setKey(fieldKey);
        entryFieldAp.setId(fieldKey);
        entryFieldAp.setName(new LocaleString(fieldName));
        entryFieldAp.setFireUpdEvt(true);
        String lock = propMap.get("lock");
        if (StringUtils.isNotEmpty(lock)) {
            entryFieldAp.setLock(lock);
        }
        return entryFieldAp;
    }

    public static TextField createDynamicTextField(String fieldKey, String fieldName) {
        TextField textField = new TextField();
        textField.setKey(fieldKey);
        textField.setName(new LocaleString(fieldName));
        return textField;
    }

    public static TextProp createDynamicTextProp(String propName, String displayName) {
        TextProp textProp = new TextProp();
        textProp.setName(propName);
        textProp.setDisplayName(new LocaleString(displayName));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public static BooleanProp createDynamicBooleanProp(String propName, String displayName) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(propName);
        booleanProp.setDisplayName(new LocaleString(displayName));
        booleanProp.setDbIgnore(true);
        return booleanProp;
    }

    public static FieldProp createDynamicFieldProp(String propName, String displayName, FieldTypeEnum fieldTypeEnum) {
        FieldProp fieldProp = new FieldProp();
        switch (fieldTypeEnum) {
            case TextField: {
                fieldProp = CustomControlHelper.createDynamicTextProp(propName, displayName);
                break;
            }
            case Boolean: {
                fieldProp = CustomControlHelper.createDynamicBooleanProp(propName, displayName);
                break;
            }
        }
        return fieldProp;
    }

    public static BasedataProp createDynamicBaseDataProp(String key, String refBaseDataKey) {
        BasedataProp basedataProp = new BasedataProp();
        LongProp idprop = new LongProp();
        basedataProp.setDbIgnore(true);
        idprop.setDbIgnore(true);
        idprop.setName(key + "_id");
        basedataProp.setName(key);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)refBaseDataKey));
        basedataProp.setBaseEntityId(refBaseDataKey);
        basedataProp.setRefIdProp((IDataEntityProperty)idprop);
        basedataProp.setRefIdPropName(idprop.getName());
        return basedataProp;
    }

    public static void addMultiBaseDataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String baseDataEntity) {
        MainEntityType originalType = EntityMetadataCache.getDataEntityType((String)baseDataEntity);
        DynamicObjectType multiSelcType = new DynamicObjectType(f7key);
        multiSelcType.setAlias(originalType.getAlias());
        multiSelcType.setDbIgnore(kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)originalType.getAlias()));
        multiSelcType.setDBRouteKey(kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)originalType.getAlias()) ? originalType.getDBRouteKey() : "");
        multiSelcType.setExtendName(baseDataEntity);
        DataEntityUtils.registerProperties(multiSelcType, baseDataEntity);
        MulBasedataProp basedataProp = new MulBasedataProp(f7key, multiSelcType);
        basedataProp.setName(f7key);
        basedataProp.setBaseEntityId(baseDataEntity);
        basedataProp.setDisplayProp("name");
        DataEntityUtils.makeUnmodifiable((IDataEntityType)targetEntity);
        if (targetEntity.getParent() != null) {
            DataEntityUtils.makeUnmodifiable(targetEntity.getParent());
        }
        targetEntity.addProperty((DynamicProperty)basedataProp);
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
        } else {
            targetEntity.addProperty((DynamicProperty)basedataProp);
        }
    }

    public static ComboProp createDynamicComboFieldProp(String key, String displayName) {
        ComboProp comboProp = new ComboProp();
        comboProp.setDbIgnore(true);
        comboProp.setName(key);
        comboProp.setAlias("");
        comboProp.setDisplayName(new LocaleString(displayName));
        return comboProp;
    }
}

