/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applyTemplate.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.StatusEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.dto.DimRangeImportTemplate;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public static XSSFWorkbook createXssfWorkBook() {
        return new XSSFWorkbook();
    }

    public static XSSFSheet createXssfSheet(XSSFWorkbook xssfWorkbook) {
        return xssfWorkbook.createSheet();
    }

    public static XSSFRow createXssfRow(XSSFSheet xssfSheet, int rowIndex) {
        XSSFRow row = xssfSheet.getRow(rowIndex);
        if (row == null) {
            row = xssfSheet.createRow(rowIndex);
        }
        return row;
    }

    public static XSSFCell createXssfCell(XSSFRow xssfRow, int colIndex) {
        XSSFCell cell = xssfRow.getCell(colIndex);
        if (cell == null) {
            cell = xssfRow.createCell(colIndex);
        }
        return cell;
    }

    public static void setCellValue(XSSFSheet xssfSheet, XSSFCellStyle cellStyle, Integer rowIndex, Integer colIndex, String value, Comment comment) {
        XSSFRow xssfRow = ExcelHelper.createXssfRow(xssfSheet, rowIndex);
        if (rowIndex == 0 && colIndex == 0) {
            xssfRow.setHeight((short)600);
        }
        XSSFCell xssfCell = ExcelHelper.createXssfCell(xssfRow, colIndex);
        xssfCell.setCellValue(value);
        xssfCell.setCellComment(comment);
        if (cellStyle != null) {
            xssfCell.setCellStyle((CellStyle)cellStyle);
        }
    }

    public static void setCellValue(XSSFSheet xssfSheet, XSSFCellStyle cellStyle, Integer rowIndex, Integer colIndex, String value) {
        XSSFRow xssfRow = ExcelHelper.createXssfRow(xssfSheet, rowIndex);
        if (rowIndex == 0 && colIndex == 0) {
            xssfRow.setHeight((short)600);
        }
        XSSFCell xssfCell = ExcelHelper.createXssfCell(xssfRow, colIndex);
        xssfCell.setCellValue(value);
        if (cellStyle != null) {
            xssfCell.setCellStyle((CellStyle)cellStyle);
        }
    }

    public static void setCellValue(XSSFSheet xssfSheet, CellStyle cellStyle, Integer rowIndex, Integer colIndex, String value) {
        XSSFRow xssfRow = ExcelHelper.createXssfRow(xssfSheet, rowIndex);
        if (rowIndex == 0 && colIndex == 0) {
            xssfRow.setHeight((short)600);
        }
        XSSFCell xssfCell = ExcelHelper.createXssfCell(xssfRow, colIndex);
        xssfCell.setCellValue(value);
        if (cellStyle != null) {
            xssfCell.setCellStyle(cellStyle);
        }
    }

    public static void setCellValue(Cell cell, CellStyle cellStyle, String value) {
        if (cell != null) {
            cell.setCellValue(value);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public static String getCellValue(XSSFSheet xssfSheet, Integer rowIndex, Integer colIndex) {
        XSSFRow xssfRow = ExcelHelper.createXssfRow(xssfSheet, rowIndex);
        XSSFCell xssfCell = ExcelHelper.createXssfCell(xssfRow, colIndex);
        return xssfCell.getStringCellValue();
    }

    public static XSSFCellStyle createCellStyle(XSSFWorkbook xssfWorkbook) {
        return xssfWorkbook.createCellStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static String convertCellValueToString(Cell cell) {
        if (null == cell) {
            return null;
        }
        String returnValue = null;
        switch (cell.getCellType()) {
            case STRING: {
                returnValue = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                double numericCellValue = cell.getNumericCellValue();
                boolean isInteger = ExcelHelper.isIntegerForDouble(numericCellValue);
                if (isInteger) {
                    DecimalFormat df = new DecimalFormat("0");
                    returnValue = df.format(numericCellValue);
                    break;
                }
                returnValue = Double.toString(numericCellValue);
                break;
            }
            case BOOLEAN: {
                boolean booleanCellValue = cell.getBooleanCellValue();
                returnValue = Boolean.toString(booleanCellValue);
                break;
            }
            case BLANK: {
                break;
            }
            case FORMULA: {
                cell.getCellFormula();
                break;
            }
            case ERROR: {
                break;
            }
        }
        return returnValue;
    }

    public static boolean isIntegerForDouble(Double num) {
        double eqs = 1.0E-10;
        return num - Math.floor(num) < eqs;
    }

    public static DimRangeImportTemplate createImportTemplateNew(List<ApplyTemplateDimCfgEntity> dimCfgList, HashMap<String, List<BizTableConfig>> relationshipCorrespondence, HashMap<String, String> hcolumnkeyMap) {
        ArrayList<Long> dimIds = new ArrayList<Long>(16);
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
            String useType = applyTemplateDimCfgEntity.getUsetype();
            if (!StringUtils.equals(useType, DimUseTypeEnum.BUSINESS_PLAN.getValue())) continue;
            dimIds.add(applyTemplateDimCfgEntity.getDimid());
        }
        Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])dimIds.toArray(), (String)"epm_dimension");
        ArrayList<Map<String, String>> headers = new ArrayList<Map<String, String>>(16);
        String mustInHeaderTip = ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"ExcelHelper_apply_01", (String)"epm-eb-common", (Object[])new Object[0]);
        String mainBudgetInfo = ResManager.loadKDString((String)"*\u4e3b\u8868\u9884\u7b97\u4fe1\u606f", (String)"ExcelHelper_apply_07", (String)"epm-eb-common", (Object[])new Object[0]);
        HashMap<String, String> mainBudgetCell = new HashMap<String, String>(16);
        mainBudgetCell.put("colIndex", "0");
        mainBudgetCell.put("rowIndex", "2");
        mainBudgetCell.put("value", mainBudgetInfo);
        headers.add(mainBudgetCell);
        String businessPlanNum = ResManager.loadKDString((String)"*\u4e1a\u52a1\u8ba1\u5212\u8868\u7f16\u7801", (String)"ExcelHelper_apply_08", (String)"epm-eb-common", (Object[])new Object[0]);
        String businessPlanCellTip = ResManager.loadKDString((String)"\u5173\u8054\u591a\u4e2a\u4e1a\u52a1\u8ba1\u5212\u8868\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u5f55\u5165", (String)"ExcelHelper_apply_09", (String)"epm-eb-common", (Object[])new Object[0]);
        HashMap<String, String> businessPlanCell = new HashMap<String, String>(16);
        businessPlanCell.put("colIndex", "1");
        businessPlanCell.put("rowIndex", "2");
        businessPlanCell.put("value", businessPlanNum);
        businessPlanCell.put("tips", businessPlanCellTip);
        headers.add(businessPlanCell);
        int i = 2;
        for (Map.Entry entry : dimensionMap.entrySet()) {
            StringBuilder numberPrefix = new StringBuilder(ResManager.loadKDString((String)"*\u6210\u5458\u7f16\u7801", (String)"ExcelHelper_apply_02", (String)"epm-eb-common", (Object[])new Object[0]));
            StringBuilder numberPreTips = new StringBuilder(ResManager.loadKDString((String)"\u5173\u8054\u591a\u4e2a\u7ef4\u5ea6\u6210\u5458\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u5f55\u5165", (String)"ExcelHelper_apply_10", (String)"epm-eb-common", (Object[])new Object[0]));
            StringBuilder namePrefix = new StringBuilder(ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"ExcelHelper_apply_03", (String)"epm-eb-common", (Object[])new Object[0]));
            DynamicObject value = (DynamicObject)entry.getValue();
            String number = value.getString("number");
            Long id = value.getLong("id");
            String headerNumber = numberPrefix.append("(").append(number).append(")").toString();
            HashMap<String, String> numberCell = new HashMap<String, String>(16);
            numberCell.put("colIndex", i + "");
            numberCell.put("rowIndex", "2");
            numberCell.put("number", number);
            numberCell.put("id", id + "");
            numberCell.put("value", headerNumber);
            numberCell.put("tips", numberPreTips.toString());
            HashMap<String, String> hashMap = new HashMap<String, String>(16);
            hashMap.put("colIndex", "0");
            hashMap.put("rowIndex", "1");
            hashMap.put("value", mustInHeaderTip);
            String name = value.getString("name");
            String headerName = namePrefix.append("(").append(name).append(")").toString();
            HashMap<String, String> nameCell = new HashMap<String, String>(16);
            nameCell.put("colIndex", ++i + "");
            nameCell.put("rowIndex", "2");
            nameCell.put("value", headerName);
            headers.add(numberCell);
            headers.add(nameCell);
            headers.add(hashMap);
            ++i;
        }
        String status = ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ExcelHelper_apply_04", (String)"epm-eb-common", (Object[])new Object[0]);
        HashMap<String, String> statusCell = new HashMap<String, String>(16);
        statusCell.put("colIndex", i + "");
        statusCell.put("rowIndex", "2");
        statusCell.put("value", status);
        headers.add(statusCell);
        DimRangeImportTemplate dimRangeImportTemplate = new DimRangeImportTemplate();
        dimRangeImportTemplate.setFileName(ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u8ba1\u5212\u6a21\u677f", (String)"ExcelHelper_apply_05", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate.setSheetName("sheet1");
        dimRangeImportTemplate.setTitle(ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u8ba1\u5212\u8303\u56f4\u6a21\u677f", (String)"ExcelHelper_apply_06", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate.setHeaderMapList(headers);
        dimRangeImportTemplate.setMaxCol(i);
        ArrayList<Map<String, String>> relations = new ArrayList<Map<String, String>>(16);
        HashMap<String, String> mainBudgetCell1 = new HashMap<String, String>(16);
        mainBudgetCell1.put("colIndex", "0");
        mainBudgetCell1.put("rowIndex", "1");
        mainBudgetCell1.put("value", ResManager.loadKDString((String)"\u4e3b\u8868\u9884\u7b97\u4fe1\u606f", (String)"ExcelHelper_apply_15", (String)"epm-eb-common", (Object[])new Object[0]));
        relations.add(mainBudgetCell1);
        HashMap<String, String> businessPlanCell1 = new HashMap<String, String>(16);
        businessPlanCell1.put("colIndex", "1");
        businessPlanCell1.put("rowIndex", "1");
        businessPlanCell1.put("value", ResManager.loadKDString((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u7f16\u7801", (String)"ExcelHelper_apply_13", (String)"epm-eb-common", (Object[])new Object[0]));
        relations.add(businessPlanCell1);
        StringBuilder bizplanName = new StringBuilder(ResManager.loadKDString((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u540d\u79f0", (String)"ExcelHelper_apply_12", (String)"epm-eb-common", (Object[])new Object[0]));
        HashMap<String, String> numberCell = new HashMap<String, String>(16);
        numberCell.put("colIndex", "2");
        numberCell.put("rowIndex", "1");
        numberCell.put("value", bizplanName.toString());
        relations.add(numberCell);
        int rowNum = 2;
        for (Map.Entry entry : relationshipCorrespondence.entrySet()) {
            List innerList = (List)entry.getValue();
            for (BizTableConfig bizTableConfig : innerList) {
                HashMap<String, String> mainBudgetInfoCell = new HashMap<String, String>(16);
                mainBudgetInfoCell.put("colIndex", "0");
                mainBudgetInfoCell.put("rowIndex", rowNum + "");
                mainBudgetInfoCell.put("value", hcolumnkeyMap.get(entry.getKey()) + "[" + (String)entry.getKey() + "]");
                String tabNumber = bizTableConfig.getTabNumber();
                String tabName = bizTableConfig.getTabName();
                HashMap<String, String> bizPlanNumberCell = new HashMap<String, String>(16);
                bizPlanNumberCell.put("colIndex", "1");
                bizPlanNumberCell.put("rowIndex", rowNum + "");
                bizPlanNumberCell.put("value", tabNumber);
                HashMap<String, String> bizPlanNameCell = new HashMap<String, String>(16);
                bizPlanNameCell.put("colIndex", "2");
                bizPlanNameCell.put("rowIndex", rowNum + "");
                bizPlanNameCell.put("value", tabName);
                relations.add(mainBudgetInfoCell);
                relations.add(bizPlanNumberCell);
                relations.add(bizPlanNameCell);
                ++rowNum;
            }
        }
        DimRangeImportTemplate dimRangeImportTemplate1 = new DimRangeImportTemplate();
        dimRangeImportTemplate1.setFileName(ResManager.loadKDString((String)"\u5173\u7cfb\u5bf9\u5e94\u8868", (String)"ExcelHelper_apply_11", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate1.setSheetName("sheet2");
        dimRangeImportTemplate1.setMaxCol(i);
        dimRangeImportTemplate1.setHeaderMapList(relations);
        dimRangeImportTemplate1.setTitle(ResManager.loadKDString((String)"\u5173\u7cfb\u5bf9\u5e94\u8868", (String)"ExcelHelper_apply_11", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate.setRelationshipSheet(dimRangeImportTemplate1);
        return dimRangeImportTemplate;
    }

    public static DimRangeImportTemplate createImportTemplate(List<ApplyTemplateDimCfgEntity> dimCfgList) {
        ArrayList<Long> dimIds = new ArrayList<Long>(16);
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
            String useType = applyTemplateDimCfgEntity.getUsetype();
            if (!StringUtils.equals(useType, DimUseTypeEnum.BUSINESS_PLAN.getValue())) continue;
            dimIds.add(applyTemplateDimCfgEntity.getDimid());
        }
        Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])dimIds.toArray(), (String)"epm_dimension");
        ArrayList<Map<String, String>> headers = new ArrayList<Map<String, String>>(16);
        String mustInHeaderTip = ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"ExcelHelper_apply_01", (String)"epm-eb-common", (Object[])new Object[0]);
        StringBuilder mainBudgetInfo = new StringBuilder(ResManager.loadKDString((String)"*\u4e3b\u8868\u9884\u7b97\u4fe1\u606f", (String)"ExcelHelper_apply_07", (String)"epm-eb-common", (Object[])new Object[0]));
        HashMap<String, String> mainBudgetCell = new HashMap<String, String>(16);
        mainBudgetCell.put("colIndex", "0");
        mainBudgetCell.put("rowIndex", "2");
        mainBudgetCell.put("value", mainBudgetInfo.toString());
        headers.add(mainBudgetCell);
        StringBuilder businessPlanNum = new StringBuilder(ResManager.loadKDString((String)"*\u4e1a\u52a1\u8ba1\u5212\u8868\u7f16\u7801", (String)"ExcelHelper_apply_14", (String)"epm-eb-common", (Object[])new Object[0]));
        HashMap<String, String> businessPlanCell = new HashMap<String, String>(16);
        businessPlanCell.put("colIndex", "1");
        businessPlanCell.put("rowIndex", "2");
        businessPlanCell.put("value", businessPlanNum.toString());
        headers.add(businessPlanCell);
        int i = 2;
        for (Map.Entry entry : dimensionMap.entrySet()) {
            StringBuilder numberPrefix = new StringBuilder(ResManager.loadKDString((String)"*\u6210\u5458\u7f16\u7801", (String)"ExcelHelper_apply_02", (String)"epm-eb-common", (Object[])new Object[0]));
            StringBuilder namePrefix = new StringBuilder(ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"ExcelHelper_apply_03", (String)"epm-eb-common", (Object[])new Object[0]));
            DynamicObject value = (DynamicObject)entry.getValue();
            String number = value.getString("number");
            Long id = value.getLong("id");
            String headerNumber = numberPrefix.append("(").append(number).append(")").toString();
            HashMap<String, String> numberCell = new HashMap<String, String>(16);
            numberCell.put("colIndex", i + "");
            numberCell.put("rowIndex", "2");
            numberCell.put("number", number);
            numberCell.put("id", id + "");
            numberCell.put("value", headerNumber);
            HashMap<String, String> tipCell = new HashMap<String, String>(16);
            tipCell.put("colIndex", "0");
            tipCell.put("rowIndex", "1");
            tipCell.put("value", mustInHeaderTip);
            String name = value.getString("name");
            String headerName = namePrefix.append("(").append(name).append(")").toString();
            HashMap<String, String> nameCell = new HashMap<String, String>(16);
            nameCell.put("colIndex", ++i + "");
            nameCell.put("rowIndex", "2");
            nameCell.put("value", headerName);
            headers.add(numberCell);
            headers.add(nameCell);
            headers.add(tipCell);
            ++i;
        }
        String status = ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ExcelHelper_apply_04", (String)"epm-eb-common", (Object[])new Object[0]);
        HashMap<String, String> statusCell = new HashMap<String, String>(16);
        statusCell.put("colIndex", i + "");
        statusCell.put("rowIndex", "2");
        statusCell.put("value", status);
        headers.add(statusCell);
        DimRangeImportTemplate dimRangeImportTemplate = new DimRangeImportTemplate();
        dimRangeImportTemplate.setFileName(ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u8ba1\u5212\u6a21\u677f", (String)"ExcelHelper_apply_05", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate.setSheetName("sheet1");
        dimRangeImportTemplate.setTitle(ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u8ba1\u5212\u8303\u56f4\u6a21\u677f", (String)"ExcelHelper_apply_06", (String)"epm-eb-common", (Object[])new Object[0]));
        dimRangeImportTemplate.setHeaderMapList(headers);
        dimRangeImportTemplate.setMaxCol(i);
        return dimRangeImportTemplate;
    }

    public static XSSFWorkbook createExportXssfWork(DimRangeImportTemplate importTemplate) {
        XSSFWorkbook xssfWorkBook = ExcelHelper.createXssfWorkBook();
        XSSFSheet xssfSheet = ExcelHelper.createXssfSheet(xssfWorkBook);
        xssfSheet.setDefaultColumnWidth(40);
        xssfWorkBook.setSheetName(0, importTemplate.getSheetName());
        CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, importTemplate.getMaxCol());
        xssfSheet.addMergedRegion(cellAddresses);
        XSSFCellStyle centerStyle = xssfWorkBook.createCellStyle();
        centerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font1 = xssfWorkBook.createFont();
        font1.setFontHeightInPoints((short)20);
        centerStyle.setFont((Font)font1);
        for (int i = 0; i < importTemplate.getMaxCol(); ++i) {
            XSSFCell xssfCell = ExcelHelper.createXssfCell(ExcelHelper.createXssfRow(xssfSheet, 0), i);
            xssfCell.setCellStyle((CellStyle)centerStyle);
        }
        ExcelHelper.setCellValue(xssfSheet, null, 0, 0, importTemplate.getTitle(), null);
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(2, 2000, importTemplate.getMaxCol(), importTemplate.getMaxCol());
        StatusEnum[] values = StatusEnum.values();
        String[] desc = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            desc[i] = values[i].getDesc();
        }
        DataValidationHelper dataValidationHelper = xssfSheet.getDataValidationHelper();
        DataValidationConstraint constraint = dataValidationHelper.createExplicitListConstraint(desc);
        DataValidation validation = dataValidationHelper.createValidation(constraint, cellRangeAddressList);
        xssfSheet.addValidationData(validation);
        List<Map<String, String>> headerMapList = importTemplate.getHeaderMapList();
        if (CollectionUtils.isNotEmpty(headerMapList)) {
            for (Map<String, String> map : headerMapList) {
                String rowIndexStr = map.get("rowIndex");
                String colIndexStr = map.get("colIndex");
                String value = map.get("value");
                int rowIndex = Integer.parseInt(rowIndexStr);
                int colIndex = Integer.parseInt(colIndexStr);
                XSSFCellStyle cellStyle = ExcelHelper.createCellStyle(xssfWorkBook);
                if (rowIndex == 1 || colIndex % 2 == 0 || colIndex <= 1) {
                    XSSFFont font = xssfWorkBook.createFont();
                    font.setColor(IndexedColors.RED.index);
                    cellStyle.setFont((Font)font);
                }
                if (rowIndex == 2) {
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                ExcelHelper.setCellValue(xssfSheet, cellStyle, rowIndex, colIndex, value, null);
            }
        }
        DimRangeImportTemplate relationshipSheet = importTemplate.getRelationshipSheet();
        XSSFSheet relationshipxssfSheet = ExcelHelper.createXssfSheet(xssfWorkBook);
        relationshipxssfSheet.setDefaultColumnWidth(40);
        xssfWorkBook.setSheetName(1, relationshipSheet.getSheetName());
        CellRangeAddress relationShipCellAddresses = new CellRangeAddress(0, 0, 0, 2);
        relationshipxssfSheet.addMergedRegion(relationShipCellAddresses);
        XSSFCellStyle relationShipCenterStyle = xssfWorkBook.createCellStyle();
        relationShipCenterStyle.setAlignment(HorizontalAlignment.CENTER);
        relationShipCenterStyle.setFont((Font)font1);
        for (int i = 0; i < importTemplate.getMaxCol(); ++i) {
            XSSFCell xssfCell = ExcelHelper.createXssfCell(ExcelHelper.createXssfRow(relationshipxssfSheet, 0), i);
            xssfCell.setCellStyle((CellStyle)relationShipCenterStyle);
        }
        ExcelHelper.setCellValue(relationshipxssfSheet, null, 0, 0, relationshipSheet.getTitle(), null);
        xssfSheet.addValidationData(validation);
        List<Map<String, String>> valueMapList = relationshipSheet.getHeaderMapList();
        if (CollectionUtils.isNotEmpty(valueMapList)) {
            for (Map<String, String> map : valueMapList) {
                String rowIndexStr = map.get("rowIndex");
                String colIndexStr = map.get("colIndex");
                String value = map.get("value");
                int rowIndex = Integer.parseInt(rowIndexStr);
                int colIndex = Integer.parseInt(colIndexStr);
                XSSFCellStyle cellStyle = ExcelHelper.createCellStyle(xssfWorkBook);
                if (rowIndex == 1) {
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                ExcelHelper.setCellValue(relationshipxssfSheet, cellStyle, rowIndex, colIndex, value, null);
            }
        }
        return xssfWorkBook;
    }

    public static XSSFWorkbook createExportXssfWorkNew(DimRangeImportTemplate importTemplate, HashMap<String, String> hcolumnkeyMap) {
        XSSFWorkbook xssfWorkBook = ExcelHelper.createXssfWorkBook();
        XSSFSheet xssfSheet = ExcelHelper.createXssfSheet(xssfWorkBook);
        xssfSheet.setDefaultColumnWidth(40);
        xssfWorkBook.setSheetName(0, importTemplate.getSheetName());
        CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, importTemplate.getMaxCol());
        xssfSheet.addMergedRegion(cellAddresses);
        XSSFCellStyle centerStyle = xssfWorkBook.createCellStyle();
        centerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font1 = xssfWorkBook.createFont();
        font1.setFontHeightInPoints((short)20);
        centerStyle.setFont((Font)font1);
        for (int i = 0; i < importTemplate.getMaxCol(); ++i) {
            XSSFCell xssfCell = ExcelHelper.createXssfCell(ExcelHelper.createXssfRow(xssfSheet, 0), i);
            xssfCell.setCellStyle((CellStyle)centerStyle);
        }
        ExcelHelper.setCellValue(xssfSheet, null, 0, 0, importTemplate.getTitle(), null);
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(2, 2000, importTemplate.getMaxCol(), importTemplate.getMaxCol());
        StatusEnum[] values = StatusEnum.values();
        String[] desc = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            desc[i] = values[i].getDesc();
        }
        DataValidationHelper dataValidationHelper = xssfSheet.getDataValidationHelper();
        DataValidationConstraint constraint = dataValidationHelper.createExplicitListConstraint(desc);
        DataValidation validation = dataValidationHelper.createValidation(constraint, cellRangeAddressList);
        CellRangeAddressList cellMainBudgetInfoList = new CellRangeAddressList(2, 2000, 0, 0);
        if (hcolumnkeyMap.size() > 0) {
            String[] desc1 = new String[hcolumnkeyMap.size()];
            int size = 0;
            for (Map.Entry<String, String> entry : hcolumnkeyMap.entrySet()) {
                desc1[size] = entry.getValue() + "[" + entry.getKey() + "]";
                ++size;
            }
            DataValidationConstraint cellMainBudgetInfoConstraint = dataValidationHelper.createExplicitListConstraint(desc1);
            DataValidation cellMainBudgetInfoValidation = dataValidationHelper.createValidation(cellMainBudgetInfoConstraint, cellMainBudgetInfoList);
            xssfSheet.addValidationData(cellMainBudgetInfoValidation);
        }
        xssfSheet.addValidationData(validation);
        List<Map<String, String>> headerMapList = importTemplate.getHeaderMapList();
        if (CollectionUtils.isNotEmpty(headerMapList)) {
            for (Map<String, String> map : headerMapList) {
                String rowIndexStr = map.get("rowIndex");
                String colIndexStr = map.get("colIndex");
                String value = map.get("value");
                String tips = map.get("tips");
                int rowIndex = Integer.parseInt(rowIndexStr);
                int colIndex = Integer.parseInt(colIndexStr);
                XSSFCellStyle cellStyle = ExcelHelper.createCellStyle(xssfWorkBook);
                if (rowIndex == 1 || colIndex % 2 == 0 || colIndex <= 1) {
                    XSSFFont font = xssfWorkBook.createFont();
                    font.setColor(IndexedColors.RED.index);
                    cellStyle.setFont((Font)font);
                }
                if (rowIndex == 2) {
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                Comment comment = null;
                if (StringUtils.isNotEmpty(tips)) {
                    XSSFCreationHelper creationHelper = xssfWorkBook.getCreationHelper();
                    XSSFDrawing drawing = xssfSheet.createDrawingPatriarch();
                    ClientAnchor anchor = creationHelper.createClientAnchor();
                    anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                    comment = drawing.createCellComment(anchor);
                    RichTextString commentText = creationHelper.createRichTextString(tips);
                    comment.setString(commentText);
                }
                ExcelHelper.setCellValue(xssfSheet, cellStyle, rowIndex, colIndex, value, comment);
            }
        }
        DimRangeImportTemplate relationshipSheet = importTemplate.getRelationshipSheet();
        XSSFSheet relationshipxssfSheet = ExcelHelper.createXssfSheet(xssfWorkBook);
        relationshipxssfSheet.setDefaultColumnWidth(40);
        xssfWorkBook.setSheetName(1, relationshipSheet.getSheetName());
        CellRangeAddress relationShipCellAddresses = new CellRangeAddress(0, 0, 0, 2);
        relationshipxssfSheet.addMergedRegion(relationShipCellAddresses);
        XSSFCellStyle relationShipCenterStyle = xssfWorkBook.createCellStyle();
        relationShipCenterStyle.setAlignment(HorizontalAlignment.CENTER);
        relationShipCenterStyle.setFont((Font)font1);
        for (int i = 0; i < importTemplate.getMaxCol(); ++i) {
            XSSFCell xssfCell = ExcelHelper.createXssfCell(ExcelHelper.createXssfRow(relationshipxssfSheet, 0), i);
            xssfCell.setCellStyle((CellStyle)relationShipCenterStyle);
        }
        ExcelHelper.setCellValue(relationshipxssfSheet, null, 0, 0, relationshipSheet.getTitle(), null);
        List<Map<String, String>> valueMapList = relationshipSheet.getHeaderMapList();
        if (CollectionUtils.isNotEmpty(valueMapList)) {
            for (Map<String, String> map : valueMapList) {
                String rowIndexStr = map.get("rowIndex");
                String colIndexStr = map.get("colIndex");
                String value = map.get("value");
                int rowIndex = Integer.parseInt(rowIndexStr);
                int colIndex = Integer.parseInt(colIndexStr);
                XSSFCellStyle cellStyle = ExcelHelper.createCellStyle(xssfWorkBook);
                if (rowIndex == 1) {
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                ExcelHelper.setCellValue(relationshipxssfSheet, cellStyle, rowIndex, colIndex, value, null);
            }
        }
        return xssfWorkBook;
    }

    public static void downloadExcel(XSSFWorkbook xssfWorkBook, String fileName, IFormView formView) throws IOException {
        String url = ExcelHelper.writeFile(xssfWorkBook, fileName);
        if (StringUtils.isNotEmpty(url)) {
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }
}

