/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applyTemplate.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.epm.eb.common.applyTemplate.entity.dto.TableColumn;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TableHelper {
    private TableHelper() {
    }

    public static String createTable(List<TableColumn> tableColumnList) {
        if (CollectionUtils.isEmpty(tableColumnList)) {
            return "";
        }
        String tableNamePrefix = "t_eb_dimrange";
        String tableNameSuffix = Uuid8.generateShortUuid().toLowerCase();
        String tableName = tableNamePrefix + tableNameSuffix;
        DBRoute dbRoute = new DBRoute("epm");
        StringBuilder str = new StringBuilder();
        str.append("create table ").append(tableName);
        str.append('(');
        str.append("fid bigint default 0 not null, ");
        for (TableColumn tableColumn : tableColumnList) {
            str.append(tableColumn.getKey()).append(" ").append(tableColumn.getType()).append(", ");
        }
        str.append("constraint eb_dimrange").append(tableNameSuffix).append("pk primary key (fid)");
        str.append(')');
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            DB.execute((DBRoute)dbRoute, (String)("drop table " + tableName));
        }
        DB.execute((DBRoute)dbRoute, (String)str.toString());
        return tableName;
    }

    public static void alterTable(String tableName, List<TableColumn> tableColumnList) {
    }

    public static void dropTable(String tableName) {
        if (StringUtils.isEmpty(tableName)) {
            return;
        }
        DBRoute dbRoute = new DBRoute("epm");
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            DB.execute((DBRoute)dbRoute, (String)("drop table " + tableName));
        }
    }

    public static void dropTables(Set<String> tableNames) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return;
        }
        DBRoute dbRoute = new DBRoute("epm");
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (String tableName : tableNames) {
            Object[] objects = new Object[1];
            if (!TableHelper.exitsTable(dbRoute, tableName)) continue;
            objects[0] = tableName;
            params.add(objects);
        }
        DB.executeBatch((DBRoute)dbRoute, (String)"drop table ?", params);
    }

    private static boolean exitsTable(DBRoute dbRoute, String tableName) {
        return DB.exitsTable((DBRoute)dbRoute, (String)tableName);
    }

    private static void addColumn(String tableName, List<TableColumn> tableColumnList) {
    }

    private static void delColumn(String tableName, List<TableColumn> tableColumnList) {
    }
}

