/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applybill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.applybill.EntityCellBaseData;

public class ApplyBillEntityData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> rowIds = new LinkedList<Long>();
    private Map<String, List<EntityCellBaseData>> basedata = new HashMap<String, List<EntityCellBaseData>>();
    private Map<String, List<Object>> otherData = new HashMap<String, List<Object>>();
    private List<Boolean> rowChanged = new LinkedList<Boolean>();

    public void registBaseData(String ... keys) {
    }

    public void setRowChanged(int rowIndex, boolean changed) {
        if (rowIndex < this.rowChanged.size()) {
            this.rowChanged.set(rowIndex, changed);
        }
    }

    public List<Long> getRowIds() {
        return this.rowIds;
    }

    public void addCellBaseData(int rowIndex, String baseDataKey, EntityCellBaseData cellData) {
        List vals = this.basedata.computeIfAbsent(baseDataKey, key -> new ArrayList(16));
        vals.add(rowIndex, cellData);
    }

    public void addCellOtherData(int rowIndex, String columnKey, Object cellData) {
        List vals = this.otherData.computeIfAbsent(columnKey, key -> new ArrayList(16));
        vals.add(rowIndex, cellData);
    }

    public void addRowId(int rowIndex, Long rowId) {
        if (rowIndex <= this.rowIds.size()) {
            this.rowIds.add(rowIndex, rowId);
        }
    }

    public int getRowIndexByRowId(Long rowId) {
        return this.rowIds.indexOf(rowId);
    }

    public EntityCellBaseData getCellBaseData(int rowIndex, String baseDataKey) {
        List<EntityCellBaseData> entityCellBaseData = this.basedata.get(baseDataKey);
        if (entityCellBaseData != null && rowIndex < entityCellBaseData.size() && rowIndex > -1) {
            return entityCellBaseData.get(rowIndex);
        }
        return null;
    }

    public Object getCellOtherData(int rowIndex, String key) {
        List<Object> objects = this.otherData.get(key);
        if (objects != null && rowIndex < objects.size() && rowIndex > -1) {
            return objects.get(rowIndex);
        }
        return null;
    }

    public Set<String> getBaseDataKeys() {
        return this.basedata.keySet();
    }

    public Set<String> getOtherDataKeys() {
        return this.otherData.keySet();
    }

    public List<EntityCellBaseData> getListDataOfColumn(String baseDataKey) {
        return this.basedata.get(baseDataKey);
    }

    public List<Object> getOtherDataOfColumn(String key) {
        return this.otherData.get(key);
    }

    public Long getRowIbByIndex(int index) {
        if (index < this.rowIds.size()) {
            return this.rowIds.get(index);
        }
        return null;
    }

    public List<Boolean> getRowChanged() {
        return this.rowChanged;
    }

    public void removeRowDataByRowIds(Set<Long> deledRowIds) {
        int index = 0;
        Iterator<Long> rowIdsIterator = this.getRowIds().iterator();
        while (rowIdsIterator.hasNext()) {
            Long rowId = rowIdsIterator.next();
            if (deledRowIds.contains(rowId)) {
                this.removeRow(index, false);
                rowIdsIterator.remove();
                continue;
            }
            ++index;
        }
    }

    public void removeRow(int index, boolean includeId) {
        for (String key : this.getOtherDataKeys()) {
            List<Object> otherDataOfColumn = this.getOtherDataOfColumn(key);
            otherDataOfColumn.remove(index);
        }
        for (String key : this.getBaseDataKeys()) {
            List<EntityCellBaseData> cellBaseDataList = this.getListDataOfColumn(key);
            cellBaseDataList.remove(index);
        }
        this.getRowChanged().remove(index);
        if (includeId) {
            this.getRowIds().remove(index);
        }
    }
}

