/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applybill;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum ApplyBillType {
    APPLY(ApplyBillType.getApply(), "apply"),
    COLLECY(ApplyBillType.getCollect(), "collect"),
    COLLECYVIEW(ApplyBillType.getCollectView(), "collectview"),
    APPLYAUDIT(ApplyBillType.getApplyAudit(), "applyaudit"),
    COLLECYAUDIT(ApplyBillType.getCollecyAudit(), "collecyaudit"),
    APPLYSTATISTICS(ApplyBillType.getAPPLYSTATISTICS(), "applystatistics"),
    AUDITSTATISTICS(ApplyBillType.getAUDITSTATISTICS(), "auditstatistics"),
    COLLECTSTATISTICS(ApplyBillType.getCOLLECTSTATISTICS(), "collectstatistics"),
    COLLECTVIEWSTATISTICS(ApplyBillType.getCOLLECTSTATISTICS(), "collectviewstatistics"),
    COLLECTAUDITSTATISTICS(ApplyBillType.getCOLLECTAUDITSTATISTICS(), "collectauditstatistics"),
    SPLIT(ApplyBillType.getSPLIT(), "split"),
    SPLITDETAIL(ApplyBillType.getSPLITDETAIL(), "splitdetail"),
    REJECT(ApplyBillType.getREJECT(), "reject"),
    APPLYREJECT(ApplyBillType.getAPPLYREJECT(), "applyreject"),
    COLLECTREJECT(ApplyBillType.getCOLLECTREJECT(), "collectreject"),
    OLDAPPLY(ApplyBillType.getApply(), "oldapply"),
    OLDCOLLECY(ApplyBillType.getCollect(), "oldcollecy"),
    OLDAPPLYAUDIT(ApplyBillType.getApplyAudit(), "oldapplyaudit"),
    OLDCOLLECYAUDIT(ApplyBillType.getCollecyAudit(), "oldcollecyaudit"),
    OLDSPLIT(ApplyBillType.getSPLIT(), "oldsplit"),
    AUDIT(ApplyBillType.getAUDIT(), "audit");

    private MultiLangEnumBridge name;
    private String number;

    private ApplyBillType(MultiLangEnumBridge name, String number) {
        this.name = name;
        this.number = number;
    }

    private static MultiLangEnumBridge getApply() {
        return new MultiLangEnumBridge("\u7533\u62a5\u5355", "ApplyBillType_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCollect() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5355", "ApplyBillType_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCollectView() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5355\u7533\u62a5\u67e5\u8be2", "ApplyBillType_11", "epm-eb-common");
    }

    private static MultiLangEnumBridge getApplyAudit() {
        return new MultiLangEnumBridge("\u7533\u62a5\u5ba1\u6279\u5355", "ApplyBillType_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCollecyAudit() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5ba1\u6279\u5355", "ApplyBillType_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getAPPLYSTATISTICS() {
        return new MultiLangEnumBridge("\u7533\u62a5\u5206\u9879\u7edf\u8ba1\u5355", "ApplyBillType_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getAUDITSTATISTICS() {
        return new MultiLangEnumBridge("\u7533\u62a5\u5ba1\u6279\u5206\u9879\u7edf\u8ba1\u5355", "ApplyBillType_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCOLLECTSTATISTICS() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5206\u9879\u7edf\u8ba1\u5355", "ApplyBillType_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCOLLECTAUDITSTATISTICS() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5ba1\u6279\u5206\u9879\u7edf\u8ba1\u5355", "ApplyBillType_10", "epm-eb-common");
    }

    private static MultiLangEnumBridge getSPLIT() {
        return new MultiLangEnumBridge("\u5206\u89e3\u5355", "ApplyBillType_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getSPLITDETAIL() {
        return new MultiLangEnumBridge("\u5206\u89e3\u660e\u7ec6\u5355", "ApplyBillType_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getAPPLYREJECT() {
        return new MultiLangEnumBridge("\u7533\u62a5\u5ba1\u6279\u9a73\u56de\u8c03\u6574\u5355", "ApplyBillType_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCOLLECTREJECT() {
        return new MultiLangEnumBridge("\u6c47\u603b\u5ba1\u6279\u9a73\u56de\u8c03\u6574\u5355", "ApplyBillType_12", "epm-eb-common");
    }

    private static MultiLangEnumBridge getREJECT() {
        return new MultiLangEnumBridge("\u9a73\u56de\u8c03\u6574\u5355", "ApplyBillType_13", "epm-eb-common");
    }

    private static MultiLangEnumBridge getAUDIT() {
        return new MultiLangEnumBridge("\u5ba1\u6279\u5355", "", "epm-eb-common");
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public static boolean isApplyBill(String billType) {
        return billType != null && billType.equals(APPLY.getNumber());
    }

    public static ApplyBillType getBillTypeByNumber(String billTypeNumber) {
        for (ApplyBillType billType : ApplyBillType.values()) {
            if (!billType.getNumber().equals(billTypeNumber)) continue;
            return billType;
        }
        return APPLY;
    }

    public String getBillPlugin() {
        String result = null;
        switch (this) {
            case APPLY: {
                result = "kd.epm.eb.formplugin.applybill.BgApplyBillPluginNew";
                break;
            }
            case OLDAPPLY: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldApplyBillPlugin";
                break;
            }
            case APPLYAUDIT: {
                result = "kd.epm.eb.formplugin.applybill.BgApplyAuditBillPlugin";
                break;
            }
            case OLDAPPLYAUDIT: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldApplyAuditBillPlugin";
                break;
            }
            case COLLECY: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectBillPlugin";
                break;
            }
            case OLDCOLLECY: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldCollectBillPlugin";
                break;
            }
            case COLLECYVIEW: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectBillViewPlugin";
                break;
            }
            case COLLECYAUDIT: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectAuditBillPlugin";
                break;
            }
            case OLDCOLLECYAUDIT: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldCollectAuditBillPlugin";
                break;
            }
            case APPLYSTATISTICS: {
                result = "kd.epm.eb.formplugin.applybill.BgApplyStatisticsBillPlugin";
                break;
            }
            case AUDITSTATISTICS: {
                result = "kd.epm.eb.formplugin.applybill.BgAuditStatisticsBillPlugin";
                break;
            }
            case APPLYREJECT: {
                result = "kd.epm.eb.formplugin.applybill.BgApplyRejectBillPlugin";
                break;
            }
            case REJECT: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldBgApplyRejectBillPlugin";
                break;
            }
            case COLLECTREJECT: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectRejectBillPlugin";
                break;
            }
            case SPLIT: {
                result = "kd.epm.eb.formplugin.applybill.BgApplySplitBillPlugin";
                break;
            }
            case OLDSPLIT: {
                result = "kd.epm.eb.formplugin.applybill.olddata.OldSplitBillPlugin";
                break;
            }
            case COLLECTSTATISTICS: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectStatsBillPlugin";
                break;
            }
            case COLLECTVIEWSTATISTICS: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectViewStatsBillPlugin";
                break;
            }
            case COLLECTAUDITSTATISTICS: {
                result = "kd.epm.eb.formplugin.applybill.BgCollectAuditStatsBillPlugin";
                break;
            }
            default: {
                result = "kd.epm.eb.formplugin.applybill.BgApplyBillBasePlugin";
            }
        }
        return result;
    }
}

