/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applybill;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.applybill.DecpStepData;

public class DecpStepManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, DecpStepData> allStepData = new HashMap<String, DecpStepData>();
    private List<String> stepKeys = new LinkedList<String>();

    public void setAllStepData(Map<String, DecpStepData> allStepData) {
        this.allStepData = allStepData;
    }

    public Map<String, DecpStepData> getAllStepData() {
        return this.allStepData;
    }

    public List<String> getStepKeys() {
        return this.stepKeys;
    }

    public void setStepKeys(List<String> stepKeys) {
        this.stepKeys = stepKeys;
    }

    public DecpStepData getStepDataByNumber(String stepNumber) {
        return this.allStepData.get(stepNumber);
    }

    public DecpStepData getStepDataByIndex(int index) {
        String stepNum;
        if (index < this.stepKeys.size() && (stepNum = this.stepKeys.get(index)) != null) {
            return this.allStepData.get(stepNum);
        }
        return null;
    }

    public void addStepData(DecpStepData stepData) {
        this.stepKeys.add(stepData.getNumber());
        this.allStepData.put(stepData.getNumber(), stepData);
    }

    public void delStepData(String stepNumber) {
        this.stepKeys.remove(stepNumber);
        this.allStepData.remove(stepNumber);
    }

    public void cleaAllData() {
        this.stepKeys.clear();
        this.allStepData.clear();
    }

    @JsonIgnore
    public List<DecpStepData> getStepDataList() {
        ArrayList<DecpStepData> allData = new ArrayList<DecpStepData>(10);
        for (String key : this.stepKeys) {
            allData.add(this.allStepData.get(key));
        }
        return allData;
    }

    public int size() {
        return this.stepKeys.size();
    }

    public int getStepIndex(String stepNumber) {
        return this.stepKeys.indexOf(stepNumber);
    }
}

