/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applybill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;

public class DetailMembBillData
implements Serializable {
    private Map<String, RowDataStatus> detailRowStatus = new HashMap<String, RowDataStatus>();
    private transient Map<Long, RowDataStatus> sourceDataRowStatus = new HashMap<Long, RowDataStatus>();
    private List<Object[]> allRowData = new ArrayList<Object[]>();
    private transient EntryTemplateConfig templateConfig;

    public List<Object[]> getAllRowData() {
        return this.allRowData;
    }

    public Map<String, RowDataStatus> getDetailRowStatus() {
        return this.detailRowStatus;
    }

    public Map<Long, RowDataStatus> getSourceDataRowStatus() {
        return this.sourceDataRowStatus;
    }

    public void initRowStatusByRowId() {
        if (this.sourceDataRowStatus == null) {
            this.sourceDataRowStatus = new HashMap<Long, RowDataStatus>();
        } else {
            this.sourceDataRowStatus.clear();
        }
        for (Map.Entry<String, RowDataStatus> rowDataEntry : this.detailRowStatus.entrySet()) {
            RowDataStatus rowDataStatus = rowDataEntry.getValue();
            Object[] rowData = this.allRowData.get(rowDataStatus.getRowIndex());
            if (rowData == null) continue;
            this.sourceDataRowStatus.put((Long)rowData[0], rowDataStatus);
        }
    }

    public EntryTemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    public void setTemplateConfig(EntryTemplateConfig templateConfig) {
        this.templateConfig = templateConfig;
    }

    public void iteratorMembersOnRow(IModelCacheHelper modelCacheHelper, String dimColKey, Consumer<Member> memberConsumer) {
        String dimNum = this.templateConfig.selectColumnMapDimNum().get(dimColKey);
        Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(this.templateConfig.getDatasetId(), dimNum);
        int rowDimIndex = this.templateConfig.getColumnIndex().get(dimColKey);
        for (Object[] rowData : this.allRowData) {
            Long membId = (Long)rowData[rowDimIndex];
            Member memberObj = modelCacheHelper.getMember(dimNum, viewId, membId);
            memberConsumer.accept(memberObj);
        }
    }
}

