/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.applybill;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.applybill.SplitedDataInfo;

public class SplitRowData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SplitedDataInfo splitedData;
    private Map<String, BigDecimal> subData;
    private List<String> notDetailDimColumn;
    private String currentSplitDim;
    private String currentFocusSplitDim;
    private boolean finishSplit;
    private Map<String, Map<Long, SplitedDataInfo>> splitedRows;

    public SplitedDataInfo getSplitedData() {
        if (this.splitedData == null) {
            this.splitedData = new SplitedDataInfo();
            this.splitedData.setPastByZero(false);
        }
        return this.splitedData;
    }

    public void setSplitedData(SplitedDataInfo splitedData) {
        this.splitedData = splitedData;
    }

    public String getPreSplitDim(String currentFocusSplitDim) {
        int index;
        String preSplitDim = null;
        if (currentFocusSplitDim == null) {
            currentFocusSplitDim = this.getCurrentFocusSplitDim();
        }
        if (currentFocusSplitDim != null && (index = this.notDetailDimColumn.indexOf(currentFocusSplitDim)) > 0) {
            preSplitDim = this.notDetailDimColumn.get(index - 1);
        }
        return preSplitDim;
    }

    public Map<String, Map<Long, SplitedDataInfo>> getSplitedRows() {
        if (this.splitedRows == null) {
            this.splitedRows = new HashMap<String, Map<Long, SplitedDataInfo>>(16);
        }
        return this.splitedRows;
    }

    public String getNextSplitDim(String currentSplitDim) {
        if (currentSplitDim == null) {
            currentSplitDim = this.getCurrentSplitDim();
        }
        int index = this.notDetailDimColumn.indexOf(currentSplitDim);
        String nextSplitDim = null;
        if (index != -1 && index < this.notDetailDimColumn.size() - 1) {
            nextSplitDim = this.notDetailDimColumn.get(index + 1);
        }
        return nextSplitDim;
    }

    public String getCurrentSplitDim() {
        if (this.currentSplitDim == null && this.notDetailDimColumn.size() > 0) {
            this.currentSplitDim = this.notDetailDimColumn.get(0);
        }
        return this.currentSplitDim;
    }

    public void setCurrentSplitDim(String currentSplitDim) {
        this.currentSplitDim = currentSplitDim;
    }

    public void setSplitedRows(Map<String, Map<Long, SplitedDataInfo>> splitedRows) {
        this.splitedRows = splitedRows;
    }

    public Map<String, BigDecimal> getSubData() {
        return this.subData;
    }

    public void setSubData(Map<String, BigDecimal> subData) {
        this.subData = subData;
    }

    public List<String> getNotDetailDimColumn() {
        return this.notDetailDimColumn;
    }

    public void setNotDetailDimColumn(List<String> notDetailDimColumn) {
        this.notDetailDimColumn = notDetailDimColumn;
    }

    public boolean isFinishSplit() {
        return this.finishSplit;
    }

    public void setFinishSplit(boolean finishSplit) {
        this.finishSplit = finishSplit;
    }

    public Set<Long> selectPreSplitRowIdOnCurrentDim(Long currentSplitRowId) {
        HashSet<Long> preSplitRowIDs;
        String preSplitDim = this.getPreSplitDim(this.getCurrentFocusSplitDim());
        if (preSplitDim == null) {
            preSplitRowIDs = new HashSet<Long>(16);
            preSplitRowIDs.add(currentSplitRowId);
        } else {
            Map<Long, SplitedDataInfo> splitedDataInfoMap = this.getSplitedRows().get(preSplitDim);
            preSplitRowIDs = splitedDataInfoMap.keySet();
        }
        return preSplitRowIDs;
    }

    public String getCurrentFocusSplitDim() {
        if (this.currentFocusSplitDim == null) {
            this.currentFocusSplitDim = this.getCurrentSplitDim();
        }
        return this.currentFocusSplitDim;
    }

    public void setCurrentFocusSplitDim(String currentFocusSplitDim) {
        this.currentFocusSplitDim = currentFocusSplitDim;
    }
}

