/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.approveBill;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDimEB;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfoEB;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.utils.NewEbAppUtil;

public class ApproveBillCommon {
    private static final String CON_LOG = "reportCommit:";
    public static final String CON_FROMREPORT = "fromreport";
    public static final String LOOP_SUBMIT = "loopSubmit";

    public static void log(String logInfo, Log log) {
        log.info(CON_LOG + RequestContext.getOrCreate().getUserName() + logInfo);
    }

    public static Set<Long> getTempIds(Collection<ApproveBillRptTemp> rptTemps) {
        if (rptTemps == null || rptTemps.size() == 0) {
            return null;
        }
        LinkedHashSet<Long> returns = new LinkedHashSet<Long>(rptTemps.size());
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            returns.add(rptTemp.getTempId());
        }
        return returns;
    }

    public static Set<Long> getApproveBillIds(Collection<ApproveBillRptTemp> rptTemps) {
        if (rptTemps == null || rptTemps.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(rptTemps.size());
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            returns.add(rptTemp.getApproveBillId());
        }
        return returns;
    }

    public static Set<Long> getRptIds(Collection<ApproveBillRptTemp> rptTemps, Long temp) {
        if (rptTemps == null || rptTemps.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(rptTemps.size());
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            if (temp.compareTo(rptTemp.getTempId()) != 0) continue;
            returns.add(rptTemp.getRptId());
        }
        return returns;
    }

    public static String getAppId(ApproveBillSubMitInfo rptInfo) {
        Long modelId = rptInfo.getSubmitDims().getModelId();
        if (NewEbAppUtil.isNewEbModel(modelId)) {
            return ApplicationTypeEnum.EB.getAppnum();
        }
        return rptInfo.getRptProcessType() == 3 ? ApplicationTypeEnum.EB.getAppnum() : ApplicationTypeEnum.BGM.getAppnum();
    }

    public static String getFormId(ApproveBillSubMitInfo rptInfo) {
        return rptInfo.getRptProcessType() == 3 ? "bcm_eb_approvebill" : "eb_approvebill";
    }

    public static String getFormId(ApproveBillSubMitDim submitDims) {
        return submitDims instanceof ApproveBillSubMitDimEB ? "bcm_eb_approvebill" : "eb_approvebill";
    }

    public static Member getOrgMember(ApproveBillSubMitInfo rptInfo, IModelCacheHelper helper) {
        if (helper == null) {
            helper = ModelCacheContext.getOrCreate(rptInfo.getSubmitDims().getModelId());
        }
        return helper.getMember(SysDimensionEnum.Entity.getNumber(), ApproveBillCommon.getViewId(rptInfo), rptInfo.getSubmitDims().getOrgId());
    }

    public static List<Member> getOrgParents(ApproveBillSubMitDim submitDims, boolean hasSelf) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(submitDims.getModelId());
        Member cacheMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), submitDims.getViewId(), submitDims.getOrgId());
        return modelCacheHelper.getParents(submitDims.getViewId(), cacheMember, hasSelf);
    }

    public static List<Member> getOrgSubs(ApproveBillSubMitDim submitDims, boolean hasSelf) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(submitDims.getModelId());
        Member cacheMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), submitDims.getViewId(), submitDims.getOrgId());
        return modelCacheHelper.getChildren(cacheMember, hasSelf);
    }

    private static Long getViewId(ApproveBillSubMitInfo rptInfo) {
        if (rptInfo instanceof ApproveBillSubMitInfo) {
            return rptInfo.getSubmitDims().getViewId();
        }
        if (rptInfo instanceof ApproveBillSubMitInfoEB) {
            return null;
        }
        return null;
    }

    public static void addErrIntoResult(String title, String message, OperationResult out_refResult) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(title);
        operateErrorInfo.setMessage(message);
        operateErrorInfo.setLevel(ErrorLevel.Warning);
        out_refResult.addErrorInfo(operateErrorInfo);
        out_refResult.setBillCount(out_refResult.getAllErrorInfo().size());
    }
}

