/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.approveBill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.CentralBillRptSubmitHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillQuery {
    private static final Log log = LogFactory.getLog(ApproveBillQuery.class);
    public static final String APPROVE_LOCK_TYPE = "APPROVE_LOCK_TYPE";
    public static final String NO_LOCK = "NO_LOCK";
    public static final String APPROVE_NO_LOCK = "APPROVE_NO_LOCK";
    public static final String LOCK_ALL = "LOCK_ALL";
    private static final ApproveBillQuery instance = new ApproveBillQuery();

    public static ApproveBillQuery getInstance() {
        return instance;
    }

    public DynamicObject[] queryBillInfsByIds(Set<Long> canDoBills) {
        if (canDoBills == null || canDoBills.size() == 0) {
            return null;
        }
        String selects = "id,billno,modelid.id,billstatus,createrid.id,eborgid.id,dim_datatype.id,dim_period.id,dim_version.id,entryentity.tempid,orgviewid.id,bizmodelid.id,committype,selectorg,parentbillid";
        return BusinessDataServiceHelper.load((String)"eb_approvebill", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "in", canDoBills)});
    }

    public DynamicObject[] queryBillInfs(ApproveBillSubMitDim subMitDim) {
        if (subMitDim == null) {
            return null;
        }
        String selects = "id";
        QFilter qFilter = new QFilter("dim_datatype.id", "=", (Object)subMitDim.getDataTypeId()).and("modelid.id", "=", (Object)subMitDim.getModelId()).and("eborgid.id", "=", (Object)subMitDim.getOrgId()).and("dim_version.id", "=", (Object)subMitDim.getVersionId()).and("dim_period.id", "=", (Object)subMitDim.getYearPeriodId()).and("orgviewid.id", "=", (Object)subMitDim.getViewId()).and("bizmodelid.id", "=", (Object)subMitDim.getBizModelId()).and("selectorg", "=", (Object)subMitDim.getSelectOrg()).and("billstatus", "not in", Arrays.asList(ApproveBillStatus.SAVE.getNumber(), ApproveBillStatus.REJECT.getNumber(), ApproveBillStatus.DISCARD.getNumber()));
        return BusinessDataServiceHelper.load((String)"eb_approvebill", (String)selects, (QFilter[])qFilter.toArray());
    }

    public Collection<ApproveBillInfo> getMasterSubmitBills(Collection<ApproveBillInfo> appBills) {
        if (appBills == null || appBills.size() == 0) {
            return null;
        }
        ArrayList<ApproveBillInfo> returns = new ArrayList<ApproveBillInfo>(appBills.size());
        for (ApproveBillInfo appBill : appBills) {
            if (!appBill.isMaster()) continue;
            returns.add(appBill);
        }
        return returns;
    }

    public Collection<ApproveBillInfo> getSecondSubmitBills(Collection<ApproveBillInfo> appBills) {
        if (appBills == null || appBills.size() == 0) {
            return null;
        }
        ArrayList<ApproveBillInfo> returns = new ArrayList<ApproveBillInfo>(appBills.size());
        for (ApproveBillInfo appBill : appBills) {
            if (appBill.isMaster()) continue;
            returns.add(appBill);
        }
        return returns;
    }

    public Map<Long, ApproveBillInfo> getApproveBillInfos(ApproveBillSubMitDim submitDim, int type, boolean isIncludeA) {
        DynamicObject[] billInfos = this.queryBillInfos(submitDim, type, isIncludeA);
        return this.getApproveBillInfos(submitDim, billInfos);
    }

    public Map<Long, ApproveBillInfo> getApproveBillInfos(ApproveBillSubMitDim submitDim, DynamicObject[] dys) {
        if (dys == null || dys.length == 0) {
            return null;
        }
        HashMap<Long, ApproveBillInfo> returns = new HashMap<Long, ApproveBillInfo>(dys.length);
        for (DynamicObject dy : dys) {
            ApproveBillInfo billInfo = new ApproveBillInfo();
            ApproveBillSubMitDim subMitDim = new ApproveBillSubMitDim();
            billInfo.setFid(dy.getLong("id"));
            billInfo.setBillNo(dy.getString("billno"));
            billInfo.setBillStatus(dy.getString("billstatus"));
            billInfo.setCreatorId(dy.getLong("createrid.id"));
            billInfo.setMaster(submitDim == null ? false : submitDim.getOrgId().compareTo(dy.getLong("eborgid.id")) == 0);
            subMitDim.setModelId(dy.getLong("modelid.id"));
            subMitDim.setOrgId(dy.getLong("eborgid.id"));
            subMitDim.setDataTypeId(dy.getLong("dim_datatype.id"));
            subMitDim.setVersionId(dy.getLong("dim_version.id"));
            subMitDim.setYearPeriodId(dy.getLong("dim_period.id"));
            DynamicObjectCollection dt = (DynamicObjectCollection)dy.get("entryentity");
            HashSet<Long> tempIds = new HashSet<Long>(dt.size());
            for (int i = 0; i < dt.size(); ++i) {
                tempIds.add(((DynamicObject)dt.get(i)).getLong("tempid.id"));
            }
            subMitDim.setTempIds(tempIds);
            billInfo.setSubMitDim(subMitDim);
            returns.put(billInfo.getFid(), billInfo);
        }
        return returns;
    }

    public Map<Long, ApproveBillSubMitDim> getApproveBillSubMitDims(List<DynamicObject> billInfos) {
        LinkedHashMap<Long, ApproveBillSubMitDim> returns = new LinkedHashMap<Long, ApproveBillSubMitDim>(16);
        if (billInfos == null || billInfos.size() == 0) {
            return null;
        }
        for (DynamicObject doc : billInfos) {
            returns.put(doc.getLong("id"), this.getApproveBillSubMitDim(doc));
        }
        return returns;
    }

    public ApproveBillSubMitDim getApproveBillSubMitDim(DynamicObject billInfo) {
        ApproveBillSubMitDim subMitDim = new ApproveBillSubMitDim();
        subMitDim.setDataTypeId(billInfo.getLong("dim_datatype.id"));
        subMitDim.setModelId(billInfo.getLong("modelid.id"));
        subMitDim.setOrgId(billInfo.getLong("eborgid.id"));
        subMitDim.setVersionId(billInfo.getLong("dim_version.id"));
        subMitDim.setYearPeriodId(billInfo.getLong("dim_period.id"));
        subMitDim.setViewId(billInfo.getLong("orgviewid.id"));
        subMitDim.setBizModelId(billInfo.getLong("bizmodelid.id"));
        subMitDim.setCommitType(billInfo.getString("committype"));
        subMitDim.setSelectOrg(billInfo.getString("eborgid.number"));
        DynamicObjectCollection dt = (DynamicObjectCollection)billInfo.get("entryentity");
        HashSet<Long> tempIds = new HashSet<Long>(dt.size());
        for (int i = 0; i < dt.size(); ++i) {
            tempIds.add(((DynamicObject)dt.get(i)).getLong("tempid_id"));
        }
        subMitDim.setTempIds(tempIds);
        return subMitDim;
    }

    private DynamicObject[] queryBillInfos(ApproveBillSubMitDim subMitDim, int type, boolean isIncludeA) {
        if (subMitDim == null || subMitDim.getModelId() == null || subMitDim.getVersionId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u7ef4\u5ea6\u83b7\u53d6\u5df2\u63d0\u4ea4\u7684\u5355\u636e\u51fa\u9519\uff0c\u7ec4\u7ec7\u6216\u8005\u7248\u672c\u4e3a\u7a7a\u3002", (String)"ApproveBillQuery_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        String selectFiled = "id,billno,modelid.id,billstatus,createrid.id,eborgid.id,dim_datatype.id,dim_period.id,dim_version.id,entryentity.tempid";
        QFilter qFilter = this.getFilter(subMitDim, type, isIncludeA);
        qFilter.and("modelid", "=", (Object)subMitDim.getModelId());
        if (CollectionUtils.isNotEmpty(subMitDim.getTempIds())) {
            qFilter.and("entryentity.tempid", "in", subMitDim.getTempIds());
        }
        qFilter.and("centralbilltype", "!=", (Object)CentralBillType.Child.getNumber());
        this.setOtherFilters(qFilter, subMitDim);
        return BusinessDataServiceHelper.load((String)"eb_approvebill", (String)selectFiled, (QFilter[])new QFilter[]{qFilter});
    }

    protected void setOtherFilters(QFilter qFilter, ApproveBillSubMitDim subMitDim) {
        qFilter.and("dim_period.id", "=", (Object)subMitDim.getYearPeriodId());
        qFilter.and("dim_datatype.id", "=", (Object)subMitDim.getDataTypeId());
        qFilter.and("dim_version.id", "=", (Object)subMitDim.getVersionId());
    }

    private QFilter getFilter(ApproveBillSubMitDim submitDim, int type, boolean isIncludeA) {
        if (submitDim == null) {
            return null;
        }
        ArrayList<Member> parents = new ArrayList(16);
        List<String> statusLsts = Arrays.asList("B", "D", "E");
        if (isIncludeA) {
            statusLsts = Arrays.asList("A", "B", "C", "D", "E");
        }
        QFilter qFilter = new QFilter("billstatus", "in", statusLsts);
        switch (type) {
            case 0: {
                qFilter.and("eborgid", "=", (Object)submitDim.getOrgId());
                break;
            }
            case 1: {
                parents = ApproveBillCommon.getOrgParents(submitDim, false);
                break;
            }
            case 2: {
                parents = ApproveBillCommon.getOrgParents(submitDim, true);
                break;
            }
            case 3: {
                parents = ApproveBillCommon.getOrgSubs(submitDim, false);
            }
        }
        if (parents != null && parents.size() > 0) {
            qFilter.and("eborgid", "in", this.getOrgsFromMembers(parents));
        }
        return qFilter;
    }

    private Set<Long> getOrgsFromMembers(List<Member> parents) {
        if (parents == null || parents.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(16);
        for (Member parent : parents) {
            returns.add(parent.getId());
        }
        return returns;
    }

    public Map<Long, String> getProcessOtherInfos(Set<Long> reportProcessIds) {
        if (reportProcessIds == null || reportProcessIds.size() == 0) {
            return null;
        }
        HashMap<Long, String> returns = new HashMap<Long, String>(reportProcessIds.size());
        String selects = "id,status,approvebill";
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"eb_reportprocess", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "in", reportProcessIds)});
        if (dys == null) {
            return null;
        }
        for (DynamicObject dy : dys) {
            DynamicObject approvebill = dy.getDynamicObject("approvebill");
            returns.put(dy.getLong("id"), StringUtils.join((Object[])new String[]{dy.getString("status"), "!", approvebill == null ? "0!!" : StringUtils.join((Object[])new String[]{approvebill.getString("id"), "!", approvebill.getString("billno"), "!", approvebill.getString("billstatus")})}));
        }
        return returns;
    }

    public String switchBillStatus2Rpt(String billStatus) {
        switch (billStatus) {
            case "A": {
                return BgTaskStateEnum.TEMPSAVE.getNumber();
            }
            case "F": 
            case "C": {
                return BgTaskStateEnum.INCOMPLETE.getNumber();
            }
            case "B": {
                return BgTaskStateEnum.UNDERWAY.getNumber();
            }
            case "E": {
                return BgTaskStateEnum.COMPLETED.getNumber();
            }
        }
        return BgTaskStateEnum.INCOMPLETE.getNumber();
    }

    public Integer getProcessStatus(Long reportProcessId) {
        return this.getProcessStatus(reportProcessId, 0L);
    }

    public Integer getProcessStatus(Long reportProcessId, Long approveBillId) {
        ApproveBillInfo approveBillInfo = null;
        if (IDUtils.isNotNull(approveBillId)) {
            approveBillInfo = ApproveBillHelper.queryBill(approveBillId);
        }
        return this.getProcessStatus(reportProcessId, approveBillInfo);
    }

    public String getProcessStatusStr(Long reportProcessId, Long approveBillId) {
        return this.getProcessStatus(reportProcessId, approveBillId).toString();
    }

    public Integer getProcessStatus(Long reportProcessId, ApproveBillInfo approveBillInfo) {
        if (approveBillInfo != null && approveBillInfo.getCentralBillType() == CentralBillType.Child) {
            if (IDUtils.isNotEmptyLong(approveBillInfo.getSourceRptId()).booleanValue()) {
                reportProcessId = approveBillInfo.getSourceRptId();
            }
            return Integer.valueOf(this.switchStatus4CentralBill(approveBillInfo.getBillId(), reportProcessId, approveBillInfo.getStatus4Rpt()));
        }
        String selects = "status";
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_reportprocess", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong(reportProcessId))});
        if (dy == null) {
            return 0;
        }
        return dy.get("status") == null ? 0 : dy.getInt("status");
    }

    public String switchStatus4CentralBill(Long billId, Long rptProcessId, String status) {
        if (BgTaskStateEnum.INCOMPLETE.getNumber().equals(status) && !CentralBillRptSubmitHelper.getNotSubmitRptProcessIds(billId).contains(rptProcessId)) {
            status = BgTaskStateEnum.UNDERWAY.getNumber();
        }
        return status;
    }

    public boolean getIsLock(String reportProcessId, ApproveBillInfo approveBillInfo, Long modelId, IFormView view) {
        if (StringUtils.isEmpty((CharSequence)reportProcessId)) {
            return false;
        }
        Long reportProcess = IDUtils.toLong(reportProcessId);
        Integer status = this.getProcessStatus(reportProcess, approveBillInfo);
        boolean isLock = false;
        switch (status) {
            case 3: {
                Long billId;
                boolean isVirtual = false;
                if (approveBillInfo != null) {
                    billId = approveBillInfo.getBillId();
                    if (!reportProcess.equals(approveBillInfo.getSourceRptId())) {
                        isVirtual = true;
                    }
                } else {
                    billId = 0L;
                }
                boolean approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, Long.parseLong(reportProcessId), view, billId, isVirtual);
                if (approveBillInfo != null && approveBillInfo.getCentralBillType() == CentralBillType.Main) {
                    approveAdjust = false;
                }
                isLock = !approveAdjust;
                break;
            }
            case 5: {
                isLock = true;
                break;
            }
        }
        boolean result = isLock;
        CommonServiceHelper.handleLogBySign(log, "getIsLock:billInfo", () -> String.format("getIsLock-s:%s,r:%s,l:%s,b:%s", status, reportProcessId, result, SerializationUtils.toJsonString((Object)approveBillInfo)), "ApproveBillQuery", "getIsLock");
        return isLock;
    }

    public ApproveBillSubMitDim loadSubMitDimOnBill(Long billId) {
        DynamicObject[] dynamicObjects = this.queryBillInfsByIds(Sets.newHashSet((Object[])new Long[]{billId}));
        ApproveBillSubMitDim mitDim = null;
        if (dynamicObjects.length > 0) {
            mitDim = this.getApproveBillSubMitDim(dynamicObjects[0]);
        }
        return mitDim;
    }
}

