/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;

public class CentralBillRptSubmitHelper {
    private static final Log log = LogFactory.getLog(CentralBillRptSubmitHelper.class);
    private static final String insertSql = "insert into  t_eb_centralbillrptsubmit (fid,fbillid,frptprocessid,fsubmit,fmodfiyuser,fmodifytime) values(?,?,?,?,?,?)";
    private static final String updateSql = "update t_eb_centralbillrptsubmit set fsubmit = '1',fmodfiyuser = ?,fmodifytime = ? where fbillid = ? and frptprocessid = ?";
    private static final String delSql = "delete from t_eb_centralbillrptsubmit where fbillid in (%s)";
    private static final String selTempSql = "select frptprocessid from t_eb_centralbillrptsubmit where fbillid = ? and fsubmit = '0'";
    private static final String selTempSqls = "select frptprocessid from t_eb_centralbillrptsubmit where fbillid = ? and fsubmit = '0'";

    public static void buildSubmitRecord(ApproveBillInfo approveBillInfo) {
        if (approveBillInfo == null || !approveBillInfo.isCentralBill()) {
            return;
        }
        Set<Long> templateIds = approveBillInfo.getTemplates();
        if (CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        Long billId = approveBillInfo.getBillId();
        ApproveBillSubMitDim subMitDim = approveBillInfo.getSubMitDim();
        if (subMitDim == null && (subMitDim = ApproveBillQuery.getInstance().loadSubMitDimOnBill(approveBillInfo.getBillId())) == null) {
            return;
        }
        Set<Long> rptProcessIds = ReportProcessServiceImpl.getInstance().queryRefRptProcessByBill(subMitDim);
        if (rptProcessIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(templateIds.size());
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        long[] ids = GlobalIdUtil.genGlobalLongIds(rptProcessIds.size());
        int seq = 0;
        for (Long rptProcessId : rptProcessIds) {
            Object[] row = new Object[]{ids[seq], billId, rptProcessId, false, userId, now};
            rows.add(row);
            ++seq;
        }
        try (TXHandle tx = TX.required();){
            try {
                CentralBillRptSubmitHelper.delSubmitRecord(Collections.singletonList(billId));
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)insertSql, rows);
            }
            catch (Throwable ex) {
                tx.markRollback();
                throw ex;
            }
        }
        log.info(String.format("buildSubmitRecord:%s--%s", billId, templateIds));
    }

    public static void markRptSubmit(Long billId, Long rptProcessId) {
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)updateSql, (Object[])new Object[]{UserUtils.getUserId(), TimeServiceHelper.now(), billId, rptProcessId});
        log.info(String.format("markRptSubmit:%s--%s", billId, rptProcessId));
    }

    public static void markRptSubmit(Long billId, Collection<Long> rptProcessIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_centralbillrptsubmit set fsubmit = '1',fmodfiyuser = ?,fmodifytime = ? where fbillid = ? and ", new Object[]{UserUtils.getUserId(), TimeServiceHelper.now(), billId});
        sqlBuilder.appendIn("frptprocessid", rptProcessIds.toArray());
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);
        log.info(String.format("markRptSubmit:%s--%s", billId, rptProcessIds));
    }

    public static void delSubmitRecord(Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        String delSqlStr = String.format(delSql, SqlBatchUtils.getBatchParamsSql(billIds.size()));
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)delSqlStr, (Object[])billIds.toArray());
        log.info(String.format("delSubmitRecord:%s", billIds));
    }

    public static Set<Long> getNotSubmitRptProcessIds(Long billId) {
        HashSet<Long> processIds = new HashSet<Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)BgFormConstant.DBROUTE, (String)"select frptprocessid from t_eb_centralbillrptsubmit where fbillid = ? and fsubmit = '0'", (Object[])new Object[]{billId});){
            for (Row row : dataSet) {
                processIds.add(row.getLong("frptprocessid"));
            }
        }
        return processIds;
    }

    public static Map<Long, Set<Long>> getNotSubmitRptProcessIds(Collection<Long> billIds) {
        HashMap<Long, Set<Long>> processMap = new HashMap<Long, Set<Long>>(16);
        if (billIds == null || billIds.size() == 0) {
            return processMap;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fbillid, frptprocessid from t_eb_centralbillrptsubmit where fsubmit = '0' and ", new Object[0]);
        sqlBuilder.appendIn("fbillid", billIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("fbillid");
                if (billId == null || billId == 0L) continue;
                Set processIds = processMap.computeIfAbsent(billId, k -> new HashSet(16));
                processIds.add(row.getLong("frptprocessid"));
            }
        }
        return processMap;
    }
}

