/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock;

import kd.bos.exception.KDBizException;

public enum BgmdDataLockApplyEnum {
    M12("m12", 0),
    M11("m11", 1),
    M10("m10", 2),
    M09("m09", 3),
    M08("m08", 4),
    M07("m07", 5),
    M06("m06", 6),
    M05("m05", 7),
    M04("m04", 8),
    M03("m03", 9),
    M02("m02", 10),
    M01("m01", 11),
    Q4("q4", 12),
    Q3("q3", 13),
    Q2("q2", 14),
    Q1("q1", 15),
    HF2("hf2", 16),
    HF1("hf1", 17),
    YEAR_TOTAL("yeartotal", 18);

    private String number;
    private Integer value;

    public String getNumber() {
        return this.number;
    }

    public Integer getValue() {
        return this.value;
    }

    private BgmdDataLockApplyEnum(String number, Integer value) {
        this.number = number;
        this.value = value;
    }

    public static BgmdDataLockApplyEnum getEnumByNumber(String number) {
        for (BgmdDataLockApplyEnum status : BgmdDataLockApplyEnum.values()) {
            if (!status.getNumber().equals(number)) continue;
            return status;
        }
        throw new KDBizException("error report number: " + number);
    }

    public static Boolean checkParentIsLock(Integer preValue, int oldValue) {
        if (preValue >= M12.getValue() && preValue <= M10.getValue()) {
            if ((oldValue >> Q4.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> HF2.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= M09.getValue() && preValue <= M07.getValue()) {
            if ((oldValue >> Q3.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> HF2.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= M06.getValue() && preValue <= M04.getValue()) {
            if ((oldValue >> Q2.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> HF1.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= M03.getValue() && preValue <= M01.getValue()) {
            if ((oldValue >> Q1.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> HF1.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= Q4.getValue() && preValue <= Q3.getValue()) {
            if ((oldValue >> HF2.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= Q2.getValue() && preValue <= Q1.getValue()) {
            if ((oldValue >> HF1.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else if (preValue >= HF2.getValue() && preValue <= HF1.getValue()) {
            if ((oldValue >> YEAR_TOTAL.getValue() & 1) == 1) {
                return Boolean.TRUE;
            }
        } else {
            if (YEAR_TOTAL.getValue().equals(preValue)) {
                return Boolean.FALSE;
            }
            throw new KDBizException("error report value: " + preValue);
        }
        return Boolean.FALSE;
    }

    public static BgmdDataLockApplyEnum getEnumByValue(Integer value) {
        for (BgmdDataLockApplyEnum status : BgmdDataLockApplyEnum.values()) {
            if (!status.getValue().equals(value)) continue;
            return status;
        }
        throw new KDBizException("error report value: " + value);
    }
}

