/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock;

import java.util.Collections;
import java.util.Map;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;

public class BgmdDataLockCacheHelper {
    private static final BgmdDataLockService service = BgmdDataLockService.getInstance();

    public static Map<String, Map<String, Integer>> getDataLock(Long modelId, Long businessModelId) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || IDUtils.isEmptyLong(businessModelId).booleanValue()) {
            return Collections.emptyMap();
        }
        String cacheKey = BgmdDataLockUtils.getCacheKey(modelId, businessModelId);
        Map<String, Map<String, Integer>> caches = CacheServiceHelper.get(cacheKey, Map.class);
        if (caches == null) {
            caches = service.buildCache(modelId, businessModelId);
            CacheServiceHelper.put(cacheKey, caches);
        }
        return caches;
    }

    public static void clearDataLock(Long modelId, Long businessModelId) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || IDUtils.isEmptyLong(businessModelId).booleanValue()) {
            return;
        }
        String cacheKey = BgmdDataLockUtils.getCacheKey(modelId, businessModelId);
        CacheServiceHelper.remove(cacheKey);
    }
}

