/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodTreeNode;

public class BgmdDataLockPeriodPolymer {
    private static BgmdDataLockPeriodTreeNode rootNode = null;
    private static List<BgmdDataLockPeriodTreeNode> treeNodeSort = null;
    private static Map<String, BgmdDataLockPeriodTreeNode> treeNodeMap = null;

    public static BgmdDataLockPeriodTreeNode getRootNode() {
        return rootNode;
    }

    public static List<BgmdDataLockPeriodTreeNode> getTreeNodeSort() {
        return treeNodeSort;
    }

    public static Map<String, BgmdDataLockPeriodTreeNode> getTreeNodeMap() {
        return treeNodeMap;
    }

    private static void createNode() {
        int i;
        int totalSize = 19;
        treeNodeSort = Lists.newArrayListWithExpectedSize((int)totalSize);
        treeNodeMap = Maps.newHashMapWithExpectedSize((int)totalSize);
        int beginInteger = 1 << totalSize - 1;
        for (i = 0; i < totalSize; ++i) {
            int periods = beginInteger >> i;
            String periodNumber = BgmdDataLockPeriodPolymer.getPeriodNumber(i);
            String realNumber = BgmdDataLockPeriodPolymer.getRealNumber(i);
            BgmdDataLockPeriodTreeNode node = new BgmdDataLockPeriodTreeNode(periodNumber, i, periods);
            node.setRealNumber(realNumber);
            treeNodeSort.add(node);
            treeNodeMap.put(periodNumber, node);
        }
        rootNode = treeNodeSort.get(0);
        for (i = 6; i >= 0; --i) {
            BgmdDataLockPeriodTreeNode parentNode = treeNodeSort.get(i);
            String[] periodChildren = BgmdDataLockPeriodPolymer.getPeriodChildren(parentNode.getNumber());
            if (periodChildren == null) continue;
            ArrayList children = Lists.newArrayListWithExpectedSize((int)periodChildren.length);
            int periodsCascadeChildren = 0;
            for (String periodChild : periodChildren) {
                BgmdDataLockPeriodTreeNode child = treeNodeMap.get(periodChild);
                child.setParent(parentNode);
                periodsCascadeChildren |= child.getPeriodsCascadeChildren();
                children.add(child);
            }
            for (BgmdDataLockPeriodTreeNode periodChild : children) {
                periodChild.setCheckPeriods(periodsCascadeChildren);
            }
            parentNode.setChildren(children);
            parentNode.setPeriodsCascadeChildren(periodsCascadeChildren | parentNode.getPeriods());
        }
        for (BgmdDataLockPeriodTreeNode node : treeNodeSort) {
            node.setPeriodsCascadeParents(BgmdDataLockPeriodPolymer.genPeriodsCascadeParents(node));
        }
    }

    private static int genPeriodsCascadeParents(BgmdDataLockPeriodTreeNode node) {
        int periods = node.getPeriods();
        BgmdDataLockPeriodTreeNode parent = node.getParent();
        if (parent != null) {
            periods |= BgmdDataLockPeriodPolymer.genPeriodsCascadeParents(parent);
        }
        return periods;
    }

    public static String[] getPeriodChildren(String number) {
        switch (number) {
            case "yeartotal": {
                return new String[]{"hf1", "hf2"};
            }
            case "hf1": {
                return new String[]{"q1", "q2"};
            }
            case "hf2": {
                return new String[]{"q3", "q4"};
            }
            case "q1": {
                return new String[]{"m01", "m02", "m03"};
            }
            case "q2": {
                return new String[]{"m04", "m05", "m06"};
            }
            case "q3": {
                return new String[]{"m07", "m08", "m09"};
            }
            case "q4": {
                return new String[]{"m10", "m11", "m12"};
            }
        }
        return null;
    }

    public static String getPeriodNumber(int i) {
        switch (i) {
            case 0: {
                return "yeartotal";
            }
            case 1: {
                return "hf1";
            }
            case 2: {
                return "hf2";
            }
            case 3: {
                return "q1";
            }
            case 4: {
                return "q2";
            }
            case 5: {
                return "q3";
            }
            case 6: {
                return "q4";
            }
            case 7: {
                return "m01";
            }
            case 8: {
                return "m02";
            }
            case 9: {
                return "m03";
            }
            case 10: {
                return "m04";
            }
            case 11: {
                return "m05";
            }
            case 12: {
                return "m06";
            }
            case 13: {
                return "m07";
            }
            case 14: {
                return "m08";
            }
            case 15: {
                return "m09";
            }
            case 16: {
                return "m10";
            }
            case 17: {
                return "m11";
            }
            case 18: {
                return "m12";
            }
        }
        return null;
    }

    public static String getRealNumber(int i) {
        switch (i) {
            case 0: {
                return "";
            }
            case 1: {
                return ".HF1";
            }
            case 2: {
                return ".HF2";
            }
            case 3: {
                return ".Q1";
            }
            case 4: {
                return ".Q2";
            }
            case 5: {
                return ".Q3";
            }
            case 6: {
                return ".Q4";
            }
            case 7: {
                return ".M01";
            }
            case 8: {
                return ".M02";
            }
            case 9: {
                return ".M03";
            }
            case 10: {
                return ".M04";
            }
            case 11: {
                return ".M05";
            }
            case 12: {
                return ".M06";
            }
            case 13: {
                return ".M07";
            }
            case 14: {
                return ".M08";
            }
            case 15: {
                return ".M09";
            }
            case 16: {
                return ".M10";
            }
            case 17: {
                return ".M11";
            }
            case 18: {
                return ".M12";
            }
        }
        return null;
    }

    static {
        BgmdDataLockPeriodPolymer.createNode();
    }
}

